//
//   File : kvi_time.cpp
//   Creation date : Tue Sep 25 17:35:13 2001 GMT by Szymon Stefanek
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 2001 Szymon Stefanek (stefanek@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//


#define __LIBKVILIB__

#include "kvi_time.h"

#ifdef COMPILE_ON_WINDOWS
	#include <windows.h> // GetSystemTime


	void kvi_gettimeofday(struct timeval * tmv,struct timezone *)
	{
		SYSTEMTIME st;
		GetSystemTime(&st);

		tmv->tv_sec = (st.wHour * 3600) + (st.wMinute * 60) + (st.wSecond);
		tmv->tv_usec = st.wMilliseconds * 1000;
	}

#endif

void kvi_secondsToDaysHoursMinsSecs(unsigned int uSecs,
	unsigned int * uD,unsigned int * uH,unsigned int * uM,unsigned int * uS)
{
	*uD = uSecs / 86400;
	uSecs = uSecs % 86400;
	*uH = uSecs / 3600;
	uSecs = uSecs % 3600;
	*uM = uSecs / 60;
	*uS = uSecs % 60;
}
