#ifndef _KVI_PROCESS_H_
#define _KVI_PROCESS_H_

//
//   File : kvi_process.h
//   Creation date : Sun Jan 10 1999 16:24:29 by Szymon Stefanek
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 1999-2000 Szymon Stefanek (stefanek@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//

#include "kvi_settings.h"
#include "kvi_string.h"
#include "kvi_list.h"

//#ifndef _KVI_PROCESS_CPP_

extern KVILIB_API bool kvi_runProcess(KviStr & szCommand,KviPtrList<KviStr> * pArgs);

//#endif

/*

//
//  Simple versions of the KProcess and KProcessController classes
//  original code by (C) Christian Czezatke
//  e9025461@student.tuwien.ac.at
//  Really good work :)
//

#include "kvi_string.h"

#include <qobject.h>
#include <qsocketnotifier.h>

#include <sys/types.h>
#include <signal.h>
#include "kvi_list.h"

class KviProcess;

class KviProcessController : public QObject
{
	Q_OBJECT
	friend class KviProcess;
protected:
	KviProcessController();
public:
	~KviProcessController();
public:
	int m_fd[2];
private:
	KviPtrList<KviProcess> *m_pProcessList;
	QSocketNotifier *m_pNotifier;
protected:
	void addProcess(KviProcess *proc);
	void removeProcess(KviProcess *proc);
	bool doHousekeeping(int pid,int status,bool bNotifyProcess);
	void setupSignalHandler();
protected slots:
	void slotDoHousekeeping(int);
};

class KviProcess : public QObject
{
	Q_OBJECT
	friend class KviProcessController;
public:
	KviProcess();
	~KviProcess();
private:
	pid_t m_pid;
	bool m_bIsRunning;
	bool m_bKillOnClose;
	bool m_bCommunicate;
	int m_stdinSock[2]; //0 parent sockets , 1 child sockets
#define PROC_SOCKET_PARENT 0
#define PROC_SOCKET_CHILD 1
	int m_stdoutSock[2];
	int m_stderrSock[2];
	QSocketNotifier * m_pStdoutNotifier;
	QSocketNotifier * m_pStderrNotifier;
	static KviStr m_szShellName;
	int m_iSocketErrors;
public:

	bool run(int (*routine)(void *),void * argument,bool bCommunicate=false,bool bKillOnClose=false);
	bool run(const char *commandline,bool bCommunicate=false,bool bKillOnClose=false,bool bExecInSubshell=false);
	bool isActive(){ return m_bIsRunning; };
	pid_t pid(){ return m_pid; };
	bool sendSignal(int sig=SIGKILL);
	bool writeData(const char *buffer,int len);
	bool findShell(KviStr &buffer);
signals:
	void terminated(KviProcess *proc,int status);
	void processStdout(KviProcess *proc,char *buffer,int buflen);
	void processStderr(KviProcess *proc,char *buffer,int buflen);
private:
	bool setupSockets();
	void killSockets();
	void clearSockVariables();
	bool child_setupSockets();
	bool parent_setupSockets();
protected:
	void processTerminated(int status);
	void processHasExited(int status);
private slots:
	void receivedStdout(int fd);
	void receivedStderr(int fd);
};
*/
#endif //_KVI_PROCESS_H_
