#ifndef _KVI_LOCALE_H_
#define _KVI_LOCALE_H_

//
//   File : kvi_locale.h
//   Creation date : Sat Jan 16 1999 18:15:01 by Szymon Stefanek
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 1999-2000 Szymon Stefanek (stefanek@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//

#include "kvi_settings.h"


#include <qapplication.h>

#ifdef _KVI_LOCALE_CPP_

	#ifdef COMPILE_LOCALE_STUFF

		#include <qtranslator.h>
		#include <qstring.h>

		class KVILIB_API KviTranslator : public QTranslator
		{
			Q_OBJECT
			public:
				KviTranslator(QObject * parent,const char * name);
				~KviTranslator();
			public:
				virtual QString find(const char * scope,const char * message) const;
		};
	
	#endif

#endif //_KVI_LOCALE_CPP_

extern KVILIB_API bool kvi_initLocale(QApplication * app,const char * localeDir);
extern KVILIB_API void kvi_destroyLocale(QApplication * app);
extern KVILIB_API char * kvi_getLocaleName();

#ifdef COMPILE_LOCALE_STUFF

	#define __tr(__text__) kvi_translate(__text__)
	#define __tr_no_lookup(__text__) __text__
	#define __tr_no_xgettext(__text__) kvi_translate(__text__)
	
	// This one returns the string text translated
	// reading it from the current translation map
	// if no map is available or the entry is not found
	// it returns the string untranslated
	extern KVILIB_API const char * kvi_translate(const char *text);
	
#else

	#define __tr(__text__) __text__
	#define __tr_no_lookup(__text__) __text__
	#define __tr_no_xgettext(__text__) __text__

#endif //!COMPILE_LOCALE_STUFF


#endif //!_KVI_LOCALE_H_
