#ifndef _KVI_NICKSERV_H_
#define _KVI_NICKSERV_H_
//
//   File : kvi_nickserv.h
//   Creation date : Thu Aug 09 2001 16:43:56 by Szymon Stefanek
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 2001 Szymon Stefanek (stefanek@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//

#include "kvi_settings.h"

#include "kvi_string.h"
#include "kvi_ircmask.h"

#include <qasciidict.h>
#include "kvi_list.h"

typedef struct _KviNickServEntry
{
	KviStr szServerMask;
	KviStr szNickServMask;
	int iServerNonWildcards;
	KviStr szIdentifyCommand;

} KviNickServEntry;

typedef KviPtrList<KviNickServEntry> KviNickServEntryList;

class KVILIB_API KviNickServDataBase
{
	friend class KviNickServOptionsWidget;
public:
	KviNickServDataBase();
	~KviNickServDataBase();
private:
	// Maps MYNICKNAMES -> list of entries
	QAsciiDict<KviNickServEntryList> * m_pEntryDict;
protected:
	QAsciiDict<KviNickServEntryList> * entryDict(){ return m_pEntryDict; };
	void insertEntry(const char * szNick,const char * szServerMask,const char * szNickServMask,const char * szIdentifyCommand);
	void clear();
private:
	KviNickServEntryList * findEntryList(const char * nick){ return m_pEntryDict->find(nick); };
	KviNickServEntryList * getEntryList(const char * nick);
	KviNickServEntry * findEntry(const char * szNick,const char * szServer,KviIrcMask * nickServMask);
public:
	const char * findIdentifyCommand(const char * szNick,const char * szServer,KviIrcMask * nickServMask);
	void save(const char * filename);
	void load(const char * filename);
};


#endif // _KVI_NICKSERV_H_
