#ifndef _KVI_IRCUSERDB_H_
#define _KVI_IRCUSERDB_H_

//
//   File : kvi_ircuserdb.h
//   Creation date : Mon Jul 31 2000 20:59:12 by Szymon Stefanek
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 1999-2000 Szymon Stefanek (stefanek@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//

#include "kvi_settings.h"

#include <qasciidict.h>

#include "kvi_string.h"
#include "kvi_avatar.h"

class KviIrcUserDataBase;



class KVILIB_API KviIrcUserEntry
{
	friend class KviIrcUserDataBase;
public:
	KviIrcUserEntry(const char * user,const char * host);
	~KviIrcUserEntry();
protected:
	KviStr      m_szUser;
	KviStr      m_szHost;

	KviStr      m_szServer;
	KviStr      m_szRealName;
	int         m_iHops;

	KviAvatar * m_pAvatar;

	int         m_nRefs;
public:
	void setUser(const char * user)   { m_szUser = user; };
	bool hasUser()                    { return m_szUser.hasData(); };
	void setHost(const char * host)   { m_szHost = host; };
	bool hasHost()                    { return m_szHost.hasData(); };
	void setServer(const char * serv) { m_szServer = serv; };
	void setRealName(const char * rn) { m_szRealName = rn; };
	void setHops(int hops)            { m_iHops = hops; };
	const char * user()               { return m_szUser.ptr(); };
	const char * host()               { return m_szHost.ptr(); };
	bool hasServer()                  { return m_szServer.hasData(); };
	const char * server()             { return m_szServer.ptr(); };
	bool hasRealName()                { return m_szRealName.hasData(); };
	const char * realName()           { return m_szRealName.ptr(); };
	bool hasHops()                    { return m_iHops >= 0; };
	int hops()                        { return m_iHops; };
	KviAvatar * avatar()              { return m_pAvatar; };
	int nRefs()                       { return m_nRefs; };
	// warning! the ownership passes to this class!
	void setAvatar(KviAvatar * av = 0);
	KviAvatar * forgetAvatar();
};

#define KVI_USERFLAG_OP 1
#define KVI_USERFLAG_VOICE 2
#define KVI_USERFLAG_HALFOP 4

// 1 | 2 | 7
#define KVI_USERFLAG_MASK (KVI_USERFLAG_OP | KVI_USERFLAG_VOICE | KVI_USERFLAG_HALFOP)

class KVILIB_API KviIrcUserDataBase
{
public:
	KviIrcUserDataBase();
	~KviIrcUserDataBase();
private:
	QAsciiDict<KviIrcUserEntry> * m_pDict;
public:
	void clear();
	KviIrcUserEntry * insertUser(const char * nick,const char * user,const char * hostname);
	KviIrcUserEntry * find(const char * nick){ return m_pDict->find(nick); };
	void removeUser(const char * nick,KviIrcUserEntry * e);
};

#endif //_KVI_IRCUSERDB_H_
