//
//   File : kvi_ircuserdb.cpp
//   Creation date : Mon Jul 31 2000 21:23:22 by Szymon Stefanek
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 1999-2000 Szymon Stefanek (stefanek@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//

#define __LIBKVILIB__

#define _KVI_DEBUG_CHECK_RANGE_
#include "kvi_debug.h"
#include "kvi_ircuserdb.h"




KviIrcUserEntry::KviIrcUserEntry(const char * user,const char * host)
{
	m_szUser     = user;
	m_szHost     = host;
	m_pAvatar    = 0;
	m_nRefs      = 1;

	m_szServer   = "";
	m_szRealName = "";
	m_iHops      = -1;
}

KviIrcUserEntry::~KviIrcUserEntry()
{
	if(m_pAvatar)delete m_pAvatar;
}

void KviIrcUserEntry::setAvatar(KviAvatar * av)
{
	if(m_pAvatar)delete m_pAvatar;
	m_pAvatar = av;
}

KviAvatar * KviIrcUserEntry::forgetAvatar()
{
	KviAvatar * ret = m_pAvatar;
	m_pAvatar = 0;
	return ret;
}



KviIrcUserDataBase::KviIrcUserDataBase()
{
	// we expect a maximum of ~4000 users (= ~16 KB array on a 32 bit machine)
	// ...after that we will loose in performance
	// ... well...4000 users is a really big number...say 6-7 really big channels
	// (4001 is prime)
	// up to 12000 users we will have a reasonably fast access.
	// the performance increase since kvirc versions < 3.0.0
	// is really big anyway (there was a linear list instead of a hash!!!)

	m_pDict = new QAsciiDict<KviIrcUserEntry>(4001,false,true);
	m_pDict->setAutoDelete(true);
}

KviIrcUserDataBase::~KviIrcUserDataBase()
{
	delete m_pDict;
}

void KviIrcUserDataBase::clear()
{
	delete m_pDict;
	m_pDict = new QAsciiDict<KviIrcUserEntry>(4001,false,true);
	m_pDict->setAutoDelete(true);
}

KviIrcUserEntry * KviIrcUserDataBase::insertUser(const char * nick,const char * user,const char * hostname)
{
	KviIrcUserEntry * e = m_pDict->find(nick);
	if(e)
	{
		e->m_nRefs++;
		if(e->m_szUser.isEmpty())
		{
			e->m_szUser = user ? user : "";
			e->m_szHost = hostname ? hostname : "";
		}
	} else {
		e = new KviIrcUserEntry(user ? user : "",hostname ? hostname : "");
		m_pDict->insert(nick,e);
	}
	return e;
}

//void KviIrcUserDataBase::removeUser(const char * nick)
//{
//	KviIrcUserEntry * e = m_pDict->find(nick);
//	__range_valid(e);
//	if(e)
//	{
//		e->nRefs--;
//		if(e->nRefs == 0)m_pDict->remove(nick);
//	}
//}

void KviIrcUserDataBase::removeUser(const char * nick,KviIrcUserEntry * e)
{
	__range_valid(e == m_pDict->find(nick));
	e->m_nRefs--;
	if(e->m_nRefs == 0)m_pDict->remove(nick);
}

//
//void KviIrcUserDataBase::nickChange(const char * nick,const char * newNick)
//{
//	KviIrcUserEntry * e = m_pDict->find(nick);
//	__range_valid(e);
//	if(e)
//	{
//		KviIrcUserEntry * n = new KviIrcUserEntry;
//		n->szUser = e->szUser;
//		n->szHostname = e->szHostname;
//		n->nRefs = e->nRefs;
//		m_pDict->remove(nick);
//		m_pDict->insert(newNick,n);
//	}
//}
