#ifndef _KVI_IRCSERVERDB_H_
#define _KVI_IRCSERVERDB_H_

//
//   File : kvi_ircserverdb.h
//   Creation date : Mon Jul 10 2000 14:15:42 by Szymon Stefanek
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 1999-2000 Szymon Stefanek (stefanek@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//

#include "kvi_settings.h"
#include "kvi_string.h"
#include "kvi_ircserver.h"

class KVILIB_API KviIrcServerDataBase
{
public:
	KviIrcServerDataBase();
	~KviIrcServerDataBase();
private:
	KviPtrList<KviIrcNetwork> * m_pNetworkList;
	KviIrcNetwork        * m_pCurrentNetwork;
public:
	void clear();
	KviPtrList<KviIrcNetwork> * networkList(){ return m_pNetworkList; };
	KviIrcNetwork * currentNetwork(){ return m_pCurrentNetwork; };
	KviIrcNetwork * findNetwork(const char * name);
	void setCurrentNetwork(KviIrcNetwork *n);
	void load(const char * filename);
	void save(const char * filename);
	void insertNetwork(KviIrcNetwork * n);
	void updateServerIp(const char * server,const char *ip);
//	void disableCaching(const char * server);
	void iWantThisServerToBeTheCurrent(const char * server,unsigned short int uPort,bool bPortIsValid,bool bIpV6 = false,bool bSSL = false);
};

#endif //_KVI_IRCSERVERDB_H_
