//
//   File : kvi_ircserverdb.cpp
//   Creation date : Mon Jul 10 2000 14:25:00 by Szymon Stefanek
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 1999-2000 Szymon Stefanek (stefanek@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
#define __LIBKVILIB__

#include "kvi_ircserverdb.h"
#include "kvi_config.h"
#include "kvi_locale.h"
#include "kvi_netutils.h"

// NETWORK NAMES , SERVER NAMES & SERVER DESCRIPTIONS are in Latin1 charset

KviIrcServerDataBase::KviIrcServerDataBase()
{
	m_pNetworkList = new KviPtrList<KviIrcNetwork>;
	m_pNetworkList->setAutoDelete(true);
	m_pCurrentNetwork = 0;
}

KviIrcServerDataBase::~KviIrcServerDataBase()
{
	delete m_pNetworkList;
}

void KviIrcServerDataBase::clear()
{
//	delete m_pNetworkList;
//	m_pNetworkList = new KviPtrList<KviIrcNetwork>;
//	m_pNetworkList->setAutoDelete(true);
	m_pNetworkList->clear();
	m_pCurrentNetwork = 0;
}

void KviIrcServerDataBase::insertNetwork(KviIrcNetwork *n)
{
	int i = 0;
	for(KviIrcNetwork * net = m_pNetworkList->first();net;net = m_pNetworkList->next())
	{
		if(kvi_strcmpCI(net->m_szName.ptr(),n->m_szName.ptr()) > 0)
		{
			m_pNetworkList->insert(i,n);
			return;
		}
		i++;
	}
	m_pNetworkList->append(n);
}

KviIrcNetwork * KviIrcServerDataBase::findNetwork(const char * name)
{
	for(KviIrcNetwork * net = m_pNetworkList->first();net;net = m_pNetworkList->next())
	{
		if(kvi_strEqualCI(net->m_szName.ptr(),name))return net;
	}
	return 0;
}

void KviIrcServerDataBase::updateServerIp(const char * server,const char *ip)
{
	for(KviIrcNetwork * net = m_pNetworkList->first();net;net = m_pNetworkList->next())
	{
		KviIrcServer * srv = net->findServer(server);
		if(srv)
		{
			srv->m_szIp = ip;
			return;
		}
	}
}

//void KviIrcServerDataBase::disableCaching(const char * server)
//{
//	for(KviIrcNetwork * net = m_pNetworkList->first();net;net = m_pNetworkList->next())
//	{
//		KviIrcServer * srv = net->findServer(server);
//		if(srv)
//		{
//			srv->setCacheIp(false);
//		}
//	}
//}

void KviIrcServerDataBase::iWantThisServerToBeTheCurrent(const char * server,unsigned short int uPort,bool bPortIsValid,bool bIpV6,bool bSSL)
{
	for(KviIrcNetwork * net = m_pNetworkList->first();net;net = m_pNetworkList->next())
	{
		KviIrcServer * srv = net->findServer(server);
		if(srv)
		{
			if((bIpV6 == srv->isIpV6()) && (bSSL == srv->useSSL()))
			{
				if(bPortIsValid)srv->setPort(uPort);
				setCurrentNetwork(net);
				net->setCurrentServer(srv);
				return;
			}
		}
	}
	KviIrcNetwork * n = findNetwork(__tr("orphan_servers"));
	if(!n)
	{
		n = new KviIrcNetwork(__tr("orphan_servers"));
		insertNetwork(n);
	}
	KviIrcServer * s = new KviIrcServer();
	s->m_szHostname = server;
	if(kvi_isValidStringIp(server))
	{
		s->m_szIp = server;
		s->setCacheIp(true);
#ifdef COMPILE_IPV6_SUPPORT
	} else {
		if(kvi_isValidStringIp_V6(server))
		{
			s->m_szIp = server;
			s->setCacheIp(true);
			bIpV6 = true;
		}
	}
#else
	}
#endif
	s->m_uPort = bPortIsValid ? uPort : 6667;
	s->setIpV6(bIpV6);
	s->setUseSSL(bSSL);
	n->insertServer(s);
	setCurrentNetwork(n);
	n->setCurrentServer(s);
}

void KviIrcServerDataBase::setCurrentNetwork(KviIrcNetwork *n)
{
	if(m_pNetworkList->findRef(n) != -1)m_pCurrentNetwork = n;
}


void KviIrcServerDataBase::load(const char * filename)
{
	clear();
	KviConfig cfg(filename);

	KviConfigIterator it(*(cfg.dict()));
	while(it.current())
	{
		if(it.current()->count() > 0)
		{
			KviIrcNetwork * n = new KviIrcNetwork(it.currentKey());
			insertNetwork(n);
			cfg.setGroup(it.currentKey());
			int nServers = cfg.readIntEntry("NServers",0);
			if(cfg.readBoolEntry("Current",false))m_pCurrentNetwork = n;
			for(int i=0;i < nServers;i++)
			{
				KviIrcServer *s = new KviIrcServer();
				n->m_pServerList->append(s);
				KviStr tmp(KviStr::Format,"%d_Current",i);
				if(cfg.readBoolEntry(tmp.ptr(),false))n->m_pCurrentServer = s;
				tmp.sprintf("%d_Hostname",i);
				s->m_szHostname = cfg.readEntry(tmp.ptr(),"irc.unknown.net");
				tmp.sprintf("%d_Ip",i);
				s->m_szIp = cfg.readEntry(tmp.ptr(),"");
				tmp.sprintf("%d_Description",i);
				s->m_szDescription = cfg.readEntry(tmp.ptr(),"");
				tmp.sprintf("%d_User",i);
				s->m_szUser = cfg.readEntry(tmp.ptr(),"");
				tmp.sprintf("%d_Pass",i);
				s->m_szPass = cfg.readEntry(tmp.ptr(),"");
				tmp.sprintf("%d_Nick",i);
				s->m_szNick = cfg.readEntry(tmp.ptr(),"");
				tmp.sprintf("%d_RealName",i);
				s->m_szRealName = cfg.readEntry(tmp.ptr(),"");
				tmp.sprintf("%d_OnConnectCommand",i);
				s->m_szOnConnectCommand = cfg.readEntry(tmp.ptr(),"");
				tmp.sprintf("%d_Port",i);
				s->m_uPort = cfg.readUShortEntry(tmp.ptr(),6667);
				tmp.sprintf("%d_IpV6",i);
				bool bTmp = cfg.readBoolEntry(tmp.ptr(),false);
				s->setIpV6(bTmp);
				tmp.sprintf("%d_CacheIp",i);
				bTmp = cfg.readBoolEntry(tmp.ptr(),true);
				s->setCacheIp(bTmp);
				tmp.sprintf("%d_SSL",i);
				bTmp = cfg.readBoolEntry(tmp.ptr(),false);
				s->setUseSSL(bTmp);
			}
			if(!n->m_pCurrentServer)n->m_pCurrentServer = n->m_pServerList->first();
		}
		++it;
	}
	if(!m_pCurrentNetwork)m_pCurrentNetwork = m_pNetworkList->first();
}

void KviIrcServerDataBase::save(const char * filename)
{
	KviConfig cfg(filename);

	cfg.clear(); // clear any old entry

	for(KviIrcNetwork * n = m_pNetworkList->first();n;n = m_pNetworkList->next())
	{
		cfg.setGroup(n->m_szName.ptr());
		cfg.writeEntry("NServers",n->m_pServerList->count());
		if(n == m_pCurrentNetwork)cfg.writeEntry("Current",true);

		int i=0;
		for(KviIrcServer *s = n->m_pServerList->first();s;s = n->m_pServerList->next())
		{
			KviStr tmp(KviStr::Format,"%d_Hostname",i);
			cfg.writeEntry(tmp.ptr(),s->m_szHostname.ptr());
			if(s->m_szIp.hasData())
			{
				tmp.sprintf("%d_Ip",i);
				cfg.writeEntry(tmp.ptr(),s->m_szIp.ptr());
			}
			if(s->m_szDescription.hasData())
			{
				tmp.sprintf("%d_Description",i);
				cfg.writeEntry(tmp.ptr(),s->m_szDescription.ptr());
			}
			if(s->m_szUser.hasData())
			{
				tmp.sprintf("%d_User",i);
				cfg.writeEntry(tmp.ptr(),s->m_szUser.ptr());
			}
			if(s->m_szPass.hasData())
			{
				tmp.sprintf("%d_Pass",i);
				cfg.writeEntry(tmp.ptr(),s->m_szPass.ptr());
			}
			if(s->m_szNick.hasData())
			{
				tmp.sprintf("%d_Nick",i);
				cfg.writeEntry(tmp.ptr(),s->m_szNick.ptr());
			}
			if(s->m_szRealName.hasData())
			{
				tmp.sprintf("%d_RealName",i);
				cfg.writeEntry(tmp.ptr(),s->m_szRealName.ptr());
			}
			if(s->m_szOnConnectCommand.hasData())
			{
				tmp.sprintf("%d_OnConnectCommand",i);
				cfg.writeEntry(tmp.ptr(),s->m_szOnConnectCommand.ptr());
			}
			if(s->m_uPort != 6667)
			{
				tmp.sprintf("%d_Port",i);
				cfg.writeEntry(tmp.ptr(),s->m_uPort);
			}
			if(s->isIpV6())
			{
				tmp.sprintf("%d_IpV6",i);
				cfg.writeEntry(tmp.ptr(),s->isIpV6());
			}
			if(!(s->cacheIp()))
			{
				tmp.sprintf("%d_CacheIp",i);
				cfg.writeEntry(tmp.ptr(),s->cacheIp());
			}
			if(s->useSSL())
			{
				tmp.sprintf("%d_SSL",i);
				cfg.writeEntry(tmp.ptr(),s->useSSL());
			}
			if(s == n->m_pCurrentServer)
			{
				tmp.sprintf("%d_Current",i);
				cfg.writeEntry(tmp.ptr(),true);
			}
			i++;
		}
	}
}
