#ifndef _KVI_IRCSERVER_H_
#define _KVI_IRCSERVER_H_

//
//   File : kvi_ircserver.h
//   Creation date : Mon Jul 10 2000 03:24:11 by Szymon Stefanek
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 1999-2000 Szymon Stefanek (stefanek@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//

#include "kvi_settings.h"
#include "kvi_string.h"
#include "kvi_list.h"

#define KVI_IRCSERVER_FLAG_IPV6 1
#define KVI_IRCSERVER_FLAG_CACHEIP 2
#define KVI_IRCSERVER_FLAG_SSL 4

class KVILIB_API KviIrcServer
{
public:
	KviIrcServer();
	KviIrcServer(const KviIrcServer &serv);
	~KviIrcServer();
public:
	KviStr             m_szHostname;
	KviStr             m_szIp;
	KviStr             m_szDescription;
	unsigned short int m_uPort;
	unsigned short int m_uFlags;

	// Extended data
	KviStr             m_szUser;
	KviStr             m_szPass;
	KviStr             m_szNick;
	KviStr             m_szRealName;
	KviStr             m_szOnConnectCommand;

public:
	const char * ip() const { return m_szIp.ptr(); };
	const char * hostname() const { return m_szHostname.ptr(); };
	const char * description() const { return m_szDescription.ptr(); };
	const char * user() const { return m_szUser.ptr(); };
	const char * pass() const { return m_szPass.ptr(); };
	const char * nick() const { return m_szNick.ptr(); };
	const char * realName() const { return m_szRealName.ptr(); };
	const char * onConnectCommand() const { return m_szOnConnectCommand.ptr(); };
	unsigned short int port() const { return m_uPort; };
	void setPort(unsigned short int uPort)
	{
		m_uPort = uPort;
	};
	bool useSSL(){ return (m_uFlags & KVI_IRCSERVER_FLAG_SSL); };
	bool isIpV6(){ return (m_uFlags & KVI_IRCSERVER_FLAG_IPV6); };
	bool cacheIp(){ return (m_uFlags & KVI_IRCSERVER_FLAG_CACHEIP); };
	void setIpV6(bool bSet)
	{
		if(bSet)m_uFlags |= KVI_IRCSERVER_FLAG_IPV6;
		else m_uFlags &= ((unsigned short)~KVI_IRCSERVER_FLAG_IPV6);
	};
	void setUseSSL(bool bSet)
	{
		if(bSet)m_uFlags |= KVI_IRCSERVER_FLAG_SSL;
		else m_uFlags &= ((unsigned short)~KVI_IRCSERVER_FLAG_SSL);
	};
	void setCacheIp(bool bSet)
	{
		if(bSet)m_uFlags |= KVI_IRCSERVER_FLAG_CACHEIP;
		else m_uFlags &= ((unsigned short)~KVI_IRCSERVER_FLAG_CACHEIP);
	};
#ifdef COMPILE_ON_WINDOWS
	void * operator new(size_t tSize);
	void operator delete(void * p);
#endif
};

class KVILIB_API KviIrcNetwork
{
	friend class KviIrcServerDataBase;
public:
	KviIrcNetwork(const char * name);
	~KviIrcNetwork();
protected:
	KviIrcServer        * m_pCurrentServer;
	KviStr                m_szName;
	KviPtrList<KviIrcServer> * m_pServerList;
public:
	const char * name(){ return m_szName.ptr(); };
	KviPtrList<KviIrcServer> * serverList(){ return m_pServerList; };
	KviIrcServer * currentServer(){ return m_pCurrentServer; };
	void insertServer(KviIrcServer *srv);
	KviIrcServer *findServer(const char * hostname);
	void setCurrentServer(KviIrcServer *srv);
#ifdef COMPILE_ON_WINDOWS
	void * operator new(size_t tSize);
	void operator delete(void * p);
#endif
};

#endif //_KVI_IRCSERVER_H_
