//
//   File : kvi_ircserver.cpp
//   Creation date : Mon Jul 10 2000 03:42:59 by Szymon Stefanek
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 1999-2000 Szymon Stefanek (stefanek@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//

#define __LIBKVILIB__
#include "kvi_ircserver.h"
#include "kvi_malloc.h"

KviIrcServer::KviIrcServer()
{
	m_uFlags = 0;
	m_uPort  = 6667;
}

KviIrcServer::KviIrcServer(const KviIrcServer &serv)
{
	m_szHostname         = serv.m_szHostname;
	m_szIp               = serv.m_szIp;
	m_szDescription      = serv.m_szDescription;
	m_szUser             = serv.m_szUser;
	m_szPass             = serv.m_szPass;
	m_uPort              = serv.m_uPort;
	m_szNick             = serv.m_szNick;
	m_szRealName         = serv.m_szRealName;
	m_uFlags             = serv.m_uFlags;
	m_szOnConnectCommand = serv.m_szOnConnectCommand;
}

KviIrcServer::~KviIrcServer()
{
}


#ifdef COMPILE_ON_WINDOWS

	// MSVC++ calls the wrong operators from the executable
	// (this is a well known bug described in Q122675 of MSDN)
	// A solution that works for us is to override the new and delete operators

	void * KviIrcServer::operator new(size_t tSize)
	{
		return kvi_malloc(tSize);
	}

	void KviIrcServer::operator delete(void * p)
	{
		kvi_free(p);
	}

#endif

KviIrcNetwork::KviIrcNetwork(const char * name)
{
	m_pServerList = new KviPtrList<KviIrcServer>;
	m_pServerList->setAutoDelete(true);
	m_szName = name;
	m_pCurrentServer = 0;
}


KviIrcNetwork::~KviIrcNetwork()
{
	delete m_pServerList;
}

void KviIrcNetwork::insertServer(KviIrcServer *srv)
{
	m_pServerList->append(srv);
}

KviIrcServer * KviIrcNetwork::findServer(const char * hostname)
{
	for(KviIrcServer *s=m_pServerList->first();s;s=m_pServerList->next())
	{
		if(kvi_strEqualCI(s->m_szHostname.ptr(),hostname))return s;
	}
	return 0;
}


void KviIrcNetwork::setCurrentServer(KviIrcServer *srv)
{
	if(m_pServerList->findRef(srv) != -1)m_pCurrentServer = srv;
}


#ifdef COMPILE_ON_WINDOWS

	// MSVC++ calls the wrong operators from the executable
	// (this is a well known bug described in Q122675 of MSDN)
	// A solution that works for us is to override the new and delete operators

	void * KviIrcNetwork::operator new(size_t tSize)
	{
		return kvi_malloc(tSize);
	}

	void KviIrcNetwork::operator delete(void * p)
	{
		kvi_free(p);
	}

#endif
