#ifndef _KVI_AVATAR_H_
#define _KVI_AVATAR_H_

//
//   File : kvi_avatar.h
//   Creation date : Fri Dec 01 2000 13:54:04 CEST by Szymon Stefanek
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 1999-2000 Szymon Stefanek (stefanek@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//

#include "kvi_string.h"
#include "kvi_settings.h"

#include <qpixmap.h>

class KVILIB_API KviAvatar
{
public:
	// This class becomes the OWNER of the pixmap!
	// if bFullPathAsName is true , then the full path of the file
	// is needed to find the pixmap on the local storage devices
	// this happens usually when the local user sets his own avatar
	// For remote users bFullPathAsName is usually false
	KviAvatar(QPixmap * pix,const char * fullPath,bool bFullPathAsName = false);
	~KviAvatar();
private:
	QPixmap    * m_pPixmap;
	QPixmap    * m_pScaledPixmap;
	KviStr       m_szFullPath;
	KviStr       m_szName;
	unsigned int m_uLastScaleWidth;
	unsigned int m_uLastScaleHeight;
public:
	QPixmap * pixmap(){ return m_pPixmap; };
	QPixmap * scaledPixmap(unsigned int w,unsigned int h);
	const char * path(){ return m_szFullPath.ptr(); };
	const char * name(){ return m_szName.ptr(); };
};

#endif //_KVI_AVATAR_H_
