//
//   File : kvi_avatar.cpp
//   Creation date : Fri Dec 01 2000 13:58:12 CEST by Szymon Stefanek
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 2000-2001 Szymon Stefanek (stefanek@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//

#define __LIBKVILIB__

#include "kvi_avatar.h"

#include <qimage.h>

//#warning "Avatar doc to be rewritten"

/*
	@doc: ctcp_avatar
	@title:
		The AVATAR idea
	@short:
		Extending IRC fun: the AVATAR idea
	@body:
		[big]Introduction[/big]
		Starting from version 3.0.0 KVIrc supports the AVATAR protocol.
		The AVATAR term dictionary definitions include:[br]
		- Hindu mythology incarnation of a God[br]
		- Embodiment of a concept or philosophy[br]
		- In [b]cyberspace communities[/b], the rappresentation of an
		user in a shared virtual reality.[br]
		The AVATAR protocol attempts to improve the IRC communication
		by adding a method for associating a graphical rappresentation
		to an IRC user.[br]
		Since this may involve binary data transfers between users,
		the protocol is intended to be client based.
		[big]The terms[/big]
		The user that wants to offer a digital rappresentation of himself
		will be called "source user". The ones that will receive the notification
		will be called "target users".
		Every irc user can be either a source user or target user.
		[big]The idea[/big]
		Every irc user has a client-side property called AVATAR.
		On the source user side this property is initially "empty" for target users, and defined
		to some filename/image for the source user himself. When a source user wants to
		set his AVATAR property on a target's side , he sends a CTCP AVATAR message
		to the target. The syntax of this message is:[br]
		[b]AVATAR <filename>[/b][br]
		The target user's client will attempt to locate the image specified by <filename>
		on the local storage devices. If the image can be loaded, the source user's
		property on the target side will be set to the <filename>/image pair.
		The implementation of the AVATAR property setting is left to the client program:
		the image will be displayed in some way , associated to the source user on the target side.
		If the image can not be loaded, and if the CTCP message was sent as a PRIVMSG (ctcp request),
		the target user's client can send an automatic DCC GET <filename> request to the source user.
		If the CTCP message was sent as a NOTICE (ctcp reply), the initial AVATAR ctcp message
		will be notified to the target user and then discarded.
		[b]Example[/b]
		[br]
		Crocodile has a nice image of himself and wants to set it as the AVATAR property on pragma's side.[br]
		Crocodile sends the followind message:[br]
		[b]PRIVMSG pragma :<0x01>AVATAR Crocodile_my_smiling_face.png<0x01>[/b][br]
		Pragma looks for the file Crocodile_my_smiling_face.png on his local storage devices.
		If the file is found, he sets the Crocodile's AVATAR property to Crocodile_my_smiling_face.png.
		In effect, on the Pragma (target) side, Crocodile (the source) will have the image displayed near
		his entry in the channels or query windows.[br]
		If the file can not be found, pragma will request a copy of the file by sending
		the following DCC GET message to Crocodile:[br]
		[b]PRIVMSG Crocodile :<0x01>DCC GET Crocodile_my_smiling_face.png<0x01>[/b][br]
		[br]
		The implementation of the DCC GET protocol is defined by other documents.[br]
		After the DCC GET has been succesfully terminated, the target user's client
		will automatically set the AVATAR property of the source user to the <filename>/image pair.[br]
		The CTCP AVATAR message can be sent to a single user , a set of users or a channel:
		this depends only on the source user and how many clients he wants to reach.
		When sending it to a set of users or channel the source user must choose between
		sending it through a NOTICE message and thus accept "failures" or sending it as a PRIVMSG and
		be prepared to accept a big number of DCC GET requests.
		The <filename> should "tend to be unique": it is source user's (and client's) care
		to make it long and unique enough. The preferred form is <source nickname>_<few_words_image_description>.<extension>:
		this will help in keeping the filename unique, but it is not mandatory.
		Not unique filenames may resolve to "avatar image collisions" or improper
		image associations. This can be handled only by the source client side:
		the source user must provide a name that "tends to be unique". Another good tip
		could be "<source_nickname>_<image creation date as unsigned number>.<extension> .[br]
		This could be also handled by the source IRC client in some way: the source user
		may specify an image file as his AVATAR property and the IRC client could copy it to a
		suitable directory (where the file may be reached in order to serve the DCC GET requests)
		and rename it by using some good "unique name" algorithm.[br]
		The filename length is naturally limited by the IRC message maximum length and the
		user filesystem max filename length.[br]
		There should be a convention on the image sizes: not a protocol limit.
		For example, the convention could be that all the images should be smaller than
		129x129 pixels. The preferred image format is "png" (Portable Network Graphics)
		since it allows good compression rates without compromising the image quality.
		Other formats may be accepted as well (Theoretically this protocol could be
		extended to allow movies or 3D images).
		All these conventions should be applied by the source user and source user's client.
		The image file size (thus the source user's transmission time) depends on the image
		size and file format.
		The "preferred" image size may grow with time, as the network transmission speed grows.
*/

KviAvatar::KviAvatar(QPixmap * pix,const char * fullPath,bool bFullPathAsName)
{
	m_pPixmap = pix;
	m_pScaledPixmap = 0;
	if(m_pPixmap == 0)m_pPixmap = new QPixmap(32,32); // cool memory map :)
	m_szFullPath = fullPath;
	m_szName = m_szFullPath;
	if(!bFullPathAsName)m_szName.cutToLast('/');
}

KviAvatar::~KviAvatar()
{
	delete m_pPixmap;
	if(m_pScaledPixmap)delete m_pScaledPixmap;
}

QPixmap * KviAvatar::scaledPixmap(unsigned int w,unsigned int h)
{
	if(m_pScaledPixmap)
	{
		if((m_uLastScaleWidth == w) && (m_uLastScaleHeight == h))return m_pScaledPixmap;
		delete m_pScaledPixmap;
		m_pScaledPixmap = 0;
	}

	int curW = m_pPixmap->width();
	int curH = m_pPixmap->height();

	if(curW < 1)curW = 1;
	if(curH < 1)curH = 1;

	m_uLastScaleWidth = w;
	m_uLastScaleHeight = h;

	int scaleW = w;
	int scaleH = h;

	if(curW > curH)scaleH = (curH * scaleW) / curW;
	else scaleW = (scaleH * curW) / curH;
	
	QImage img = m_pPixmap->convertToImage();

	m_pScaledPixmap = new QPixmap();
	m_pScaledPixmap->convertFromImage(img.smoothScale(scaleW,scaleH));

	return m_pScaledPixmap;
}
