#ifndef _KVI_FILEUTILS_H_
#define _KVI_FILEUTILS_H_

//
//   File : kvi_fileutils.h
//   Creation date : Fri Dec 25 1998 18:27:04 by Szymon Stefanek
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 1999-2000 Szymon Stefanek (stefanek@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//

#include "kvi_settings.h"
#include "kvi_string.h"

#include <qfile.h>
#include <qstringlist.h>

#include <time.h>


#ifdef COMPILE_ON_WINDOWS
	#define KVI_PATH_SEPARATOR "\\"
	#define KVI_PATH_SEPARATOR_CHAR '\\'
#else
	#define KVI_PATH_SEPARATOR "/"
	#define KVI_PATH_SEPARATOR_CHAR '/'
#endif

// #warning "Add kvi_trashFile(const char * path) ? - is it needed in the whole app"
// #warning "or should it be availible only for dirbrowser module ?"


// Returns true if the path begins with '/'
KVILIB_API extern bool kvi_isAbsolutePath(const char *path);
// Simplifies the path from double separators , and eventually converts the separators
KVILIB_API extern void kvi_adjustFilePath(KviStr & path);
// Translates ANY string into a valid filename (with no path!)
// There is NO way to come back to the original string
// the algo is one-way only
KVILIB_API extern void kvi_encodeFileName(KviStr & path);
// Returns true if the file exists and IS a file
KVILIB_API extern bool kvi_fileExists(const char *path);
// kvi_fileExists & isReadable
KVILIB_API extern bool kvi_fileIsReadable(const char *path);
// Returns true if the file exists and IS a directory
KVILIB_API extern bool kvi_directoryExists(const char *path);
// Makes a directory (and eventually all the leading path)
KVILIB_API extern bool kvi_makeDir(const char *path);
// Loads a file to a buffer (false if the file does not exist)
KVILIB_API extern bool kvi_loadFile(const char *path,KviStr &buffer);
// Writes a buffer to a new file
KVILIB_API extern bool kvi_writeFile(const char *path,KviStr &buffer,bool bAppend = false);
// cp :)
KVILIB_API extern bool kvi_copyFile(const char *src,const char *dst);
// mv :)
KVILIB_API extern bool kvi_renameFile(const char *src,const char *dst);
// Reads a single line from the file and returns false if EOF was encountered.
KVILIB_API extern bool kvi_readLine(QFile *f,KviStr &str);
// Same as above but strips whitespace too.
KVILIB_API extern bool kvi_readStrippedLine(QFile *f,KviStr &str);
// Reads stripped lines until a non empty one is found...
// An empty line may be returned if EOF is found before reading any significant data.
KVILIB_API extern bool kvi_readFirstNonEmptyStrippedLine(QFile *f,KviStr &str);
// Writes a data line to the file f and returns false if an error occurs
KVILIB_API extern bool kvi_writeLine(QFile *f,const char *line);
// Removes a file
KVILIB_API extern bool kvi_removeFile(const char * path);
// Removes a dir
KVILIB_API extern bool kvi_removeDir(const char * path);

// File dialogs (DEAD)
//__kvi_extern QString kvi_askForDirectoryName(const char * basePath = 0);
//__kvi_extern QString kvi_askForOpenFileName(const char *basePath = 0,const char *filter = 0);
//__kvi_extern QStringList kvi_askForOpenFileNames(const char * basePath = 0,const char * filter = 0);
//__kvi_extern QString kvi_askForSaveFileName(const char *baseFileName = 0);

#endif //_KVI_FILEUTILS_H_INCLUDED_
