#ifndef _KVI_FILE_H_
#define _KVI_FILE_H_

//
//   File : kvi_file.h
//   Creation date : Mon Dec 17 2001 00:05:04 by Szymon Stefanek
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 2001 Szymon Stefanek (stefanek@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//

#include "kvi_settings.h"
#include "kvi_string.h"
#include "kvi_list.h"

#include <qfile.h>

#include <time.h>


class KVILIB_API KviFile : public QFile
{
public:
	KviFile();
	KviFile(const QString &name);
	~KviFile();
public:
	bool save(const KviStr &szData);
	bool load(KviStr &szData);

	bool save(int iData);
	bool load(int &iData);

	bool save(time_t tData);
	bool load(time_t &tData);

	bool save(unsigned int uData);
	bool load(unsigned int &uData);

	bool save(KviPtrList<KviStr> * pData);
	bool load(KviPtrList<KviStr> * pData);

#ifdef COMPILE_ON_WINDOWS
	// On windows we need to override new and delete operators
	// to ensure that always the right new/delete pair is called for an object instance
	// This bug is present in all the classes exported by a module that
	// can be instantiated/destroyed from external modules.
	// (this is a well known bug described in Q122675 of MSDN)
	void       * operator new(size_t tSize);
	void         operator delete(void * p);
#endif
};



#endif //_KVI_FILE_H_
