//
//   File : kvi_file.cpp
//   Creation date : Mon Dec 17 2001 00:04:12 by Szymon Stefanek
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 2001 Szymon Stefanek (stefanek@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//

#define __LIBKVILIB__

#include "kvi_file.h"

#ifdef COMPILE_ON_WINDOWS
	#include "kvi_malloc.h"
#endif

KviFile::KviFile()
: QFile()
{
}

KviFile::KviFile(const QString &name)
: QFile(name)
{
}

KviFile::~KviFile()
{
}

bool KviFile::save(const KviStr &szData)
{
	if(!save(szData.len()))return false;
	return (writeBlock(szData.ptr(),szData.len()) == szData.len());
}

bool KviFile::load(KviStr &szData)
{
	int iLen;
	if(!load(iLen))return false;
	szData.setLength(iLen);
	return (readBlock((char *)(szData.ptr()),iLen) == iLen);
}

bool KviFile::save(int iData)
{
	return (writeBlock((const char *)(&iData),sizeof(int)) == sizeof(int));
}

bool KviFile::load(int &iData)
{
	return (readBlock((char *)(&iData),sizeof(int)) == sizeof(int));
}

bool KviFile::save(unsigned int uData)
{
	return (writeBlock((const char *)(&uData),sizeof(unsigned int)) == sizeof(unsigned int));
}

bool KviFile::load(unsigned int &uData)
{
	return (readBlock((char *)(&uData),sizeof(unsigned int)) == sizeof(unsigned int));
}

bool KviFile::save(time_t tData)
{
	return (writeBlock((const char *)(&tData),sizeof(time_t)) == sizeof(time_t));
}

bool KviFile::load(time_t &tData)
{
	return (readBlock((char *)(&tData),sizeof(time_t)) == sizeof(time_t));
}

bool KviFile::save(KviPtrList<KviStr> * pData)
{
	if(!save((int)(pData->count())))return false;
	for(KviStr * s = pData->first();s;s = pData->next())
	{
		if(!save(*s))return false;
	}
	return true;
}

bool KviFile::load(KviPtrList<KviStr> * pData)
{
	pData->clear();
	int iCount;
	if(!load(iCount))return false;
	for(int i=0;i<iCount;i++)
	{
		KviStr * s = new KviStr();
		if(!load(*s))
		{
			delete s;
			return false;
		}
		pData->append(s);
	}
	return true;
}

#ifdef COMPILE_ON_WINDOWS

	// On windows we need to override new and delete operators
	// to ensure that always the right new/delete pair is called for an object instance
	// This bug is present in all the classes exported by a module that
	// can be instantiated/destroyed from external modules.
	// (this is a well known bug described in Q122675 of MSDN)

	void * KviFile::operator new(size_t tSize)
	{
		return kvi_malloc(tSize);
	}

	void KviFile::operator delete(void * p)
	{
		kvi_free(p);
	}

#endif
