#ifndef _KVI_XLIB_H_
#define _KVI_XLIB_H_
//
//   File : kvi_xlib.h
//   Creation date : Tue Aug 14 18:17:21 2001 GMT by Szymon Stefanek
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 2001 Szymon Stefanek (stefanek@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//

#include "kvi_settings.h"

#ifndef COMPILE_ON_WINDOWS

	#ifdef Bool
		// Someone has defined Bool ?
		#undef Bool
	#endif
	
	#include <X11/Xlib.h>
	
	#if defined(COMPILE_USE_AA_FONTS) && !defined(COMPILE_NO_X_DRAW_CALLS)
		// This stuff is useless with Qt 3.0... it uses the XRender extension to draw AA fonts
		// and this is really too much for us (there are no XftFonts!)

		#include <X11/Xft/Xft.h>
	
		#include <qglobal.h>
		#include <qregion.h>
		#include <qfont.h>
	
		#if QT_VERSION >= 231
			// Newer qt prototype has changed
			extern XftDraw * qt_lookup_ft_draw (Drawable draw, bool bWhatTheHellIsThis, QRegion *crgn);  // qpixmap_x11.cpp
			inline XftDraw * kvi_xft_lookup_drawable(Drawable draw,QPaintDevice * dev,QRegion * crgn){ return qt_lookup_ft_draw(draw,0,0); };
		#else
			#include <qpaintdevice.h>
			extern XftDraw * qt_lookup_ft_draw (Drawable draw, QPaintDevice *pdev, QRegion *crgn);  // qpixmap_x11.cpp
			inline XftDraw * kvi_xft_lookup_drawable(Drawable draw,QPaintDevice * dev,QRegion * crgn){ return qt_lookup_ft_draw(draw,dev,0); };
		#endif

		extern int       qt_use_xft (void);                                                     // qpainter_x11.cpp
		extern void    * qt_ft_font (const QFont *f);                                           // qfont_x11.cpp
		inline bool      kvi_xft_enabled(){ return qt_use_xft(); };
		inline XftFont * kvi_xft_font(const QFont *f){ return (XftFont *)qt_ft_font(f); };

	#endif // COMPILE_USE_AA_FONTS

#endif // !COMPILE_ON_WINDOWS

#endif //_KVI_XLIB_H_
