#ifndef _KVI_STRINGCONVERSION_H_
#define _KVI_STRINGCONVERSION_H_

//
//   File : kvi_stringconversion.h
//   Creation date : Thu Oct 20 2000 13:27:12 CEST by Szymon Stefanek
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 1999-2000 Szymon Stefanek (stefanek@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//

#include "kvi_settings.h"
#include "kvi_string.h"
#include "kvi_pixmap.h"
#include "kvi_msgtype.h"

#include <qrect.h>
#include <qcolor.h>
#include <qfont.h>
#include <qstringlist.h>

//#ifndef _KVI_STRINGCONVERSION_CPP_

namespace KviStringConversion 
{
	// bool <-> KviStr
	extern KVILIB_API void toString(const bool bValue,KviStr &buffer);
	extern KVILIB_API bool fromString(const char * szValue,bool &buffer);

	// int <-> KviStr
	extern KVILIB_API void toString(const int iValue,KviStr &buffer);
	extern KVILIB_API bool fromString(const char * szValue,int &buffer);

	// uint <-> KviStr
	extern KVILIB_API void toString(const unsigned int uValue,KviStr &buffer);
	extern KVILIB_API bool fromString(const char * szValue,unsigned int &buffer);

	// QRect <-> KviStr
	extern KVILIB_API void toString(const QRect &rValue,KviStr &buffer);
	extern KVILIB_API bool fromString(const char * szValue,QRect &buffer);

	// KviStr <-> KviStr (Null conversion)
	extern KVILIB_API void toString(const KviStr &szValue,KviStr &buffer);
	extern KVILIB_API bool fromString(const char * szValue,KviStr &buffer);

	// KviPixmap <-> KviStr
	extern KVILIB_API void toString(const KviPixmap &pValue,KviStr &buffer);
	extern KVILIB_API bool fromString(const char * szValue,KviPixmap &buffer);

	// QFont <-> KviStr
	extern KVILIB_API void toString(const QFont &fValue,KviStr &buffer);
	extern KVILIB_API bool fromString(const char * szValue,QFont &buffer);

	// KviMsgType <-> KviStr
	extern KVILIB_API void toString(const KviMsgType &mValue,KviStr &buffer);
	extern KVILIB_API bool fromString(const char * szValue,KviMsgType &buffer);

	// QColor <-> KviStr
	extern KVILIB_API void toString(const QColor &cValue,KviStr &buffer);
	extern KVILIB_API bool fromString(const char * szValue,QColor &buffer);

	// QStringList <-> KviStr
	extern KVILIB_API void toString(const QStringList &sValue,KviStr &buffer);
	extern KVILIB_API bool fromString(const char * szValue,QStringList &buffer);
};

//#endif

#endif //!_KVI_STRINGCONVERSION_H_
