//
//   File : kvi_stringconversion.cpp
//   Creation date : Thu Oct 20 2000 14:12:21 CEST by Szymon Stefanek
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 1999-2000 Szymon Stefanek (stefanek@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//

#define __LIBKVILIB__

#define _KVI_STRINGCONVERSION_CPP_
#include "kvi_stringconversion.h"


namespace KviStringConversion
{

	void toString(const bool bValue,KviStr &buffer)
	{
		buffer = bValue ? '1' : '0';
	}
	
	bool fromString(const char * szValue,bool &buffer)
	{
		buffer = !kvi_strEqualCS(szValue,"0");
		return true;
	}
	
	void toString(const int iValue,KviStr &buffer)
	{
		buffer.setNum(iValue);
	}
	
	bool fromString(const char * szValue,int &buffer)
	{
		KviStr str = szValue;
		if(!str.isNum())return false;
		buffer= str.toInt();
		return true;
	}
	
	void toString(const unsigned int uValue,KviStr &buffer)
	{
		buffer.setNum(uValue);
	}
	
	bool fromString(const char * szValue,unsigned int &buffer)
	{
		KviStr str = szValue;
		if(!str.isUnsignedNum())return false;
		buffer= str.toUInt();
		return true;
	}
	
	void toString(const QRect &rValue,KviStr &buffer)
	{
		buffer.sprintf("%d,%d,%d,%d",rValue.x(),rValue.y(),rValue.width(),rValue.height());
	}
	
	bool fromString(const char * szValue,QRect &buffer)
	{
		KviStr tmp;
		QRect ret;
		const char *aux = kvi_extractToken(tmp,szValue,',');
		bool bOk;
		ret.setLeft(tmp.toInt(&bOk));
		if(!bOk)return false;
		aux = kvi_extractToken(tmp,aux,',');
		ret.setTop(tmp.toInt(&bOk));
		if(!bOk)return false;
		aux = kvi_extractToken(tmp,aux,',');
		ret.setWidth(tmp.toInt(&bOk));
		if(!bOk)return false;
		aux = kvi_extractToken(tmp,aux,',');
		ret.setHeight(tmp.toInt(&bOk));
		if(!bOk)return false;
		buffer = ret;
		return true;
	}
	
	void toString(const KviStr &szValue,KviStr &buffer)
	{
		buffer = szValue;
	}
	
	bool fromString(const char * szValue,KviStr &buffer)
	{
		buffer = szValue;
		return true;
	}
	
	void toString(const KviPixmap &pValue,KviStr &buffer)
	{
		buffer = pValue.path();
	}
	
	bool fromString(const char * szValue,KviPixmap &buffer)
	{
		return buffer.load(szValue);
	}
	
	void toString(const KviMsgType &mValue,KviStr &buffer)
	{
		buffer.sprintf("%d,%u,%u,%d,%d",mValue.m_iPixId,mValue.m_cForeColor,mValue.m_cBackColor,mValue.m_bLogEnabled,mValue.m_iLevel);
	}
	
	bool fromString(const char * szValue,KviMsgType &buffer)
	{
		KviStr str = szValue;
		KviStr id;
		KviStr fore;
		KviStr back;
		KviStr log;
		KviStr level;
		str.getToken(id,',');
		str.getToken(fore,',');
		str.getToken(back,',');
		str.getToken(log,',');
		str.getToken(level,',');
		bool bOk;
		int iId = id.toInt(&bOk);
		if(!bOk)return false;
		unsigned char cFore = fore.toUChar(&bOk);
		if(!bOk)return false;
		unsigned char cBack = back.toUChar(&bOk);
		if(!bOk)return false;
		bool bLog = log.toInt();
		if(!bOk)return false;
		int iLevel = level.toInt(&bOk);
		if(!bOk)return false;
		buffer = KviMsgType(buffer.m_szType,iId,cFore,cBack,bLog,iLevel);
		return true;
	}
	
	void toString(const QColor &cValue,KviStr &buffer)
	{
		buffer = cValue.name();
	}
	
	bool fromString(const char * szValue,QColor &buffer)
	{
		buffer.setNamedColor(szValue); return true;
	}
	
	void toString(const QFont &fValue,KviStr &buffer)
	{
		KviStr family(fValue.family());
#if QT_VERSION >= 300
		buffer.sprintf("%s,%d,%d,%d",family.ptr(),fValue.pointSize(),fValue.styleHint(),fValue.weight());
#else
		buffer.sprintf("%s,%d,%d,%d,%d",
			family.ptr(),fValue.pointSize(),fValue.styleHint(),
			fValue.charSet(),fValue.weight());
#endif
	
		KviStr options;
		if(fValue.bold())options.append('b');
		if(fValue.italic())options.append('i');
		if(fValue.underline())options.append('u');
		if(fValue.strikeOut())options.append('s');
		if(fValue.fixedPitch())options.append('f');
	
		if(options.hasData())buffer.append(KviStr::Format,",%s",options.ptr());
	}
	
	bool fromString(const char * szValue,QFont &buffer)
	{
		KviStr str = szValue;
		KviStr family,pointSize,styleHint,charSet,weight,options;
		str.getToken(family,',');
		str.getToken(pointSize,',');
		str.getToken(styleHint,',');
#if QT_VERSION < 300
		str.getToken(charSet,',');
#endif
		str.getToken(weight,','); 
		if(family.hasData())buffer.setFamily(family.ptr());
		if(pointSize.isUnsignedNum())buffer.setPointSize(pointSize.toInt());
		if(styleHint.isUnsignedNum())buffer.setStyleHint((QFont::StyleHint)styleHint.toUInt());
#if QT_VERSION < 300
		if(charSet.isUnsignedNum())buffer.setCharSet((QFont::CharSet)charSet.toUInt());
#endif
		if(weight.isUnsignedNum())buffer.setWeight(weight.toUInt());
		if(str.hasData())
		{
			buffer.setBold(str.contains("b"));
			buffer.setItalic(str.contains("i"));
			buffer.setUnderline(str.contains("u"));
			buffer.setStrikeOut(str.contains("s"));
			buffer.setFixedPitch(str.contains("f"));
		}
		return true;
	}
	
	void toString(const QStringList &sValue,KviStr &buffer)
	{
		buffer = sValue.join(",");
	}
	
	bool fromString(const char * szValue,QStringList &buffer)
	{
		buffer = QStringList::split(",",szValue);
		return true;
	}

}
