#ifndef _KVI_FILETRADER_H_
#define _KVI_FILETRADER_H_
//
//   File : kvi_filetrader.h
//   Creation date : Wed Aug 27 2000 10:28:51 CEST by Szymon Stefanek
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 1999-2000 Szymon Stefanek (stefanek@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//

#include "kvi_settings.h"
#include "kvi_string.h"
#include "kvi_ircmask.h"
#include "kvi_list.h"

#include <qasciidict.h>

#include <time.h>
#include <qtimer.h>


class KVILIB_API KviFileOffer
{
public:
	KviFileOffer(const char * szAbsPath,const char * szUserMask,time_t expireTime,unsigned int uFileSize);
	~KviFileOffer();
private:
	KviStr          m_szAbsFilePath;
	time_t          m_expireTime;
	KviStr          m_szUserMask;
	unsigned int    m_uFileSize;
	unsigned int    m_uWildCount;
	unsigned int    m_uNonWildCount;
public:
	const char * absFilePath(){ return m_szAbsFilePath.ptr(); };

	const char * userMask(){ return m_szUserMask.ptr(); };

	time_t       expireTime(){ return m_expireTime; };
	bool         expires(){ return (m_expireTime != 0); };

	unsigned int fileSize(){ return m_uFileSize; };

	unsigned int wildcardCount(){ return m_uWildCount; };
	unsigned int nonWildcardCount(){ return m_uNonWildCount; };
	int          maskLength(){ return m_szUserMask.len(); };
};


typedef KviPtrList<KviFileOffer> KviFileOfferList;

class KVILIB_API KviFileTrader : public QObject
{
	Q_OBJECT
public:
	KviFileTrader();
	~KviFileTrader();
private:
	QTimer                         * m_pCleanupTimer;
	QAsciiDict<KviFileOfferList>   * m_pOfferListDict;
public:
	KviFileOffer * addOffer(const char * szName,const char * szAbsPath,const char * szMask,int timeoutInSecs);
	KviFileOffer * lookupOffer(const char * szName,KviIrcMask * mask,unsigned int uFileSize = 0);
	bool removeOffer(const char * szName,const char * szMask,unsigned int uFileSize);
	bool removeOffer(const char * szName,KviFileOffer * off);
	void load(const char * filename);
	void save(const char * filename);
	void clear();
	QAsciiDict<KviFileOfferList> * offerListDict(){ return m_pOfferListDict; };
private:
	void doInsert(KviFileOfferList * l, KviFileOffer * o);
private slots:
	void cleanup();
signals:
	void offerListChanged();
};

#endif //_KVI_FILETRADER_H_
