#ifndef _KVI_DATABUFFER_H_
#define _KVI_DATABUFFER_H_
//
//   File : kvi_databuffer.h
//   Creation date : Thu Aug 23 17:04:25 2001 GMT by Szymon Stefanek
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 2001 Szymon Stefanek (stefanek@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//

#include "kvi_settings.h"

class KVILIB_API KviDataBuffer
{
public:
	// uSize MUST be greater than 0
	// if data is non-zero, it MUST point to a buffer at least uSize bytes long
	// and the data is COPIED from that buffer!
	KviDataBuffer(int uSize,const unsigned char * data = 0);
	KviDataBuffer();
	~KviDataBuffer();
private:
	int m_uSize;
	unsigned char * m_pData;
public:
	int size(){ return m_uSize; };
	unsigned char * data(){ return m_pData; };
	// uSize MUST be smaller or equal to size()
	void remove(int uSize);
	void clear(){ if(m_uSize > 0)remove(m_uSize); };
	// uSize MUST be greater than 0
	void resize(int uSize);
	void addSize(int uSize){ resize(m_uSize + uSize); };
	void append(const unsigned char * data,int uSize);
};

#endif //_KVI_DATABUFFER_H_
