//
//   File : kvi_databuffer.cpp
//   Creation date : Thu Aug 23 17:04:24 2001 GMT by Szymon Stefanek
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 2001 Szymon Stefanek (stefanek@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//

#define __LIBKVILIB__

#define _KVI_DEBUG_CHECK_RANGE_

#include "kvi_debug.h"

#include "kvi_databuffer.h"
#include "kvi_malloc.h"
#include "kvi_memmove.h"

// FIXME: this could resize in chunks!...this would be damn faster :)

KviDataBuffer::KviDataBuffer(int uSize,const unsigned char * data)
{
	__range_valid(uSize > 0);
	m_uSize = uSize;
	m_pData = (unsigned char *)kvi_malloc(sizeof(unsigned char) * uSize);
	if(data)kvi_memmove(m_pData,data,uSize);
}

KviDataBuffer::KviDataBuffer()
{
	m_uSize = 0;
	m_pData = 0;
}

KviDataBuffer::~KviDataBuffer()
{
	if(m_pData)
	{
		__range_valid(m_uSize);
		kvi_free(m_pData);
	}
}

void KviDataBuffer::remove(int uSize)
{
	__range_valid((uSize <= m_uSize) && (uSize > 0));

	m_uSize -= uSize;

	if(m_uSize > 0)
	{
		kvi_memmove(m_pData,m_pData + uSize,m_uSize);
		m_pData = (unsigned char *)kvi_realloc(m_pData,m_uSize * sizeof(unsigned char));
	} else {
		__range_valid(m_uSize == 0);
		kvi_free(m_pData);
		m_pData = 0;
	}
}

void KviDataBuffer::resize(int uSize)
{
	__range_valid(uSize >= 0);
	if(uSize > 0)
	{
		m_pData = (unsigned char *)kvi_realloc(m_pData,uSize * sizeof(unsigned char));
	} else {
		kvi_free(m_pData);
		m_pData = 0;
	}
	m_uSize = uSize;
}

void KviDataBuffer::append(const unsigned char * data,int uSize)
{
	m_pData = (unsigned char *)kvi_realloc(m_pData,m_uSize + uSize);
	kvi_memmove(m_pData + m_uSize,data,uSize);
	m_uSize += uSize;
}
