#ifndef _KVI_CONFIG_H_INCLUDED_
#define _KVI_CONFIG_H_INCLUDED_

//
//   File : kvi_config.h (/usr/build/NEW_kvirc/kvirc/kvilib/kvi_config.h)
//   Last major modification : Thu Jan 14 1999 18:01:22 by Szymon Stefanek
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 1999-2000 Szymon Stefanek (stefanek@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//

#include "kvi_string.h"
#include "kvi_settings.h"

#include <qasciidict.h>
#include <qcolor.h>
#include <qfont.h>
#include <qrect.h>
#include <qstringlist.h>
#include <qvaluelist.h>

#define KVI_CONFIG_DEFAULT_GROUP "KVIrc"

class KviPixmap;
class KviMsgType;

typedef QAsciiDict<KviStr> KviStrDict;
typedef QAsciiDictIterator<KviStr> KviStrDictIterator;
typedef QAsciiDictIterator<KviStrDict> KviConfigIterator;

class KVILIB_API KviConfig
{
public:
	KviConfig(const char *filename,bool bReadOnly = false);
	~KviConfig();
private:
	QAsciiDict<KviStrDict> *m_pDict;
	KviStr m_szFileName;
	bool m_bDirty;
	KviStr m_szStrBuffer;
	KviStr m_szGroup;
	bool m_bPreserveEmptyGroups;
	bool m_bReadOnly;
private:
	bool load();
	bool save();
	KviStrDict * getCurrentGroup();
public:
	//
	// Useful when saving...
	// Normally this class does not save empty groups
	// and setGroup() is never a config modification.
	// If the group is not existing it will be effectively
	// created only at the first attempt to read from it or write to it.
	// With this flag set to true the KviConfig class will
	// write down also the empty groups , and calls to setGroup()
	// will create the groups if not existing yet (and set the config data
	// as modified).
	//
	void preserveEmptyGroups(bool bPreserve){ m_bPreserveEmptyGroups = bPreserve; };
	const char * fileName(){ return m_szFileName.ptr(); };
	bool readOnly(){ return m_bReadOnly; };
	void setReadOnly(bool bReadOnly){ m_bReadOnly = bReadOnly; };
	bool dirty(){ return m_bDirty; };
	//
	// This sets the save path for the config file
	// In this way you can load a system-wide read-only config file
	// as default configuration, alter its settings and save it to the
	// user local configuration directory
	void setSavePath(const char * savePath){ m_szFileName = savePath; };
	QAsciiDict<KviStrDict> *dict(){ return m_pDict; };
	void clearDirtyFlag(){ m_bDirty = false; };
	void clear();
	void clearGroup(const char *szGroup);
	void clearKey(const char *szKey);
	unsigned int groupsCount(){ return m_pDict->count(); };
	bool sync(){ return save(); };
	bool hasKey(const char *szKey);
	bool hasGroup(const char *szGroup);
	void setGroup(const char *szGroup);
	//void getContentsString(KviStr &buffer);
	const char *group(){ return m_szGroup.ptr(); };
	void writeEntry(const char *szKey,const char *szValue);
	const char * readEntry(const char *szKey,const char *szDefault = 0);
	//void writeEntry(const char *szKey,KviStr &szValue);
	//const char * readEntry(const char *szKey,KviStr &szDefault);
	void writeEntry(const char *szKey,const KviPixmap &pixmap);
	KviPixmap readPixmapEntry(const char * szKey,const KviPixmap &pixDef);
	void writeEntry(const char *szKey,const KviMsgType &msg);
	KviMsgType readMsgTypeEntry(const char * szKey,const KviMsgType &msgDef);
	void writeEntry(const char *szKey,const QColor &clr);
	QColor readColorEntry(const char *szKey,const QColor &clr);
	void writeEntry(const char *szKey,QFont &fnt);
	QFont readFontEntry(const char *szKey,QFont &fnt);
	void writeEntry(const char *szKey,bool bTrue);
	bool readBoolEntry(const char *szKey,bool bTrue);
	QRect readRectEntry(const char *szKey,const QRect &rct);
	void writeEntry(const char *szKey,const QRect &rct);
	QStringList readStringListEntry(const char * szKey,const QStringList &list);
	void writeEntry(const char *szKey,const QStringList &list);
	QValueList<int> readIntListEntry(const char * szKey,const QValueList<int> &list);
	void writeEntry(const char *szKey,const QValueList<int> &list);
	//void writeEntry(const char *szKey,unsigned long lValue);
	//unsigned long readULongEntry(const char *szKey,unsigned long lDefault);
	//void writeEntry(const char *szKey,long lValue);
	//long readLongEntry(const char *szKey,long lDefault);
	void writeEntry(const char *szKey,int iValue);
	int readIntEntry(const char *szKey,int iDefault);
	void writeEntry(const char *szKey,unsigned short int usValue);
	unsigned short int readUShortEntry(const char *szKey,unsigned short int usDefault);
	void writeEntry(const char *szKey,unsigned int iValue);
	unsigned int readUIntEntry(const char *szKey,unsigned int iDefault);
	void writeEntry(const char *szKey,char iValue);
	char readCharEntry(const char *szKey,char iDefault);
	void writeEntry(const char *szKey,unsigned char iValue);
	unsigned char readUCharEntry(const char *szKey,unsigned char iDefault);

	static void getFontProperties(KviStr & buffer,QFont *fnt);
	static void setFontProperties(KviStr & str,QFont *fnt);

#ifdef COMPILE_ON_WINDOWS
	// On windows we need to override new and delete operators
	// to ensure that always the right new/delete pair is called for an object instance
	// This bug is present in all the classes exported by a module that
	// can be instantiated/destroyed from external modules.
	// (this is a well known bug described in Q122675 of MSDN)
	void       * operator new(size_t tSize);
	void         operator delete(void * p);
#endif
};

#endif //!_KVI_CONFIG_H_INCLUDED_
