//
//   File : kvi_cmdformatter.cpp
//   Creation date : Tue Jun 12 2001 03:08:12 CEST by Szymon Stefanek
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 2001 Szymon Stefanek (stefanek@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//

#define __LIBKVILIB__

#define _KVI_CMDFORMATTER_CPP_
#include "kvi_cmdformatter.h"

namespace KviCommandFormatter
{
	bool hasLeadingChars(KviStr ** array,char c)
	{
		if(!(*array))return false; // can't have more leading chars
		bool bGotIt = false;
		while(*array)
		{
			if(*((*array)->ptr()) == c)
			{
				// found at least one such leading char
				bGotIt = true;
			} else {
				// we pretend this line to be empty
				KviStr tmp = *(*array);
				tmp.stripWhiteSpace();
				if(tmp.hasData())return false;
				*(*array) = ""; // set it to empty also in the main buffer
			}
			array++;
		}
		return bGotIt;
	}

	void trimLeading(KviStr ** array)
	{
		while(*array)
		{
			if((*array)->hasData())(*array)->cutLeft(1);
			array++;
		}
	}

	void addLeading(KviStr ** array,char c)
	{
		while(*array)
		{
			if((*array)->hasData())(*array)->prepend(c);
			array++;
		}
	}

	void unindent(KviStr &buffer)
	{
		// we can format correctly up to 65536 lines (that's really enough)
		int realLen;
		KviStr ** array = buffer.splitToArray('\n',65536,&realLen);
		if(array)
		{
			while(hasLeadingChars(array,'\t') || hasLeadingChars(array,' '))trimLeading(array);
			buffer.joinFromArray(array,"\n",true);
			KviStr::freeArray(array);
		}
	}

	void bufferFromBlock(KviStr &buffer)
	{
		buffer.stripWhiteSpace();

		if((*(buffer.ptr()) == '{') && buffer.lastCharIs('}'))
		{
			// leading and trailing { must be stripped
			buffer.cutLeft(1);
			buffer.cutRight(1);
		}

		unindent(buffer);

		buffer.stripWhiteSpace();
	}

	void indent(KviStr &buffer)
	{
		// we can format correctly up to 65536 lines (that's really enough)
		int realLen;
		KviStr ** array = buffer.splitToArray('\n',65536,&realLen);
		if(array)
		{
			addLeading(array,'\t');
			buffer.joinFromArray(array,"\n",true);
			KviStr::freeArray(array);
		}
	}

	void blockFromBuffer(KviStr &buffer)
	{
		indent(buffer);
		buffer.prepend("{\n");
		buffer.stripRightWhiteSpace();
		buffer.ensureLastCharIs('\n');
		buffer.append("}\n");
	}
};

// FIXME: #warning "move popups and events to this formatting stuff!"
