#ifndef _KVI_SETTINGS_H_
#define _KVI_SETTINGS_H_

//=============================================================================
//
//   File : kvi_settings.h
//   Creation date : Fri Mar 19 1999 05:21:13 CEST by Szymon Stefanek
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 1999-2001 Szymon Stefanek (stefanek@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
//=============================================================================

//=============================================================================
// This file contains compile time settings, either set by configure or
// non-customizable defaults
//
// Better do not touch this
//=============================================================================

#include <qglobal.h>

#ifdef _OS_WIN32_

	#define FEEL_LIKE_I_AM_COMPILING_UNDER_WINDOZE
	#define COMPILE_ON_WINDOWS

	// Windows ha no config.h

	#include "kvi_wincfg.h"

	#ifdef __LIBKVILIB__
		#define KVILIB_API __declspec(dllexport)
	#else
		#define KVILIB_API __declspec(dllimport)
	#endif

	#ifdef __KVIRC__
		#define KVIRC_API __declspec(dllexport)
	#else
		#define KVIRC_API __declspec(dllimport)
	#endif

#else

	#ifdef HAVE_CONFIG_H
		#include "config.h"
	#else
		#error "You're missing the config.h file: you must run configure before running make!"
	#endif

	#define KVILIB_API
	#define KVIRC_API

	#ifndef VERSION
		#define VERSION "?.?.?"
	#endif
	
	#ifndef BUILD_DATE
		#define BUILD_DATE "?"
	#endif
	
	#ifndef BUILD_NUMBER
		#define BUILD_NUMBER "?"
	#endif
	
	#ifndef BUILD_FLAGS
		#define BUILD_FLAGS "?"
	#endif

#endif


// We want _GNU_SOURCE features
#ifndef _GNU_SOURCE
	#define _GNU_SOURCE
#endif

#define KVI_RELEASE_NAME "\"Eve's Avatar\""
#define KVI_VERSION "KVirc " VERSION " " KVI_RELEASE_NAME " by Szymon Stefanek"

#define KVI_SCRIPT_LANGUAGE_TAG "20001204"
#define KVI_NUMERIC_SCRIPT_LANGUAGE_TAG 20001204

// Some compatibility stuff
// FIXME: This should be moved from here!
#if QT_VERSION >= 300
	#define HANDLE Qt::HANDLE
#endif

#if (QT_VERSION >= 300) || defined(COMPILE_ON_WINDOWS)
	// Don't use X draw calls at all... qt uses XRender to AA fonts rendering
	// That's actually too much for us :D
	#ifndef COMPILE_NO_X_DRAW_CALLS
		#define COMPILE_NO_X_DRAW_CALLS
	#endif
#endif

#ifdef __GNUC__
	#if __GNUC__ >= 3
		#define POINTER_TO_MEMBER_NO_PARENTHESIS
	#endif
#else
	#ifdef COMPILE_ON_WINDOWS
		#define POINTER_TO_MEMBER_NO_PARENTHESIS
	#endif
#endif

#ifdef POINTER_TO_MEMBER_NO_PARENTHESIS
	#define KVI_PTR2MEMBER(__x) &__x
#else
	#define KVI_PTR2MEMBER(__x) &(__x)
#endif

#endif //_KVI_SETTINGS_H_
