#ifndef _KVI_DEFAULTS_H_
#define _KVI_DEFAULTS_H_

//=============================================================================
//
//   File : kvi_defaults.h
//   Creation date : Wed Jun 21 2000 13:23:13 CEST by Szymon Stefanek
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 1999-2001 Szymon Stefanek (stefanek@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
//=============================================================================

//=============================================================================
// This file contains (more or less) freely customizable compile time defaults
//
// You can safely play with the ones you understand the meaning of
//=============================================================================

#include "kvi_settings.h"

#ifdef COMPILE_ON_WINDOWS
	#define KVI_HOME_CONFIG_FILE_NAME "kvirc-" VERSION ".ini"
#else
	#define KVI_HOME_CONFIG_FILE_NAME ".kvirc-" VERSION ".rc"
#endif

#define KVI_LOCAL_KVIRC_SUBDIRECTORY_NAME "kvirc-" VERSION

#define KVI_SMALLICONS_IMAGELIB_NAME "kvi_small_icons.png"
#define KVI_BIGICONS_IMAGELIB_NAME  "kvi_big_icons.png"
#define KVI_USERCHANSTATE_IMAGE_NAME "kvi_userchanstate.png"

#define KVI_CTCP_VERSION_REPLY "KVirc " VERSION " " KVI_RELEASE_NAME " : build " \
		BUILD_NUMBER " " BUILD_DATE " : " BUILD_FLAGS

#define KVI_CTCP_CLIENTINFO_VERSION "KVirc " VERSION " " KVI_RELEASE_NAME

#define KVI_CTCP_SOURCE_REPLY "KVirc " VERSION " " KVI_RELEASE_NAME " http://www.kvirc.net"

#define KVI_DEFAULT_FRAME_CAPTION "KVIrc " VERSION " " KVI_RELEASE_NAME

#define KVI_DEFAULT_NICKNAME1 "newbie"
#define KVI_DEFAULT_NICKNAME2 "[newbie]"
#define KVI_DEFAULT_NICKNAME3 "_newbie_"
#define KVI_DEFAULT_NICKNAME4 "newbie4"
#define KVI_DEFAULT_USERNAME "newbie"
#define KVI_DEFAULT_REALNAME "Using KVirc " VERSION " " KVI_RELEASE_NAME

#define KVI_DEFAULT_IDENTD_USER "newbie"

#define KVI_DEFAULT_PART_MESSAGE "\"Eve's Avatar - Avatar's Eve\""
#define KVI_DEFAULT_QUIT_MESSAGE "KVIrc " VERSION " " KVI_RELEASE_NAME
#define KVI_DEFAULT_CTCP_USERINFO_REPLY "I'm too lazy to fill this field"
#define KVI_DEFAULT_CTCP_PAGE_REPLY "Your message has been received and logged"
#define KVI_DEFAULT_AWAY_MESSAGE "Idling in some other place..."
#define KVI_DEFAULT_AWAY_NICK "IMAWAY"

#ifdef COMPILE_SPLASH_SCREEN
	#define KVI_SPLASH_SCREEN_TEXT "KVIrc <b>" VERSION " " KVI_RELEASE_NAME "</b> brought to you by the <b>KVIrc developement team</b>"
	#define KVI_SPLASH_SCREEN_MINIMUM_TIMEOUT_IN_MSECS 4000
#endif

#define KVI_ABOUT_DIALOG_TEXT "KVIrc <b>" VERSION " " KVI_RELEASE_NAME "</b> brought to you by the <b>KVIrc developement team</b>"

#define KVI_MAX_PENDING_AVATARS 20
#define KVI_MAX_RECENT_SERVERS 10
#define KVI_MAX_RECENT_CHANNELS 30
#define KVI_MAX_RECENT_NICKNAMES 10

//#ifdef _KVI_USERLISTVIEW_CPP_
////	#define KVI_USERLIST_SCROLLBAR_WIDTH 16
//
//#endif

#if defined(_KVI_IRCVIEW_CPP_) || defined(_KVI_OPTIONS_CPP_)
	// Maximum size of the internal buffer for each window
	// This is the default value
	#define KVI_IRCVIEW_MAX_LINES 1024
	// Borders...just do not set it to 0
	#define KVI_IRCVIEW_HORIZONTAL_BORDER 4
	#define KVI_IRCVIEW_VERTICAL_BORDER 4
	// Scrollbar width
//	#define KVI_IRCVIEW_SCROLLBAR_WIDTH 16
	// If you have changed the two abowe , please recalculate this one
//	#define KVI_IRCVIEW_SCROLLBAR_AND_HORIZONTAL_BORDER_WIDTH 20
	// A little bit more than the scroll-bar...
	// Qt+X have strange interactions that I can not understand when I try to move the splitter
	// to the maximum on the left , Maybe the cache pixmap size becomes negative ? (I don't think so)
	// Anyway , when the scroll bar position becomes negative (or the IrcView has smaller width than
	// the scroll bar) X aborts with a funny
	// X Error: BadDrawable (invalid Pixmap or Window parameter) 9
	//   Major opcode:  55
	// Program received signal SIGABRT, Aborted.
	// Do not change unless you're sure that it will not happen :)
	#define KVI_IRCVIEW_MINIMUM_WIDTH 22
	//16+4+(2*4) * Do not change
	#define KVI_IRCVIEW_PIXMAP_AND_SEPARATOR 20
	#define KVI_IRCVIEW_PIXMAP_SEPARATOR_AND_DOUBLEBORDER_WIDTH 28
	#define KVI_IRCVIEW_SELECT_REPAINT_INTERVAL 100
	#define KVI_IRCVIEW_SIZEHINT_WIDTH 150
	#define KVI_IRCVIEW_SIZEHINT_HEIGHT 150
#endif

#ifdef _KVI_INPUT_CPP_
	// Default maximum buffer size.
	#define KVI_INPUT_MAX_BUFFER_SIZE 400
	// Border , better do not touch this
	#define KVI_INPUT_BORDER 4
	// Cursor blink time...just don't set it to a value less than 100 if
	// you don't want to be lagged by your cursors :)
	#define KVI_INPUT_BLINK_TIME 800
	// Drag scroll speed...(smaller values = faster)
	#define KVI_INPUT_DRAG_TIMEOUT 80
	// Maximum entries in the history buffer
	#define KVI_INPUT_HISTORY_ENTRIES 40
#endif

#define KVI_RECENT_TOPIC_ENTRIES 20

#endif //_KVI_DEFAULTS_H_
