#!/bin/sh

# Arguments:
# $1 = directory to search in
# $2 = filename to produce
# $3- = search string

if test -z "$1"; then
	echo "Search error : missing files to search"
	exit -1
fi

if test -z "$2"; then
	echo "Search error : missing target filename"
	exit -1
fi

if test -z "$3"; then
	echo "Search error : missing search string"
	exit -1
fi

# Build the search criteria string...not so funky, but works

SEARCH_CRITERIA="$3"
SEARCH_WORDS="$3"

if test -n "$4"; then
	SEARCH_WORDS="$SEARCH_WORDS $4"
	SEARCH_CRITERIA="$SEARCH_CRITERIA AND $4"
fi
if test -n "$5"; then
	SEARCH_WORDS="$SEARCH_WORDS $5"
	SEARCH_CRITERIA="$SEARCH_CRITERIA AND $5"
fi
if test -n "$6"; then
	SEARCH_WORDS="$SEARCH_WORDS $6"
	SEARCH_CRITERIA="$SEARCH_CRITERIA AND $6"
fi
if test -n "$7"; then
	SEARCH_WORDS="$SEARCH_WORDS $7"
	SEARCH_CRITERIA="$SEARCH_CRITERIA AND $7"
fi
if test -n "$8"; then
	SEARCH_WORDS="$SEARCH_WORDS $8"
	SEARCH_CRITERIA="$SEARCH_CRITERIA AND $8"
fi
if test -n "$9"; then
	SEARCH_WORDS="$SEARCH_WORDS $9"
	SEARCH_CRITERIA="$SEARCH_CRITERIA AND $9"
fi


DOCUMENT="<html>
<head><title>Search results</title></head>
<body bgcolor=\"#FFFFFF\" text=\"#000000\">
KVirc documentation<br>
<hr>
<table bgcolor=\"#A0A0A0\" width=\"100%\">
<tr>
	<td><h1>Search results for \"$SEARCH_CRITERIA\"</h1></td>
</tr>
"

FILES_TO_SEARCH=`find $1 -name "*.html"`

if test -z "$FILES_TO_SEARCH"; then
	DOCUMENT="$DOCUMENT <tr bgcolor=\"#F0F0F0\"></td><b>Internal error: no files to search</b></td></tr></table><hr><a href=\"index.html\">Main index</a></html>"
	echo "$DOCUMENT" > $2
	exit 0
fi

# Now grep the files
SEARCH_RESULT=""
for a_word in $SEARCH_WORDS; do	
	if test -z "$SEARCH_RESULT"; then
		SEARCH_RESULT=`grep -i -l $a_word $FILES_TO_SEARCH`
	else
		SEARCH_RESULT=`grep -i -l $a_word $SEARCH_RESULT`
	fi
	if test -z "$SEARCH_RESULT"; then

		DOCUMENT="$DOCUMENT <tr bgcolor=\"#F0F0F0\"><td><b>No matches found</b></td></tr></table><hr><a href=\"index.html\">Main index</a></html>"
		echo "$DOCUMENT" > $2
		exit 0
	fi
done

DOCS_COUNT="0"

for a_file in $SEARCH_RESULT; do

	RESULT_DESCRIPTION="<b>["
	for a_word in $SEARCH_WORDS; do
		WORD_MATCHES=`grep -i -h -c $a_word "$a_file"`
		RESULT_DESCRIPTION="$RESULT_DESCRIPTION $a_word:$WORD_MATCHES  "
	done
	RESULT_DESCRIPTION="$RESULT_DESCRIPTION ]</b>"
	
	DOC_TITLE=`grep -i -h "<title>" "$a_file" | sed -e 's/title/b/g'`
	if test -z "$DOC_TITLE"; then
		DOC_TITLE="<b>Untitled</b>"
	fi	
	DOC_PREMATCH=`grep -i -h -A 30 "searchbody" "$a_file" | tac | tail -n 30 | tac`
	DOC_MATCH=`echo "$DOC_PREMATCH" | sed -e 's/<[a-zA-Z0-9 _	\=\"\#\%\&\/\.]*>/ /g'`
	DOC_MATCH=`echo "$DOC_MATCH" | sed -e 's/</\&lt/g'`
	DOC_MATCH=`echo "$DOC_MATCH" | sed -e 's/>/\&gt/g'`
	DOC_MATCH=`echo "$DOC_MATCH" | grep -h "[a-zA-Z0-9{}]"`
	DOC_MATCH=`echo "$DOC_MATCH" | sed -e 's/^[	 ]*//'`
	DOC_MATCH=`echo "$DOC_MATCH" | tac | tail -n 10 | tac`
	if test -z "$DOC_MATCH"; then
		DOC_MATCH="No document body found"
	fi

	DOCS_COUNT=`expr $DOCS_COUNT + 1`

	DOCUMENT="$DOCUMENT <tr bgcolor=\"#F0F0F0\"><td><a href=\"$a_file\"><b>$DOCS_COUNT</b>. $DOC_TITLE</a><br><br><I>...$DOC_MATCH...</I><br><br><b>$RESULT_DESCRIPTION</b></td></tr>"

done

DOCUMENT="$DOCUMENT</table><hr><br>Found $DOCS_COUNT matches</html>"

echo "$DOCUMENT" > $2
