#!/usr/bin/perl

#################################################################################################
# GLOBAL CONFIGS
#################################################################################################

$g_currenttime=gmtime;
$g_currentuser = getlogin || getpwuid($<) || "Unknown";
$g_examplecolor="#FF0000";
$g_examplebgcolor="#F5F5F5";
$g_syntaxcolor="#802000";
$g_bodybgcolor="#FFFFFF";
$g_bodytextcolor="#000000";
$g_bodylinkcolor="#000000";
$g_titletablebgcolor="#999999";
$g_subtitletablebgcolor="#C5C5C5";
$g_internaltablecolor="#D5D5D5";
$g_classfnctablecolor="#D5D5D5";
$g_classfncbodytablecolor="#E0E0E0";
$g_bodytablebgcolor="#EAEAEA";
$g_commentcolor="#207500";
$g_fileextension=".html";
#$g_headerborderlightcolor="#A0A0A0";
#$g_headerborderdarkcolor="#000000";
$g_headerbgcolor="#FFFFFF";

$g_prefixes{'command'}="cmd";
$g_prefixes{'function'}="fnc";
$g_prefixes{'event'}="event";
$g_prefixes{'language'}="doc";
$g_prefixes{'class'}="class";
$g_prefixes{'module'}="module";
$g_prefixes{'widget'}="widget";

$g_directory=$ARGV[0];
if($g_directory eq "")
{
	print "WARNING: No directory specified : using /tmp";
	$g_directory="/tmp";
}

$g_filehandle="";
$g_shortsIdx{"keyterms"}=0;

#################################################################################################
# SUBS
#################################################################################################

sub print_header
{
	print $g_filehandle "<html>\n";
	print $g_filehandle "<head>\n";
	print $g_filehandle "<title>$_[0]</title>\n";
	print $g_filehandle "</head>\n";
	print $g_filehandle "<body bgcolor=\"$g_bodybgcolor\" text=\"$g_bodytextcolor\">\n";

	#print $g_filehandle "<table width=\"100%\" cellpadding=\"1\" cellspacing=\"0\" border=\"0\"><tr><td bgcolor=\"$g_headerborderlightcolor\">\n";
	#print $g_filehandle "<table width=\"100%\" cellpadding=\"1\" cellspacing=\"0\" border=\"0\"><tr><td bgcolor=\"$g_headerborderdarkcolor\">\n";

	print $g_filehandle "<table width=\"100%\" cellpadding=\"1\" cellspacing=\"0\" border=\"0\">\n";
	print $g_filehandle " <tr>\n";
	print $g_filehandle "  <td align=\"left\" bgcolor=\"$g_headerbgcolor\">\n";
	print $g_filehandle "    <a href=\"index.html\"><img src=\"helplogoleft.png\" border=\"0\"></a>\n";
	print $g_filehandle "  </td>\n";
	print $g_filehandle "  <td align=\"right\" bgcolor=\"$g_headerbgcolor\">\n";
	print $g_filehandle "    <img src=\"helplogoright.png\">\n";
	print $g_filehandle "  </td>\n";
	print $g_filehandle " </tr>\n";
	print $g_filehandle "</table>\n";

	#print $g_filehandle "</td></tr></table>\n";
	#print $g_filehandle "</td></tr></table>\n";
}

sub print_footer
{
	print $g_filehandle "<hr>KVirc 3.0.0 documentation<br>Generated by $g_currentuser at $g_currenttime\n";
	print $g_filehandle "</body>\n";
	print $g_filehandle "</html>\n";
}

sub print_tablestart
{
	print $g_filehandle "<table width=\"100%\">\n";
}

sub print_tableend
{
	print $g_filehandle "</table>\n";
}

sub print_title
{
	print $g_filehandle "  <tr bgcolor=\"$g_titletablebgcolor\">\n";
	print $g_filehandle "    <td>\n";

	print $g_filehandle "      <h1>$_[0]</h1>\n";
	if($_[1] ne "")
	{
		print $g_filehandle "$_[1]\n";
	} else {
		print $g_filehandle "\n";
	}

	print $g_filehandle "    </td>\n";
	print $g_filehandle "  </tr>\n";
}

sub print_subtitle
{
	print $g_filehandle "  <tr bgcolor=\"$g_subtitletablebgcolor\">\n";
	print $g_filehandle "    <td><b>$_[0]</b></td>\n";
	print $g_filehandle "  </tr>\n";
}

sub print_body
{
	print $g_filehandle "  <tr bgcolor=\"$g_bodytablebgcolor\">\n";
	print $g_filehandle "    <td>$_[0]</td>\n";
	print $g_filehandle "  </tr>\n";
}

sub print_twocolumnbody
{
	print $g_filehandle "<tr bgcolor=\"$g_bodytablebgcolor\">\n";
	print $g_filehandle "  <td>$_[0]</td>\n";
	print $g_filehandle "  <td>$_[1]</td>\n";
	print $g_filehandle "</tr>\n";
}

sub print_entry
{
	if($_[1] ne "")
	{
		if($_[0] ne "")
		{
			print_subtitle($_[0]);
		}
		print_body($_[1]);
	}
}

sub make_single_token
{
	$_[0] =~ s/^[	 ]*//g;
	$_[0] =~ s/[	 ]*$//g;
	$_[0] =~ s/\n//g;
}

sub make_single_line
{
	$_[0] =~ s/^[ 	]*//g;
	$_[0] =~ s/[	 \n]*$//gs;
}


sub extract_keyterms
{
	my($docfilename);
	my(%parts);
	my($part); # Part title
	my($partbody);
	my($tabblock);
	my($tmp);
	my($type);


	if(!open(CPPFILE,"$_[0]"))
	{
		return;
	}
	# Process the entire file

	while(<CPPFILE>)
	{
		if(/^[ 	]*\@doc:[ 	a-z_]*/)
		{
			# Process a single document block

			$docfilename="$_";
			$docfilename=~ s/[ 	]*//g;
			$docfilename=~ s/\@doc://g;
			$docfilename=~ s/\n//g;

			undef %parts;

			INNERLOOP: while(<CPPFILE>)
			{

				if(/^[	 ]*\*\/[ 	]*/)
				{
					# End of comment
					if(($part ne "") && ($partbody ne "") && ($partbody ne "\n"))
					{
						# We have an entire part to store
						$parts{$part}="$partbody";
					}
					last INNERLOOP;
				} else {
					# Inside a part
					if(/^[	 ]*\@[a-z]*:[	 ]*/)
					{
						# A part title
						if(($part ne "") && ($partbody ne "") && ($partbody ne "\n"))
						{
							# We have an entire part to store
							$parts{$part}="$partbody";
						}
						# Start of the part
						# Extract the title
						$part="$_";
						$part=~ s/[	 ]*//g;
						$part=~ s/\@//g;
						$part=~ s/://g;
						$part=~ s/\n//g;
						# Clear the body (begin)
						$partbody="";
					} else {
						# Somewhere in a part body
						if(($_ ne "") && ($_ ne "\n"))
						{
							if($partbody eq "")
							{
								# If it is the first line of the part body
								# Extract the amount of tabs that the part has
								# We will use it to remove the C++ indentation
								$tabblock = "$_";
								$tabblock =~ s/^([	]*).*/\1/g;
								$tabblock =~ s/\n//g;
							}

							if($tabblock ne "")
							{
								# If we have the initial tabblock , remove it from the line (remove indentation)
								$_ =~ s/^$tabblock//g;
							}

							process_body_line($_);

							$partbody="$partbody$_";
						}
					}
				}
			}

			# Ok...we have a document in $parts
			make_single_line($parts{'short'});
			make_single_token($parts{'title'});
			make_single_token($parts{'type'});

			$parts{'type'}=~ s/\@//g;
			$parts{'type'}=~ s/://g;

			if($parts{'type'} eq "")
			{
				$parts{'type'}="generic";
			}

			$type = $parts{'type'};

			$tmp = $g_prefixes{$type};
			if($tmp eq "")
			{
				$tmp="doc";
			}

			$docfilename="$tmp\_$docfilename";

			$zzz="keyterms";

			if($parts{'keyterms'} ne "")
			{
				$keyterms = $parts{'keyterms'};
				$keyterms =~ s/\n//gs;

				for $term (split(/,/,$keyterms))
				{
					make_single_token($term);
					if($term ne "")
					{
						$termx=$term;
						$termx=~ s/([\+\(\)\?\.\:\*\|\=\;\^\!\~])/\\$1/g;

						$g_keyterms{$term} = "$docfilename$g_fileextension";
						$g_keytermsclean{$term} = "$termx";

						$tmp="keyterms_$g_shortsIdx{$zzz}";
						$g_shorts{$tmp}="$term<!>$parts{'short'}<!>$docfilename$g_fileextension";
						#print "GOT $g_shorts{$tmp} ($tmp)";
						$g_shortsIdx{$zzz}++;
					}
				}
			}

			$tmp="keyterms_$g_shortsIdx{$zzz}";
			$g_shorts{$tmp}="$parts{'title'}<!>$parts{'short'}<!>$docfilename$g_fileextension";
			#print "GOT $g_shorts{$tmp} ($tmp)";
			$g_shortsIdx{$zzz}++;
		}
	}

	close(CPPFILE);
}

sub substitute_keyterms_old_unused_to_be_removed_sooner_or_later_oh_what_a_long_function_name
{
	my(@lines);
	my(@tmp);
	my($left);
	my($right);
	my($line);
	my($term);

	# Kinda complex keyword substitution routine


	# For each keyterm we have
	for $term (@g_keytermsSorted)
	{
		# If the doc we're scanning isn't the keyword target
		if($_[1] ne $g_keyterms{$term})
		{
			$termclean=$g_keytermsclean{$term};

			# If the doc matches the keyterm at least once
			if($_[0] =~ /$termclean/)
			{
				# First we split the doc in lines
				@lines = split(/\n/,$_[0]);
				$_[0]="";
	
				$ref=$g_keyterms{$term};

				$skipIt = 0;

				for(@lines)
				{
					if($_ ne "")
					{
						@tmp = split(/</,$_);
						$line = "";
						$first=1;
						for(@tmp)
						{
							if($skipIt)
							{
								if(/[A-Za-z0-9\"]>/)
								{
									$skipIt=0 if /^[ ]*\/a[ ]*>/;
								}
							}

							if($skipIt)
							{
								$line="$line<$_";
							} else {
								if(/[A-Za-z0-9\"]>/)
								{
									if(/^[ ]*a[ 	][ 	]*h/)
									{
										$skipIt=1;
										$first ? $line="$line$_" : $line="$line<$_";
									} else {
										($left,$right) = split(/>/,$_);
										$right=~s/([^A-Za-z0-9])($termclean)([^A-Za-z0-9])/$1<a href=\"$ref\">$2<\/a>$3/ig;
										$line="$line<$left>$right";
									}
								} else {
									$_=~s/([^A-Za-z0-9])($termclean)([^A-Za-z0-9])/$1<a href=\"$ref\">$2<\/a>$3/ig;
									$line="$line$_";
								}
								$first=0;
							}
						}
						$_[0]="$_[0]$line\n";
					}
				}
			}
		}
	}
}


sub substitute_keyterms
{
	my(@lines);
	my(@tmp);
	my($left);
	my($right);
	my($line);
	my($term);

	# Kinda complex keyword substitution routine


	# For each keyterm we have
	for $term (@g_keytermsSorted)
	{
		# If the doc we're scanning isn't the keyword target
		if($_[1] ne $g_keyterms{$term})
		{
			$termclean=$g_keytermsclean{$term};

			# If the doc matches the keyterm at least once
			if($_[0] =~ /$termclean/)
			{
				$ref=$g_keyterms{$term};
				@tmp = split(/</,$_[0]);
				$_[0]="";
				$first=1;
				$skipIt = 0;
				for(@tmp)
				{
					if($skipIt)
					{
						if(/[A-Za-z0-9\"]>/)
						{
							$skipIt=0 if /^[ ]*\/a[ ]*>/;
						}
					}

					if($skipIt)
					{
						$_[0]="$_[0]<$_";
					} else {
						if(/[A-Za-z0-9\"]>/)
						{
							if(/^[ ]*a[ 	][ 	]*h/)
							{
								$skipIt=1;
								$first ? $_[0] .= $_ : $_[0] .= "<$_";
							} else {
								($left,$right) = split(/>/,$_);
								$right=~s/([^A-Za-z0-9<>\+\-\=_])($termclean)([^A-Za-z0-9<>\+\-\=_])/$1<a href=\"$ref\">$2<\/a>$3/ig;
								$_[0] .= "<$left>$right";
							}
						} else {
							$_=~s/([^A-Za-z0-9<>\+\-\=_])($termclean)([^A-Za-z0-9<>\+\-\=_])/$1<a href=\"$ref\">$2<\/a>$3/ig;
							$_[0] .= $_;
						}
						$first=0;
					}
				}
			}
		}
	}
}




sub process_body_line
{
	$_[0] =~ s/	/\&nbsp\;\&nbsp\;\&nbsp\;\&nbsp\;/g;
	$_[0] =~ s/\</\&lt\;/g;
	$_[0] =~ s/\>/\&gt\;/g;
	$_[0] =~ s/\[br\]/\<br\>/g;
	$_[0] =~ s/\[b\]/\<b\>/g;
	$_[0] =~ s/\[p\]/\<p\>/g;
	$_[0] =~ s/\[\/p\]/\<\/p\>/g;
	$_[0] =~ s/\[\/b\]/\<\/b\>/g;
	$_[0] =~ s/\[big\]/\<h2\>/g;
	$_[0] =~ s/\[\/big\]/\<\/h2\>/g;
	$_[0] =~ s/\[pre\]/\<pre\>/g;
	$_[0] =~ s/\[\/pre\]/\<\/pre\>/g;
	$_[0] =~ s/\[center\]/\<center\>/g;
	$_[0] =~ s/\[\/center\]/\<\/center\>/g;
	$_[0] =~ s/\[i\]/\<i\>/g;
	$_[0] =~ s/\[\/i\]/\<\/i\>/g;
	$_[0] =~ s/\[ul\]/\<ul\>/g;
	$_[0] =~ s/\[\/ul\]/\<\/ul\>/g;
	$_[0] =~ s/\[li\]/\<li\>/g;
	$_[0] =~ s/\[\/li\]/\<\/li\>/g;
	$_[0] =~ s/\[table\]/\<table bgcolor=\"$g_internaltablecolor\" width=\"100\%\"\>/g;
	$_[0] =~ s/\[\/table\]/\<\/table\>/g;
	$_[0] =~ s/\[tr\]/\<tr\>/g;
	$_[0] =~ s/\[\/tr\]/\<\/tr\>/g;
	$_[0] =~ s/\[td\]/\<td\>/g;
	$_[0] =~ s/\[\/td\]/\<\/td\>/g;
	$_[0] =~ s/\[example\]/\<table width=\"100%\"\ cellpadding=\"2\">\<tr\>\<td\ bgcolor=\"$g_examplebgcolor\">\<pre\>\<code\>\<font color=\"$g_examplecolor\"\>/g;
	$_[0] =~ s/\[\/example\]/\<\/font\>\<\/code\>\<\/pre\>\<\/td\>\<\/tr\>\<\/table\>/g;
	$_[0] =~ s/\[comment\]/\<font color=\"$g_commentcolor\"\>/g;
	$_[0] =~ s/\[\/comment\]/\<\/font\>/g;
	$_[0] =~ s/\[doc\]([a-zA-Z0-9_]*)\[\/doc\]/\<a href=\"doc_\1$g_fileextension">\1\<\/a\>/g;
	$_[0] =~ s/\[doc:([a-zA-Z0-9_]*)\]([a-zA-Z0-9_\-\&\;\. ]*)\[\/doc\]/\<a href=\"doc_\1$g_fileextension"\>\2\<\/a\>/g;
	$_[0] =~ s/\[cmd\]([a-zA-Z0-9_\.]*)\[\/cmd\]/\<a href=\"cmd_\1$g_fileextension">\1\<\/a\>/g;
	$_[0] =~ s/\[cmd:([a-zA-Z0-9_\.]*)\]([a-zA-Z0-9_\-\&\;\. ]*)\[\/cmd\]/\<a href=\"cmd_\1$g_fileextension"\>\2\<\/a\>/g;
	$_[0] =~ s/\[fnc\]\$([a-zA-Z0-9_\.]*)\[\/fnc\]/\<a href=\"fnc_\1$g_fileextension">\$\1\<\/a\>/g;
	$_[0] =~ s/\[fnc:\$([a-zA-Z0-9_\.]*)\]\$([a-zA-Z0-9_\-\&\;\. ]*)\[\/fnc\]/\<a href=\"fnc_\1$g_fileextension"\>\$\2\<\/a\>/g;
	$_[0] =~ s/\[event\]\$([a-zA-Z0-9_]*)\[\/event\]/\<a href=\"event_\1$g_fileextension">\$\1\<\/a\>/g;
	$_[0] =~ s/\[event:([a-zA-Z0-9_]*)\]([a-zA-Z0-9_]*)\[\/event\]/\<a href=\"event_\1$g_fileextension">\2\<\/a\>/g;
	$_[0] =~ s/\[class\]([a-zA-Z0-9_]*)\[\/class\]/\<a href=\"class_\1$g_fileextension">\1\<\/a\>/g;
	$_[0] =~ s/\[class:([a-zA-Z0-9_]*)\]([a-zA-Z0-9_ ]*)\[\/class\]/\<a href=\"class_\1$g_fileextension">\2\<\/a\>/g;
	$_[0] =~ s/\[module:([a-zA-Z0-9_]*)\]([a-zA-Z0-9_ ]*)\[\/module\]/\<a href=\"module_\1$g_fileextension">\2\<\/a\>/g;
	$_[0] =~ s/\[widget:([a-zA-Z0-9_]*)\]([a-zA-Z0-9_ ]*)\[\/widget\]/\<a href=\"widget_\1$g_fileextension">\2\<\/a\>/g;
	$_[0] =~ s/\[classfnc:([a-zA-Z0-9_]*)\]\$([a-zA-Z0-9_]*)\[\/classfnc\]/\<a href=\"class_\1$g_fileextension#\2">\$\2\<\/a\>/g;
	$_[0] =~ s/\[classfnc\]\$([a-zA-Z0-9_]*)\[\/classfnc\]/\<a href=\"#\1">\$\1\<\/a\>/g;
	$_[0] =~ s/\[classsignal:([a-zA-Z0-9_]*)\]([a-zA-Z0-9_]*)\[\/classsignal\]/\<a href=\"class_\1$g_fileextension#\2">\2\<\/a\>/g;
	$_[0] =~ s/\[classsignal\]([a-zA-Z0-9_]*)\[\/classsignal\]/\<a href=\"#\1">\1\<\/a\>/g;
}

sub process_file
{
	my($docfilename);
	my(%parts);
	my($part); # Part title
	my($partbody);
	my($tabblock);
	my($tmp);
	my($type);


	if(!open(CPPFILE,"$_[0]"))
	{
		return;
	}
	# Process the entire file

	while(<CPPFILE>)
	{
		if(/^[ 	]*\@doc:[ 	a-z_]*/)
		{
			# Process a single document block

			$docfilename="$_";
			$docfilename=~ s/[ 	]*//g;
			$docfilename=~ s/\@doc://g;
			$docfilename=~ s/\n//g;

			undef %parts;

			INNERLOOP: while(<CPPFILE>)
			{

				if(/^[	 ]*\*\/[ 	]*/)
				{
					# End of comment
					if(($part ne "") && ($partbody ne "") && ($partbody ne "\n"))
					{
						# We have an entire part to store
						$parts{$part}="$partbody";
					}
					last INNERLOOP;
				} else {
					# Inside a part
					if(/^[	 ]*\@[a-z]*:[	 ]*/)
					{
						# A part title
						if(($part ne "") && ($partbody ne "") && ($partbody ne "\n"))
						{
							# We have an entire part to store
							$parts{$part}="$partbody";
						}
						# Start of the part
						# Extract the title
						$part="$_";
						$part=~ s/[	 ]*//g;
						$part=~ s/\@//g;
						$part=~ s/://g;
						$part=~ s/\n//g;
						# Clear the body (begin)
						$partbody="";
					} else {
						# Somewhere in a part body
						if(($_ ne "") && ($_ ne "\n"))
						{
							if($partbody eq "")
							{
								# If it is the first line of the part body
								# Extract the amount of tabs that the part has
								# We will use it to remove the C++ indentation
								$tabblock = "$_";
								$tabblock =~ s/^([	]*).*/\1/g;
								$tabblock =~ s/\n//g;
							}

							if($tabblock ne "")
							{
								# If we have the initial tabblock , remove it from the line (remove indentation)
								$_ =~ s/^$tabblock//g;
							}

							process_body_line($_);

							$partbody="$partbody$_";
						}
					}
				}
			}

			# Ok...we have a document in $parts

			# Process the title
			if($parts{'title'} eq "")
			{
				print "Warning: no title specified for $docfilename\n";
				$parts{'title'}="No title specified";
			}

			make_single_token($parts{'title'});
			make_single_line($parts{'syntax'});
			make_single_line($parts{'parameters'});
			make_single_line($parts{'inherits'});
			make_single_token($parts{'short'});
			make_single_token($parts{'window'});
			make_single_token($parts{'type'});

			$parts{'type'}=~ s/\@//g;
			$parts{'type'}=~ s/://g;

			if($parts{'type'} eq "")
			{
				$parts{'type'}="generic";
			}

			$type = $parts{'type'};

			$tmp = $g_prefixes{$type};
			if($tmp eq "")
			{
				$tmp="doc";
			}
			$docfilename="$tmp\_$docfilename";

			if($g_shortsIdx{$type} eq "")
			{
				$g_shortsIdx{$type} = 0;
			}

			$tmp="$type\_$g_shortsIdx{$type}";
			$g_shorts{$tmp}="$parts{'title'}<!>$parts{'short'}<!>$docfilename$g_fileextension";
			#print "$tmp, $g_shorts{$tmp}\n";
			$g_shortsIdx{$type}++;

			if($parts{'body'} ne "")
			{
				substitute_keyterms($parts{'body'},"$docfilename$g_fileextension");
			}
			if($parts{'description'} ne "")
			{
				substitute_keyterms($parts{'description'},"$docfilename$g_fileextension");
			}


			if(open(DOCFILE,">$g_directory/$docfilename$g_fileextension"))
			{
				$g_filehandle=DOCFILE;

				print_header($parts{'title'});
				print_tablestart();

				print_title($parts{'title'},$parts{'short'});
				if($parts{'syntax'} ne "")
				{
					print_entry("Syntax","<font color=\"$g_syntaxcolor\"><br><pre><code>$parts{'syntax'}</code></pre><br></font>");
				}
				if($parts{'parameters'} ne "")
				{
					print_entry("Parameters","<font color=\"$g_syntaxcolor\"><br><pre><code>$parts{'parameters'}</code></pre><br></font>");
				}
				print_entry("Inherits","$parts{'inherits'}");
				print_entry("Window","$parts{'window'}");
				print_entry("","$parts{'body'}");
				print_entry("Description","$parts{'description'}");


				if($parts{'functions'} ne "")
				{
					print_subtitle("Functions");

					print DOCFILE "  <tr bgcolor=\"$g_bodytablebgcolor\">\n";
					print DOCFILE "    <td>\n";
					print DOCFILE "      <table bgcolor=\"$g_classfncbodytablecolor\">\n";

					@lines = split("\n","$parts{'functions'}");
					$fncbody = "";
					for(@lines)
					{
						if(/!fn:.*/)
						{
							if("$fncbody" ne "")
							{
								print DOCFILE "<tr><td>$fncbody</td></tr>\n";
								$fncbody = "";
							}
							$_ =~ s/!fn:[ 	]*//g;
							$_ =~ s/^[	 ]*//g;
							$_ =~ s/\n//gs;
							$tmp = $_;
							$tmp =~ s/\(.*\)//g;
							$tmp =~ s/\$//g;
							print DOCFILE "<tr bgcolor=\"$g_classfnctablecolor\"><td><code><b><font color=\"$g_examplecolor\"><a name=\"$tmp\">$_</a></font></b></code></td></tr>\n";
						} else {
							if($fncbody ne "")
							{
								$fncbody="$fncbody $_";
							} else {
								$fncbody="$_";
							}
						}

					}
					if("$fncbody" ne "")
					{
						print DOCFILE "<tr><td>$fncbody</td></tr>\n";
					}

					print DOCFILE "      </table>\n";
					print DOCFILE "    </td>\n";
					print DOCFILE "  </tr>\n";
				}

				if($parts{'signals'} ne "")
				{
					print_subtitle("Signals");

					print DOCFILE "  <tr bgcolor=\"$g_bodytablebgcolor\">\n";
					print DOCFILE "    <td>\n";
					print DOCFILE "      <table bgcolor=\"$g_classfncbodytablecolor\">\n";

					@lines = split("\n","$parts{'signals'}");
					$sigbody = "";
					for(@lines)
					{
						if(/!sg:.*/)
						{
							if("$sigbody" ne "")
							{
								print DOCFILE "<tr><td>$sigbody</td></tr>\n";
								$sigbody = "";
							}
							$_ =~ s/!sg:[ 	]*//g;
							$_ =~ s/^[	 ]*//g;
							$_ =~ s/\n//gs;
							$tmp = $_;
							$tmp =~ s/\(.*\)//g;
							$tmp =~ s/\$//g;
							print DOCFILE "<tr bgcolor=\"$g_classfnctablecolor\"><td><code><b><font color=\"$g_examplecolor\"><a name=\"$tmp\">$_</a></font></b></code></td></tr>\n";
						} else {
							if($sigbody ne "")
							{
								$sigbody="$sigbody $_";
							} else {
								$sigbody="$_";
							}
						}

					}
					if("$sigbody" ne "")
					{
						print DOCFILE "<tr><td>$sigbody</td></tr>\n";
					}

					print DOCFILE "      </table>\n";
					print DOCFILE "    </td>\n";
					print DOCFILE "  </tr>\n";
				}

				print_entry("Examples","$parts{'examples'}");
				print_entry("See also","$parts{'seealso'}");
				print_tableend();


				if($parts{'type'} eq "command")
				{
					print DOCFILE "<hr><a href=\"index$g_fileextension\">Main index</a>, <a href=\"doc_command_index_all$g_fileextension\">Command index</a>\n";
				} elsif($parts{'type'} eq "function")
				{
					print DOCFILE "<hr><a href=\"index$g_fileextension\">Main index</a>, <a href=\"doc_function_index_all$g_fileextension\">Function index</a>\n";
				} elsif($parts{'type'} eq "event")
				{
					print DOCFILE "<hr><a href=\"index$g_fileextension\">Main index</a>, <a href=\"doc_event_index_all$g_fileextension\">Event index</a>\n";
				} elsif($parts{'type'} eq "generic")
				{
					print DOCFILE "<hr><a href=\"index$g_fileextension\">Main index</a>, <a href=\"doc_document_index_all$g_fileextension\">Miscelaneous documentation index</a>\n";
				} elsif($parts{'type'} eq "language")
				{
					print DOCFILE "<hr><a href=\"index$g_fileextension\">Main index</a>, <a href=\"doc_language_index_all$g_fileextension\">Language overview index</a>\n";
				} elsif($parts{'type'} eq "class")
				{
					print DOCFILE "<hr><a href=\"index$g_fileextension\">Main index</a>, <a href=\"doc_class_index_all$g_fileextension\">Object class index</a>\n";
				} elsif($parts{'type'} eq "module")
				{
					print DOCFILE "<hr><a href=\"index$g_fileextension\">Main index</a>, <a href=\"doc_module_index_all$g_fileextension\">Module documentation index</a>\n";
				} elsif($parts{'type'} eq "widget")
				{
					print DOCFILE "<hr><a href=\"index$g_fileextension\">Main index</a>, <a href=\"doc_widget_index_all$g_fileextension\">Interface help index</a>\n";
				}

				print_footer(DOCFILE);

				close(DOCFILE);
			} else { print "Can't open $g_directory/$docfilename$g_fileextension for writing\n"; }
		}
	}

	close(CPPFILE);
}


#################################################################################################
# COMMAND/FUNCTION.... INDEXES
#################################################################################################

sub generate_indexes
{
	my(@commands);
	my(@sortedCommands);
	my(@chars);
	my($alllinks);
	my($upcase);

	######################################################
	# generate some helper stuff (alphabetic index links)

	@chars=("\$","a","b","c","d","e","f","g","h","i","j","k","l","m","n","o","p","q","r","s","t","u","w","v","x","y","z");

	$i = 0;

	$alllinks="<table width=\"100%\" cellpadding=\"0\" cellspacing=\"0\"><tr>";

	for(@chars)
	{
		$alllinks = "$alllinks <td><a href=\"doc_$_[1]_alphabetic_$_$g_fileextension\">$_</a></td>\n";
		$i++;
		if($i > 13)
		{
			$i = 0;
			$alllinks = "$alllinks</tr><tr>\n";
		}
	}

	$alllinks ="$alllinks <td><a href=\"doc_$_[1]_index_all$g_fileextension\">All</a></td></tr></table>";


	#####################################
	# Simple plain long index

	$i=0;

	while($i < $g_shortsIdx{$_[1]})
	{
		$tmp="$_[1]_$i";
		$commands[$i]=$g_shorts{$tmp};
		#print "$i : $commands[$i], $g_shorts{$tmp}, command_$i\n";
		$i++;
	}

	@sortedCommands = sort @commands;



	if(open(CMDINDEX,">$g_directory/doc_$_[1]_index_all$g_fileextension"))
	{
		$g_filehandle=CMDINDEX;
	
		print_header("$_[0]: All");
		print_tablestart();
		print_title("$_[0]: All","");
		print_tableend();

		print_tablestart();
		print_body($alllinks);
		print_tableend();

		print_tablestart();
	
		$i=0;
		#print "$g_shortsIdx{$_[1]}";
		while($i < $g_shortsIdx{$_[1]})
		{
			($cmd,$short,$link) = split("<!>",$sortedCommands[$i]);
			print_twocolumnbody("<a href=\"$link\">$cmd</a>",$short);
			$i++;
		}
	
		print_tableend();

		print_tablestart();
		print_body($alllinks);
		print_tableend();

		print_footer();
	
		close(CMDINDEX);
	} else {
		print "Can't open $g_directory/doc_$_[1]_index_all$g_fileextension for writing\n";
	}


	#######################
	# Alphabetic

	for(@chars)
	{
		if(open(CMDINDEX,">$g_directory/doc_$_[1]_alphabetic_$_$g_fileextension"))
		{

			$upcase=$_;
			$upcase=~ tr/abcdefghijklmnopqrstuvwxyz/ABCDEFGHIJKLMNOPQRSTUVWXYZ/;


			$g_filehandle=CMDINDEX;
		
			print_header("$_[0]: $_");
			print_tablestart();
			print_title("$_[0]: $_","");
			print_tableend();

			print_tablestart();
			print_body($alllinks);
			print_tableend();

			print_tablestart();
		
			$i=0;
			$j=0;
			if($_[2] > 0)
			{
				while($i < $g_shortsIdx{$_[1]})
				{
					($cmd,$short,$link) = split("<!>",$sortedCommands[$i]);
					$left=substr($cmd,0,$_[2]);
					$right=$cmd;
					$right=~ s/^$left//;

					if(($right =~ /^$_/) or ($right =~ /^$upcase/) or ($right eq $_))
					{
						$j++;
						print_twocolumnbody("<a href=\"$link\">$left$right</a>",$short);
					}
					$i++;
				}

			} else {
				while($i < $g_shortsIdx{$_[1]})
				{
					($cmd,$short,$link) = split("<!>",$sortedCommands[$i]);
					if(($cmd =~ /^$_/) || ($cmd =~ /^$upcase/))
					{
						$j++;
						print_twocolumnbody("<a href=\"$link\">$cmd</a>",$short);
					}
					$i++;
				}
			}

			if($j == 0)
			{
				print_body("No matches");
			}

			print_tableend();

			print_tablestart();
			print_body($alllinks);
			print_tableend();

			print_footer();
		
			close(CMDINDEX);
		} else {
			print "Can't open $g_directory/doc_$_[1]\_alphabetic_$_$g_fileextension for writing\n";
		}
	}
}

#################################################################################################
# MAIN
#################################################################################################

# Force flusing of STDOUT
$|=1;

print "*\n";
print "* Generating documentation: this may take a while :)\n";
print "*\n";
print "* Extracting keyterms\n";
# Extract the keywords to generate the crossreferences
$i = 1;

while($ARGV[$i] ne "")
{
	print ".";
	extract_keyterms($ARGV[$i]);
	$i++;
}

$g_files=$i - 1;

print "\n";
print "* Extracting documents and generating crossreferences\n";

# Sort them
@g_keytermsSorted = sort {length($b) <=> length($a)} keys(%g_keyterms);

# Process the files now
$i = 1;

while($ARGV[$i] ne "")
{
	print ".";
	process_file($ARGV[$i]);
	$i++;
}

print "\n";
print "* Generating indexes\n";

print ".";
generate_indexes("Command index","command",0);
print ".";
generate_indexes("Function index","function",1);
print ".";
generate_indexes("Modules","module",0);
print ".";
generate_indexes("Classes","class",0);
print ".";
generate_indexes("Events","event",2);
print ".";
generate_indexes("Language documentation index","language",0);
print ".";
generate_indexes("Widget documentation index","widget",0);
print ".";
generate_indexes("Misc documentation index","generic",0);
print ".";
generate_indexes("Keyterms index","keyterms",0);
print ".";

if(open(DOCINDEX,">$g_directory/index$g_fileextension"))
{
	$g_filehandle=DOCINDEX;
	print_header("Documentation index");
	print_tablestart();
	print_title("Index","");
	print_subtitle("Fundamentals");
	print_body("<a href=\"doc_ircintro$g_fileextension\">Introduction to IRC</a>");
	print_body("<a href=\"doc_kvircintro$g_fileextension\">Introduction to KVIrc</a>");
	print_subtitle("Scripting concepts");
	print_body("<a href=\"doc_language_overview$g_fileextension\">Language overview</a>");
	print_body("<a href=\"doc_data_types$g_fileextension\">Data types</a>");
	print_body("<a href=\"doc_operators$g_fileextension\">Operators</a>");
	print_body("<a href=\"doc_aliases$g_fileextension\">Aliases</a>");
	print_body("<a href=\"doc_events$g_fileextension\">Events</a>");
	print_body("<a href=\"doc_objects$g_fileextension\">Objects</a>");
	print_body("<a href=\"doc_language_index_all$g_fileextension\">All the language documents</a>");
	print_subtitle("Scripting reference");
	print_body("<a href=\"doc_command_index_all$g_fileextension\">Command index</a>");
	print_body("<a href=\"doc_function_index_all$g_fileextension\">Function index</a>");
	print_body("<a href=\"doc_event_index_all$g_fileextension\">Event index</a>");
	print_body("<a href=\"doc_class_index_all$g_fileextension\">Object class index</a>");
	print_subtitle("Other documentation");
	print_body("<a href=\"doc_module_index_all$g_fileextension\">Modules</a>");
	print_body("<a href=\"doc_widget_index_all$g_fileextension\">Interface help index</a>");
	print_body("<a href=\"doc_generic_index_all$g_fileextension\">Miscelaneous</a>");
	print_body("<a href=\"doc_keyterms_index_all$g_fileextension\">Index of terms and concepts</a>");
	print_tableend();
	print_footer();

	close(DOCINDEX);
} else {
	print "Can't open $g_directory/index$g_fileextension for writing\n";
}

print "\n";
print "*\n";
print "* Done! (processed $g_files files)\n";
print "*\n";
