#!/usr/bin/perl

#################################################################################################
# GLOBAL CONFIGS
#################################################################################################

$g_currenttime=gmtime;
$g_currentuser = getlogin || getpwuid($<) || "Unknown";
$g_examplecolor="#FF0000";
$g_syntaxcolor="#802000";
$g_bodybgcolor="#FFFFFF";
$g_bodytextcolor="#000000";
$g_titletablebgcolor="#A0A0A0";
$g_subtitletablebgcolor="#D0D0D0";
$g_internaltablecolor="#E0E0E0";
$g_classfnctablecolor="#E0E0E0";
$g_classfncbodytablecolor="#EAEAEA";
$g_bodytablebgcolor="#F0F0F0";
$g_commentcolor="#207500";
$g_fileextension=".html";
$g_documentheader="KVirc documentation<br><hr>\n";
$g_documentfooter="<hr>KVirc documentation<br>Generated by $g_currentuser at $g_currenttime\n";

#################################################################################################
# DOCUMENT ARRAYS
#################################################################################################

$g_commandIdx = 0;
$g_documentIdx = 0;
$g_functionIdx = 0;
$g_eventIdx = 0;
$g_language = 0;
$g_classIdx = 0;
$g_moduleIdx = 0;
$g_widgetsIdx = 0;
$g_keytermIdx = 0;

#################################################################################################
# FIND OUT THE TARGET DIRECTORY
#################################################################################################

$g_directory="$ARGV[0]";

if($g_directory eq "")
{
	print "No directory specified\n";
	exit(-1);
}

print "Directory: $g_directory\n";


#################################################################################################
# DOCUMENT PROCESSING LOOP
#################################################################################################

$i=1;

while($ARGV[$i] ne "")
{
	print "Processing file: $ARGV[$i]\n";

	if(open(DATAFILE,$ARGV[$i]))
	{
		while(<DATAFILE>)
		{
			if(/^[ 	]*\@doc:[ 	a-z_]*/)
			{
				$g_docfilename="$_";
				$g_docfilename=~ s/[ 	]*//g;
				$g_docfilename=~ s/\@doc://g;
				$g_docfilename=~ s/\n//g;

				undef %g_parts;

				$part = "";
				$partbody = "";
				$tabblock="";

				INNERLOOP: while(<DATAFILE>)
				{
					if(/^[	 ]*\*\/[ 	]*/)
					{
						if(($part ne "") && ($partbody ne "") && ($partbody ne "\n"))
						{
							$g_parts{$part}="$partbody";
						}
						last INNERLOOP;
					} else {
						if(/^[	 ]*\@[a-z]*:[	 ]*/)
						{
							if(($part ne "") && ($partbody ne "") && ($partbody ne "\n"))
							{
								$g_parts{$part}="$partbody";
							}
							$part="$_";
							$part=~ s/[	 ]*//g;
							$part=~ s/\@//g;
							$part=~ s/://g;
							$part=~ s/\n//g;
							$partbody="";
						} else {
							if(($_ ne "") && ($_ ne "\n"))
							{
								if($partbody eq "")
								{
									$tabblock = "$_";
									$tabblock =~ s/^([	]*).*/\1/g;
									$tabblock =~ s/\n//g;
								}
								if($tabblock ne "")
								{
									$_ =~ s/^$tabblock//g;
								}

								$_ =~ s/	/\&nbsp\;\&nbsp\;\&nbsp\;\&nbsp\;/g;
								$_ =~ s/\</\&lt\;/g;
								$_ =~ s/\>/\&gt\;/g;
								$_ =~ s/\[br\]/\<br\>/g;
								$_ =~ s/\[b\]/\<b\>/g;
								$_ =~ s/\[p\]/\<p\>/g;
								$_ =~ s/\[\/p\]/\<\/p\>/g;
								$_ =~ s/\[\/b\]/\<\/b\>/g;
								$_ =~ s/\[big\]/\<h2\>/g;
								$_ =~ s/\[\/big\]/\<\/h2\>/g;
								$_ =~ s/\[pre\]/\<pre\>/g;
								$_ =~ s/\[\/pre\]/\<\/pre\>/g;
								$_ =~ s/\[center\]/\<center\>/g;
								$_ =~ s/\[\/center\]/\<\/center\>/g;
								$_ =~ s/\[i\]/\<i\>/g;
								$_ =~ s/\[\/i\]/\<\/i\>/g;
								$_ =~ s/\[ul\]/\<ul\>/g;
								$_ =~ s/\[\/ul\]/\<\/ul\>/g;
								$_ =~ s/\[li\]/\<li\>/g;
								$_ =~ s/\[\/li\]/\<\/li\>/g;
								$_ =~ s/\[table\]/\<table bgcolor=\"$g_internaltablecolor\" width=\"100\%\"\>/g;
								$_ =~ s/\[\/table\]/\<\/table\>/g;
								$_ =~ s/\[tr\]/\<tr\>/g;
								$_ =~ s/\[\/tr\]/\<\/tr\>/g;
								$_ =~ s/\[td\]/\<td\>/g;
								$_ =~ s/\[\/td\]/\<\/td\>/g;
								$_ =~ s/\[example\]/\<pre\>\<code\>\<font color=\"$g_examplecolor\"\>/g;
								$_ =~ s/\[\/example\]/\<\/font\>\<\/code\>\<\/pre\>/g;
								$_ =~ s/\[comment\]/\<font color=\"$g_commentcolor\"\>/g;
								$_ =~ s/\[\/comment\]/\<\/font\>/g;
								$_ =~ s/\[doc\]([a-zA-Z0-9_]*)\[\/doc\]/\<a href=\"doc_\1$g_fileextension">\1\<\/a\>/g;
								$_ =~ s/\[doc:([a-zA-Z0-9_]*)\]([a-zA-Z0-9_\-\&\;\. ]*)\[\/doc\]/\<a href=\"doc_\1$g_fileextension"\>\2\<\/a\>/g;
								$_ =~ s/\[cmd\]([a-zA-Z0-9_\.]*)\[\/cmd\]/\<a href=\"cmd_\1$g_fileextension">\1\<\/a\>/g;
								$_ =~ s/\[cmd:([a-zA-Z0-9_\.]*)\]([a-zA-Z0-9_\-\&\;\. ]*)\[\/cmd\]/\<a href=\"cmd_\1$g_fileextension"\>\2\<\/a\>/g;
								$_ =~ s/\[fnc\]\$([a-zA-Z0-9_\.]*)\[\/fnc\]/\<a href=\"fnc_\1$g_fileextension">\$\1\<\/a\>/g;
								$_ =~ s/\[fnc:\$([a-zA-Z0-9_\.]*)\]\$([a-zA-Z0-9_\-\&\;\. ]*)\[\/fnc\]/\<a href=\"fnc_\1$g_fileextension"\>\$\2\<\/a\>/g;
								$_ =~ s/\[event\]\$([a-zA-Z0-9_]*)\[\/event\]/\<a href=\"event_\1$g_fileextension">\$\1\<\/a\>/g;
								$_ =~ s/\[event:([a-zA-Z0-9_]*)\]([a-zA-Z0-9_]*)\[\/event\]/\<a href=\"event_\1$g_fileextension">\2\<\/a\>/g;
								$_ =~ s/\[class\]([a-zA-Z0-9_]*)\[\/class\]/\<a href=\"class_\1$g_fileextension">\1\<\/a\>/g;
								$_ =~ s/\[class:([a-zA-Z0-9_]*)\]([a-zA-Z0-9_ ]*)\[\/class\]/\<a href=\"class_\1$g_fileextension">\2\<\/a\>/g;
								$_ =~ s/\[module:([a-zA-Z0-9_]*)\]([a-zA-Z0-9_ ]*)\[\/module\]/\<a href=\"module_\1$g_fileextension">\2\<\/a\>/g;
								$_ =~ s/\[widget:([a-zA-Z0-9_]*)\]([a-zA-Z0-9_ ]*)\[\/widget\]/\<a href=\"widget_\1$g_fileextension">\2\<\/a\>/g;
								$_ =~ s/\[classfnc:([a-zA-Z0-9_]*)\]\$([a-zA-Z0-9_]*)\[\/classfnc\]/\<a href=\"class_\1$g_fileextension#\2">\$\2\<\/a\>/g;
								$_ =~ s/\[classfnc\]\$([a-zA-Z0-9_]*)\[\/classfnc\]/\<a href=\"#\1">\$\1\<\/a\>/g;
								$_ =~ s/\[classsignal:([a-zA-Z0-9_]*)\]([a-zA-Z0-9_]*)\[\/classsignal\]/\<a href=\"class_\1$g_fileextension#\2">\2\<\/a\>/g;
								$_ =~ s/\[classsignal\]([a-zA-Z0-9_]*)\[\/classsignal\]/\<a href=\"#\1">\1\<\/a\>/g;
								$partbody="$partbody$_";
							}
						}
					}
				}

				# Ok...we have a document in $g_parts

				if($g_parts{'title'} eq "")
				{
					print "Warning: no title specified for $g_docfilename\n";

					$g_parts{'title'}="No title specified";
				}

				$g_parts{'title'} =~ s/^[	 ]*//g;
				$g_parts{'title'} =~ s/[	 ]*$//g;
				$g_parts{'title'} =~ s/\n//g;

				if($g_parts{'syntax'} ne "")
				{
					$g_parts{'syntax'} =~ s/^[ 	]*//g;
					$g_parts{'syntax'} =~ s/[	 \n]*$//gs;
					# $g_parts{'syntax'} =~ s/\n//g;
				}

				if($g_parts{'parameters'} ne "")
				{
					$g_parts{'parameters'} =~ s/^[ 	]*//g;
					$g_parts{'parameters'} =~ s/[	 \n]*$//gs;
					# $g_parts{'parameters'} =~ s/\n//g;
				}

				if($g_parts{'inherits'} ne "")
				{
					$g_parts{'inherits'} =~ s/^[ 	]*//g;
					$g_parts{'inherits'} =~ s/[	 \n]*$//gs;
					# $g_parts{'inherits'} =~ s/\n//g;
				}

				if($g_parts{'short'} ne "")
				{
					$g_parts{'short'} =~ s/^[ 	]*//g;
					$g_parts{'short'} =~ s/[	 ]*$//g;
					$g_parts{'short'} =~ s/\n//g;
				}

				if($g_parts{'window'} ne "")
				{
					$g_parts{'window'} =~ s/^[ 	]*//g;
					$g_parts{'window'} =~ s/[	 ]*$//g;
					$g_parts{'window'} =~ s/\n//g;
				}

				if($g_parts{'type'} ne "")
				{
					$g_parts{'type'}=~ s/[	 ]*//g;
					$g_parts{'type'}=~ s/\@//g;
					$g_parts{'type'}=~ s/://g;
					$g_parts{'type'}=~ s/\n//g;
				} else {
					$g_parts{'type'} = "generic";
				}

				if($g_parts{'type'} eq "command")
				{
					$g_docfilename="cmd_$g_docfilename";
					$g_commands[$g_commandIdx]="$g_parts{'title'}<!>$g_parts{'short'}<!>$g_docfilename$g_fileextension";
					$g_commandIdx++;
				} elsif ($g_parts{'type'} eq "function"){
					$g_docfilename="fnc_$g_docfilename";
					$g_functions[$g_functionIdx]="$g_parts{'title'}<!>$g_parts{'short'}<!>$g_docfilename$g_fileextension";
					$g_functionIdx++;
				} elsif ($g_parts{'type'} eq "event"){
					$g_docfilename="event_$g_docfilename";
					$g_events[$g_eventIdx]="$g_parts{'title'}<!>$g_parts{'short'}<!>$g_docfilename$g_fileextension";
					$g_eventIdx++;
				} elsif ($g_parts{'type'} eq "language"){
					$g_docfilename="doc_$g_docfilename";
					$g_languages[$g_languageIdx]="$g_parts{'title'}<!>$g_parts{'short'}<!>$g_docfilename$g_fileextension";
					$g_languageIdx++;
				} elsif ($g_parts{'type'} eq "class"){
					$g_docfilename="class_$g_docfilename";
					$g_classes[$g_classIdx]="$g_parts{'title'}<!>$g_parts{'short'}<!>$g_docfilename$g_fileextension";
					$g_classIdx++;
				} elsif ($g_parts{'type'} eq "module"){
					$g_docfilename="module_$g_docfilename";
					$g_modules[$g_moduleIdx]="$g_parts{'title'}<!>$g_parts{'short'}<!>$g_docfilename$g_fileextension";
					$g_moduleIdx++;
				} elsif ($g_parts{'type'} eq "widget"){
					$g_docfilename="widget_$g_docfilename";
					$g_widgets[$g_widgetIdx]="$g_parts{'title'}<!>$g_parts{'short'}<!>$g_docfilename$g_fileextension";
					$g_widgetIdx++;
				} else {
					$g_docfilename="doc_$g_docfilename";
					$g_documents[$g_documentIdx]="$g_parts{'title'}<!>$g_parts{'short'}<!>$g_docfilename$g_fileextension";
					$g_documentIdx++;
				}


				if($g_parts{'keyterms'} ne "")
				{
					$keyterms = $g_parts{'keyterms'};
					$keyterms =~ s/\n//gs;
					for $term (split(/,/,$keyterms))
					{
						$term =~ s/^[ 	]*//g;
						$term =~ s/[ 	\n]*$//gs;
						$term =~ s/\n//g;
						if($term ne "")
						{
							$g_keyterms[$g_keytermIdx] = "$term<!>$g_docfilename$g_fileextension<!>$g_parts{'title'}";
							$g_keytermIdx ++;
						}
					}
				}

				$g_keyterms[$g_keytermIdx] = "$g_parts{'title'}<!>$g_docfilename$g_fileextension<!>$g_parts{'title'}";
				$g_keyterms[$g_keytermIdx] =~ y/A-Z/a-z/;
				$g_keytermIdx++;

				if(open(DOCFILE,">$g_directory/$g_docfilename$g_fileextension"))
				{
					print "Writing document $g_directory/$g_docfilename$g_fileextension\n";

					print DOCFILE "<html>\n";
					print DOCFILE "<head>\n";
					print DOCFILE "<title>$g_parts{'title'}</title>\n";
					print DOCFILE "</head>\n";
					print DOCFILE "<body bgcolor=\"$g_bodybgcolor\" text=\"$g_bodytextcolor\">\n";

					print DOCFILE "$g_documentheader\n";

					print DOCFILE "<table bgcolor=\"$g_titletablebgcolor\" width=\"100%\">\n";

					print DOCFILE "  <tr>\n";
					print DOCFILE "    <td>\n";
					print DOCFILE "      <h1>$g_parts{'title'}</h1>\n";
					print DOCFILE "      <a name=\"searchbody\"></a>\n";
					if($g_parts{'short'} ne "")
					{
						print DOCFILE "$g_parts{'short'}\n";
					}
					print DOCFILE "    </td>\n";
					print DOCFILE "  </tr>\n";

					if($g_parts{'syntax'} ne "")
					{
						print DOCFILE "  <tr bgcolor=\"$g_subtitletablebgcolor\">\n";
						print DOCFILE "    <td><b>Syntax</b></td>\n";
						print DOCFILE "  </tr>\n";
						print DOCFILE "  <tr bgcolor=\"$g_bodytablebgcolor\">\n";
						print DOCFILE "    <td><font color=\"$g_syntaxcolor\"><pre><code>$g_parts{'syntax'}</code></pre></font></td>\n";
						print DOCFILE "  </tr>\n";
					}

					if($g_parts{'parameters'} ne "")
					{
						print DOCFILE "  <tr bgcolor=\"$g_subtitletablebgcolor\">\n";
						print DOCFILE "    <td><b>Parameters</b></td>\n";
						print DOCFILE "  </tr>\n";
						print DOCFILE "  <tr bgcolor=\"$g_bodytablebgcolor\">\n";
						print DOCFILE "    <td><font color=\"$g_syntaxcolor\"><pre><code>$g_parts{'parameters'}</code></pre></font></td>\n";
						print DOCFILE "  </tr>\n";
					}

					if($g_parts{'inherits'} ne "")
					{
						print DOCFILE "  <tr bgcolor=\"$g_subtitletablebgcolor\">\n";
						print DOCFILE "    <td><b>Inherits</b></td>\n";
						print DOCFILE "  </tr>\n";
						print DOCFILE "  <tr bgcolor=\"$g_bodytablebgcolor\">\n";
						print DOCFILE "    <td>\n";
						print DOCFILE "      $g_parts{'inherits'}\n";
						print DOCFILE "    </td>\n";
						print DOCFILE "  </tr>\n";
					}

					if($g_parts{'window'} ne "")
					{
						print DOCFILE "  <tr bgcolor=\"$g_subtitletablebgcolor\">\n";
						print DOCFILE "    <td><b>Window</b></td>\n";
						print DOCFILE "  </tr>\n";
						print DOCFILE "  <tr bgcolor=\"$g_bodytablebgcolor\">\n";
						print DOCFILE "    <td>\n";
						print DOCFILE "      $g_parts{'window'}\n";
						print DOCFILE "    </td>\n";
						print DOCFILE "  </tr>\n";
					}

					if($g_parts{'body'} ne "")
					{
						print DOCFILE "  <tr bgcolor=\"$g_bodytablebgcolor\">\n";
						print DOCFILE "    <td>\n";
						print DOCFILE "      $g_parts{'body'}\n";
						print DOCFILE "    </td>\n";
						print DOCFILE "  </tr>\n";
					}
					if($g_parts{'description'} ne "")
					{
						print DOCFILE "  <tr bgcolor=\"$g_subtitletablebgcolor\">\n";
						print DOCFILE "    <td><b>Description</b></td>\n";
						print DOCFILE "  </tr>\n";
						print DOCFILE "  <tr bgcolor=\"$g_bodytablebgcolor\">\n";
						print DOCFILE "    <td>\n";
						print DOCFILE "      $g_parts{'description'}\n";
						print DOCFILE "    </td>\n";
						print DOCFILE "  </tr>\n";
					}
					if($g_parts{'functions'} ne "")
					{
						print DOCFILE "  <tr bgcolor=\"$g_subtitletablebgcolor\">\n";
						print DOCFILE "    <td><b>Functions</b></td>\n";
						print DOCFILE "  </tr>\n";
						print DOCFILE "  <tr bgcolor=\"$g_bodytablebgcolor\">\n";
						print DOCFILE "    <td>\n";
						print DOCFILE "      <table bgcolor=\"$g_classfncbodytablecolor\">\n";

						@lines = split("\n","$g_parts{'functions'}");
						$fncbody = "";
						for(@lines)
						{
							if(/!fn:.*/)
							{
								if("$fncbody" ne "")
								{
									print DOCFILE "<tr><td>$fncbody</td></tr>\n";
									$fncbody = "";
								}
								$_ =~ s/!fn:[ 	]*//g;
								$_ =~ s/^[	 ]*//g;
								$_ =~ s/\n//gs;
								$tmp = $_;
								$tmp =~ s/\(.*\)//g;
								$tmp =~ s/\$//g;
								print DOCFILE "<tr bgcolor=\"$g_classfnctablecolor\"><td><code><b><font color=\"$g_examplecolor\"><a name=\"$tmp\">$_</a></font></b></code></td></tr>\n";
							} else {
								if($fncbody ne "")
								{
									$fncbody="$fncbody $_";
								} else {
									$fncbody="$_";
								}
							}

						}
						if("$fncbody" ne "")
						{
							print DOCFILE "<tr><td>$fncbody</td></tr>\n";
						}

						print DOCFILE "      </table>\n";
						print DOCFILE "    </td>\n";
						print DOCFILE "  </tr>\n";
					}

					if($g_parts{'signals'} ne "")
					{
						print DOCFILE "  <tr bgcolor=\"$g_subtitletablebgcolor\">\n";
						print DOCFILE "    <td><b>Signals</b></td>\n";
						print DOCFILE "  </tr>\n";
						print DOCFILE "  <tr bgcolor=\"$g_bodytablebgcolor\">\n";
						print DOCFILE "    <td>\n";
						print DOCFILE "      <table bgcolor=\"$g_classfncbodytablecolor\">\n";

						@lines = split("\n","$g_parts{'signals'}");
						$sigbody = "";
						for(@lines)
						{
							if(/!sg:.*/)
							{
								if("$sigbody" ne "")
								{
									print DOCFILE "<tr><td>$sigbody</td></tr>\n";
									$sigbody = "";
								}
								$_ =~ s/!sg:[ 	]*//g;
								$_ =~ s/^[	 ]*//g;
								$_ =~ s/\n//gs;
								$tmp = $_;
								$tmp =~ s/\(.*\)//g;
								$tmp =~ s/\$//g;
								print DOCFILE "<tr bgcolor=\"$g_classfnctablecolor\"><td><code><b><font color=\"$g_examplecolor\"><a name=\"$tmp\">$_</a></font></b></code></td></tr>\n";
							} else {
								if($sigbody ne "")
								{
									$sigbody="$sigbody $_";
								} else {
									$sigbody="$_";
								}
							}

						}
						if("$sigbody" ne "")
						{
							print DOCFILE "<tr><td>$sigbody</td></tr>\n";
						}

						print DOCFILE "      </table>\n";
						print DOCFILE "    </td>\n";
						print DOCFILE "  </tr>\n";
					}

					if($g_parts{'examples'} ne "")
					{
						print DOCFILE "  <tr bgcolor=\"$g_subtitletablebgcolor\">\n";
						print DOCFILE "    <td><b>Examples</b></td>\n";
						print DOCFILE "  </tr>\n";
						print DOCFILE "  <tr bgcolor=\"$g_bodytablebgcolor\">\n";
						print DOCFILE "    <td>\n";
						print DOCFILE "      $g_parts{'examples'}\n";
						print DOCFILE "    </td>\n";
						print DOCFILE "  </tr>\n";
					}
					if($g_parts{'seealso'} ne "")
					{
						print DOCFILE "  <tr bgcolor=\"$g_subtitletablebgcolor\">\n";
						print DOCFILE "    <td><b>See also</b></td>\n";
						print DOCFILE "  </tr>\n";
						print DOCFILE "  <tr bgcolor=\"$g_bodytablebgcolor\">\n";
						print DOCFILE "    <td>$g_parts{'seealso'}</td>\n";
						print DOCFILE "  </tr>\n";
					}
					print DOCFILE "</table>\n";

					if($g_parts{'type'} eq "command")
					{
						print DOCFILE "<hr><a href=\"index$g_fileextension\">Main index</a>, <a href=\"doc_commands$g_fileextension\">Command index</a>\n";
					} elsif($g_parts{'type'} eq "function")
					{
						print DOCFILE "<hr><a href=\"index$g_fileextension\">Main index</a>, <a href=\"doc_functions$g_fileextension\">Function index</a>\n";
					} elsif($g_parts{'type'} eq "event")
					{
						print DOCFILE "<hr><a href=\"index$g_fileextension\">Main index</a>, <a href=\"doc_events$g_fileextension\">Event index</a>\n";
					} elsif($g_parts{'type'} eq "generic")
					{
						print DOCFILE "<hr><a href=\"index$g_fileextension\">Main index</a>, <a href=\"doc_documents$g_fileextension\">Miscelaneous documentation index</a>\n";
					} elsif($g_parts{'type'} eq "language")
					{
						print DOCFILE "<hr><a href=\"index$g_fileextension\">Main index</a>, <a href=\"doc_language$g_fileextension\">Language overview index</a>\n";
					} elsif($g_parts{'type'} eq "class")
					{
						print DOCFILE "<hr><a href=\"index$g_fileextension\">Main index</a>, <a href=\"doc_classes$g_fileextension\">Object class index</a>\n";
					} elsif($g_parts{'type'} eq "module")
					{
						print DOCFILE "<hr><a href=\"index$g_fileextension\">Main index</a>, <a href=\"doc_moduleindex$g_fileextension\">Module documentation index</a>\n";
					} elsif($g_parts{'type'} eq "widget")
					{
						print DOCFILE "<hr><a href=\"index$g_fileextension\">Main index</a>, <a href=\"doc_widgets$g_fileextension\">Interface help index</a>\n";
					}

					print DOCFILE "$g_documentfooter\n";

					print DOCFILE "</body>\n";
					print DOCFILE "</html>\n";

					close(DOCFILE);
				} else { print "Can't open $g_directory/$g_docfilename$g_fileextension for writing\n"; }
			}
		}
		close(DATAFILE);
	}

	$i++;
}

print "Writing document $g_directory/doc_commands$g_fileextension\n";

if(open(CMDINDEX,">$g_directory/doc_commands$g_fileextension"))
{

	print CMDINDEX "<html>\n";
	print CMDINDEX "<head>\n";
	print CMDINDEX "<title>Command index</title>\n";
	print CMDINDEX "</head>\n";
	print CMDINDEX "<body bgcolor=\"$g_bodybgcolor\" text=\"$g_bodytextcolor\">\n";
	print CMDINDEX "$g_documentheader\n";
	print CMDINDEX "<table width=\"100%\">\n";
	print CMDINDEX "  <tr bgcolor=\"$g_titletablebgcolor\">\n";
	print CMDINDEX "    <td>\n";
	print CMDINDEX "      <h1>Command index</h1>\n";
	print CMDINDEX "      <a name=\"searchbody\"></a>\n";
	print CMDINDEX "    </td>\n";
	print CMDINDEX "  </tr>\n";
	print CMDINDEX "</table>\n";
	print CMDINDEX "<table width=\"100%\">\n";

	@sortedCommands = sort @g_commands;

	$i=0;
	while($i < $g_commandIdx)
	{
		($cmd,$short,$link) = split("<!>",$sortedCommands[$i]);
		print CMDINDEX "<tr bgcolor=\"$g_bodytablebgcolor\">\n";
		print CMDINDEX "  <td><a href=\"$link\">$cmd</a></td>\n";
		print CMDINDEX "  <td>$short</td>\n";
		print CMDINDEX "</tr>\n";
		$i++;
	}

	print CMDINDEX "</table>\n";
	print CMDINDEX "<hr><a href=\"index$g_fileextension\">Main index</a>\n";
	print CMDINDEX "$g_documentfooter\n";
	print CMDINDEX "</body>\n";
	print CMDINDEX "</html>\n";

	close(CMDINDEX);
} else {
	print "Can't open $g_directory/doc_commands$g_fileextension for writing\n";
}

print "Writing document $g_directory/doc_functions$g_fileextension\n";

if(open(FNCINDEX,">$g_directory/doc_functions$g_fileextension"))
{

	print FNCINDEX "<html>\n";
	print FNCINDEX "<head>\n";
	print FNCINDEX "<title>Function index</title>\n";
	print FNCINDEX "</head>\n";
	print FNCINDEX "<body bgcolor=\"$g_bodybgcolor\" text=\"$g_bodytextcolor\">\n";
	print FNCINDEX "$g_documentheader\n";
	print FNCINDEX "<table width=\"100%\">\n";
	print FNCINDEX "  <tr bgcolor=\"$g_titletablebgcolor\">\n";
	print FNCINDEX "    <td>\n";
	print FNCINDEX "      <h1>Function index</h1>\n";
	print FNCINDEX "      <a name=\"searchbody\"></a>\n";
	print FNCINDEX "    </td>\n";
	print FNCINDEX "  </tr>\n";
	print FNCINDEX "</table>\n";
	print FNCINDEX "<table width=\"100%\">\n";

	@sortedFunctions = sort @g_functions;

	$i=0;
	while($i < $g_functionIdx)
	{
		($fnc,$short,$link) = split("<!>",$sortedFunctions[$i]);
		print FNCINDEX "<tr bgcolor=\"$g_bodytablebgcolor\">\n";
		print FNCINDEX "  <td><a href=\"$link\">$fnc</a></td>\n";
		print FNCINDEX "  <td>$short</td>\n";
		print FNCINDEX "</tr>\n";
		$i++;
	}

	print FNCINDEX "</table>\n";
	print FNCINDEX "<hr><a href=\"index$g_fileextension\">Main index</a>\n";
	print FNCINDEX "$g_documentfooter\n";
	print FNCINDEX "</body>\n";
	print FNCINDEX "</html>\n";

	close(FNCINDEX);
} else {
	print "Can't open $g_directory/doc_functions$g_fileextension for writing\n";
}


print "Writing document $g_directory/doc_events$g_fileextension\n";

if(open(EVENTINDEX,">$g_directory/doc_events$g_fileextension"))
{

	print EVENTINDEX "<html>\n";
	print EVENTINDEX "<head>\n";
	print EVENTINDEX "<title>Event index</title>\n";
	print EVENTINDEX "</head>\n";
	print EVENTINDEX "<body bgcolor=\"$g_bodybgcolor\" text=\"$g_bodytextcolor\">\n";
	print EVENTINDEX "$g_documentheader\n";
	print EVENTINDEX "<table width=\"100%\">\n";
	print EVENTINDEX "  <tr bgcolor=\"$g_titletablebgcolor\">\n";
	print EVENTINDEX "    <td>\n";
	print EVENTINDEX "      <h1>Event index</h1>\n";
	print EVENTINDEX "      <a name=\"searchbody\"></a>\n";
	print EVENTINDEX "    </td>\n";
	print EVENTINDEX "  </tr>\n";
	print EVENTINDEX "</table>\n";
	print EVENTINDEX "<table width=\"100%\">\n";

	@sortedEvents = sort @g_events;

	$i=0;
	while($i < $g_eventIdx)
	{
		($event,$short,$link) = split("<!>",$sortedEvents[$i]);
		print EVENTINDEX "<tr bgcolor=\"$g_bodytablebgcolor\">\n";
		print EVENTINDEX "  <td><a href=\"$link\">$event</a></td>\n";
		print EVENTINDEX "  <td>$short</td>\n";
		print EVENTINDEX "</tr>\n";
		$i++;
	}

	print EVENTINDEX "</table>\n";
	print EVENTINDEX "<hr><a href=\"index$g_fileextension\">Main index</a>\n";
	print EVENTINDEX "$g_documentfooter\n";
	print EVENTINDEX "</body>\n";
	print EVENTINDEX "</html>\n";

	close(EVENTINDEX);
} else {
	print "Can't open $g_directory/doc_events$g_fileextension for writing\n";
}



print "Writing document $g_directory/doc_widgets$g_fileextension\n";

if(open(WIDGETINDEX,">$g_directory/doc_widgets$g_fileextension"))
{

	print WIDGETINDEX "<html>\n";
	print WIDGETINDEX "<head>\n";
	print WIDGETINDEX "<title>Interface help index</title>\n";
	print WIDGETINDEX "</head>\n";
	print WIDGETINDEX "<body bgcolor=\"$g_bodybgcolor\" text=\"$g_bodytextcolor\">\n";
	print WIDGETINDEX "$g_documentheader\n";
	print WIDGETINDEX "<table width=\"100%\">\n";
	print WIDGETINDEX "  <tr bgcolor=\"$g_titletablebgcolor\">\n";
	print WIDGETINDEX "    <td>\n";
	print WIDGETINDEX "      <h1>Interface help index</h1>\n";
	print WIDGETINDEX "      <a name=\"searchbody\"></a>\n";
	print WIDGETINDEX "    </td>\n";
	print WIDGETINDEX "  </tr>\n";
	print WIDGETINDEX "</table>\n";
	print WIDGETINDEX "<table width=\"100%\">\n";

	@sortedWidgets = sort @g_widgets;

	$i=0;
	while($i < $g_widgetIdx)
	{
		($widget,$short,$link) = split("<!>",$sortedWidgets[$i]);
		print WIDGETINDEX "<tr bgcolor=\"$g_bodytablebgcolor\">\n";
		print WIDGETINDEX "  <td><a href=\"$link\">$widget</a></td>\n";
		print WIDGETINDEX "  <td>$short</td>\n";
		print WIDGETINDEX "</tr>\n";
		$i++;
	}

	print WIDGETINDEX "</table>\n";
	print WIDGETINDEX "<hr><a href=\"index$g_fileextension\">Main index</a>\n";
	print WIDGETINDEX "$g_documentfooter\n";
	print WIDGETINDEX "</body>\n";
	print WIDGETINDEX "</html>\n";

	close(WIDGETINDEX);
} else {
	print "Can't open $g_directory/doc_widgets$g_fileextension for writing\n";
}




print "Writing document $g_directory/doc_documents$g_fileextension\n";

if(open(DOCINDEX,">$g_directory/doc_documents$g_fileextension"))
{

	print DOCINDEX "<html>\n";
	print DOCINDEX "<head>\n";
	print DOCINDEX "<title>Miscelaneous documentation index</title>\n";
	print DOCINDEX "</head>\n";
	print DOCINDEX "<body bgcolor=\"$g_bodybgcolor\" text=\"$g_bodytextcolor\">\n";
	print DOCINDEX "$g_documentheader\n";
	print DOCINDEX "<table width=\"100%\">\n";
	print DOCINDEX "  <tr bgcolor=\"$g_titletablebgcolor\">\n";
	print DOCINDEX "    <td>\n";
	print DOCINDEX "      <h1>Miscelaneous documentation index</h1>\n";
	print DOCINDEX "      <a name=\"searchbody\"></a>\n";
	print DOCINDEX "    </td>\n";
	print DOCINDEX "  </tr>\n";
	print DOCINDEX "</table>\n";
	print DOCINDEX "<table width=\"100%\">\n";

	@sortedDocuments = sort @g_documents;

	$i=0;
	while($i < $g_documentIdx)
	{
		($cmd,$short,$link) = split("<!>",$sortedDocuments[$i]);
		print DOCINDEX "<tr bgcolor=\"$g_bodytablebgcolor\">\n";
		print DOCINDEX "  <td><a href=\"$link\">$cmd</a></td>\n";
		print DOCINDEX "  <td>$short</td>\n";
		print DOCINDEX "</tr>\n";
		$i++;
	}

	print DOCINDEX "</table>\n";
	print DOCINDEX "<hr><a href=\"index$g_fileextension\">Main index</a>\n";
	print DOCINDEX "$g_documentfooter\n";
	print DOCINDEX "</body>\n";
	print DOCINDEX "</html>\n";

	close(DOCINDEX);
} else {
	print "Can't open $g_directory/doc_documents$g_fileextension for writing\n";
}

print "Writing document $g_directory/doc_language$g_fileextension\n";

if(open(DOCINDEX,">$g_directory/doc_language$g_fileextension"))
{

	print DOCINDEX "<html>\n";
	print DOCINDEX "<head>\n";
	print DOCINDEX "<title>Language related documentation</title>\n";
	print DOCINDEX "</head>\n";
	print DOCINDEX "<body bgcolor=\"$g_bodybgcolor\" text=\"$g_bodytextcolor\">\n";
	print DOCINDEX "$g_documentheader\n";
	print DOCINDEX "<table width=\"100%\">\n";
	print DOCINDEX "  <tr bgcolor=\"$g_titletablebgcolor\">\n";
	print DOCINDEX "    <td>\n";
	print DOCINDEX "      <h1>Language related documentation</h1>\n";
	print DOCINDEX "      <a name=\"searchbody\"></a>\n";
	print DOCINDEX "    </td>\n";
	print DOCINDEX "  </tr>\n";
	print DOCINDEX "</table>\n";
	print DOCINDEX "<table width=\"100%\">\n";

	@sortedDocuments = sort @g_languages;

	$i=0;
	while($i < $g_languageIdx)
	{
		($cmd,$short,$link) = split("<!>",$sortedDocuments[$i]);
		print DOCINDEX "<tr bgcolor=\"$g_bodytablebgcolor\">\n";
		print DOCINDEX "  <td><a href=\"$link\">$cmd</a></td>\n";
		print DOCINDEX "  <td>$short</td>\n";
		print DOCINDEX "</tr>\n";
		$i++;
	}

	print DOCINDEX "</table>\n";
	print DOCINDEX "<hr><a href=\"index$g_fileextension\">Main index</a>\n";
	print DOCINDEX "$g_documentfooter\n";
	print DOCINDEX "</body>\n";
	print DOCINDEX "</html>\n";

	close(DOCINDEX);
} else {
	print "Can't open $g_directory/doc_language$g_fileextension for writing\n";
}


print "Writing document $g_directory/doc_classes$g_fileextension\n";

if(open(DOCINDEX,">$g_directory/doc_classes$g_fileextension"))
{

	print DOCINDEX "<html>\n";
	print DOCINDEX "<head>\n";
	print DOCINDEX "<title>Object class index</title>\n";
	print DOCINDEX "</head>\n";
	print DOCINDEX "<body bgcolor=\"$g_bodybgcolor\" text=\"$g_bodytextcolor\">\n";
	print DOCINDEX "$g_documentheader\n";
	print DOCINDEX "<table width=\"100%\">\n";
	print DOCINDEX "  <tr bgcolor=\"$g_titletablebgcolor\">\n";
	print DOCINDEX "    <td>\n";
	print DOCINDEX "      <h1>Object class index</h1>\n";
	print DOCINDEX "      <a name=\"searchbody\"></a>\n";
	print DOCINDEX "    </td>\n";
	print DOCINDEX "  </tr>\n";
	print DOCINDEX "</table>\n";
	print DOCINDEX "<table width=\"100%\">\n";

	@sortedDocuments = sort @g_classes;

	$i=0;
	while($i < $g_classIdx)
	{
		($cmd,$short,$link) = split("<!>",$sortedDocuments[$i]);
		print DOCINDEX "<tr bgcolor=\"$g_bodytablebgcolor\">\n";
		print DOCINDEX "  <td><a href=\"$link\">$cmd</a></td>\n";
		print DOCINDEX "  <td>$short</td>\n";
		print DOCINDEX "</tr>\n";
		$i++;
	}

	print DOCINDEX "</table>\n";
	print DOCINDEX "<hr><a href=\"index$g_fileextension\">Main index</a>\n";
	print DOCINDEX "$g_documentfooter\n";
	print DOCINDEX "</body>\n";
	print DOCINDEX "</html>\n";

	close(DOCINDEX);
} else {
	print "Can't open $g_directory/doc_classes$g_fileextension for writing\n";
}

print "Writing document $g_directory/doc_moduleindex$g_fileextension\n";

if(open(DOCINDEX,">$g_directory/doc_moduleindex$g_fileextension"))
{

	print DOCINDEX "<html>\n";
	print DOCINDEX "<head>\n";
	print DOCINDEX "<title>Module documentation index</title>\n";
	print DOCINDEX "</head>\n";
	print DOCINDEX "<body bgcolor=\"$g_bodybgcolor\" text=\"$g_bodytextcolor\">\n";
	print DOCINDEX "$g_documentheader\n";
	print DOCINDEX "<table width=\"100%\">\n";
	print DOCINDEX "  <tr bgcolor=\"$g_titletablebgcolor\">\n";
	print DOCINDEX "    <td>\n";
	print DOCINDEX "      <h1>Module documentation index</h1>\n";
	print DOCINDEX "      <a name=\"searchbody\"></a>\n";
	print DOCINDEX "    </td>\n";
	print DOCINDEX "  </tr>\n";
	print DOCINDEX "</table>\n";
	print DOCINDEX "<table width=\"100%\">\n";

	@sortedDocuments = sort @g_modules;

	$i=0;
	while($i < $g_moduleIdx)
	{
		($cmd,$short,$link) = split("<!>",$sortedDocuments[$i]);
		print DOCINDEX "<tr bgcolor=\"$g_bodytablebgcolor\">\n";
		print DOCINDEX "  <td><a href=\"$link\">$cmd</a></td>\n";
		print DOCINDEX "  <td>$short</td>\n";
		print DOCINDEX "</tr>\n";
		$i++;
	}

	print DOCINDEX "</table>\n";
	print DOCINDEX "<hr><a href=\"index$g_fileextension\">Main index</a>\n";
	print DOCINDEX "$g_documentfooter\n";
	print DOCINDEX "</body>\n";
	print DOCINDEX "</html>\n";

	close(DOCINDEX);
} else {
	print "Can't open $g_directory/doc_moduleindex$g_fileextension for writing\n";
}



print "Writing document $g_directory/doc_keyterms$g_fileextension\n";

if(open(DOCINDEX,">$g_directory/doc_keyterms$g_fileextension"))
{

	print DOCINDEX "<html>\n";
	print DOCINDEX "<head>\n";
	print DOCINDEX "<title>Index of terms and concepts</title>\n";
	print DOCINDEX "</head>\n";
	print DOCINDEX "<body bgcolor=\"$g_bodybgcolor\" text=\"$g_bodytextcolor\">\n";
	print DOCINDEX "$g_documentheader\n";
	print DOCINDEX "<table width=\"100%\">\n";
	print DOCINDEX "  <tr bgcolor=\"$g_titletablebgcolor\">\n";
	print DOCINDEX "    <td>\n";
	print DOCINDEX "      <h1>Index of terms and concepts</h1>\n";
	print DOCINDEX "      <a name=\"searchbody\"></a>\n";
	print DOCINDEX "    </td>\n";
	print DOCINDEX "  </tr>\n";
	print DOCINDEX "</table>\n";
	print DOCINDEX "<table width=\"100%\">\n";

	@sortedDocuments = sort @g_keyterms;

	$i=0;
	while($i < $g_keytermIdx)
	{
		($term,$link,$title) = split("<!>",$sortedDocuments[$i]);
		print DOCINDEX "<tr bgcolor=\"$g_bodytablebgcolor\">\n";
		print DOCINDEX "  <td><a href=\"$link\">$term</a></td>\n";
		print DOCINDEX "  <td>$title</td>\n";
		print DOCINDEX "</tr>\n";
		$i++;
	}

	print DOCINDEX "</table>\n";
	print DOCINDEX "<hr><a href=\"index$g_fileextension\">Main index</a>\n";
	print DOCINDEX "$g_documentfooter\n";
	print DOCINDEX "</body>\n";
	print DOCINDEX "</html>\n";

	close(DOCINDEX);
} else {
	print "Can't open $g_directory/doc_keyterms$g_fileextension for writing\n";
}



print "Writing document $g_directory/index$g_fileextension\n";

if(open(DOCINDEX,">$g_directory/index$g_fileextension"))
{
	print DOCINDEX "<html>\n";
	print DOCINDEX "<head>\n";
	print DOCINDEX "<title>Documentation index</title>\n";
	print DOCINDEX "</head>\n";
	print DOCINDEX "<body bgcolor=\"$g_bodybgcolor\" text=\"$g_bodytextcolor\">\n";
	print DOCINDEX "$g_documentheader\n";
	print DOCINDEX "<table width=\"100%\">\n";
	print DOCINDEX "  <tr bgcolor=\"$g_titletablebgcolor\">\n";
	print DOCINDEX "    <td>\n";
	print DOCINDEX "      <h1>Index</h1>\n";
	print DOCINDEX "      <a name=\"searchbody\"></a>\n";
	print DOCINDEX "    </td>\n";
	print DOCINDEX "  </tr>\n";
	print DOCINDEX "</table>\n";
	print DOCINDEX "<table width=\"100%\" bgcolor=\"$g_bodytablebgcolor\">\n";
	print DOCINDEX "<tr>\n";
	print DOCINDEX "  <td bgcolor=\"$g_subtitletablebgcolor\"><b>Fundamentals</b></td>\n";
	print DOCINDEX "</tr>\n";
	print DOCINDEX "<tr>\n";
	print DOCINDEX "  <td><a href=\"doc_ircintro$g_fileextension\">Introduction to IRC</a></td>\n";
	print DOCINDEX "</tr>\n";
	print DOCINDEX "<tr>\n";
	print DOCINDEX "  <td><a href=\"doc_kvircintro$g_fileextension\">Introduction to KVIrc</a></td>\n";
	print DOCINDEX "</tr>\n";
	print DOCINDEX "<tr>\n";
	print DOCINDEX "  <td bgcolor=\"$g_subtitletablebgcolor\"><b>Scripting language</b></td>\n";
	print DOCINDEX "</tr>\n";
	print DOCINDEX "<tr>\n";
	print DOCINDEX "  <td><a href=\"doc_language_overview$g_fileextension\">Language overview</a></td>\n";
	print DOCINDEX "</tr>\n";
	print DOCINDEX "<tr>\n";
	print DOCINDEX "  <td><a href=\"doc_commands$g_fileextension\">Command index</a></td>\n";
	print DOCINDEX "</tr>\n";
	print DOCINDEX "<tr>\n";
	print DOCINDEX "  <td><a href=\"doc_functions$g_fileextension\">Function index</a></td>\n";
	print DOCINDEX "</tr>\n";
	print DOCINDEX "<tr>\n";
	print DOCINDEX "  <td><a href=\"doc_events$g_fileextension\">Event index</a></td>\n";
	print DOCINDEX "</tr>\n";
	print DOCINDEX "<tr>\n";
	print DOCINDEX "  <td><a href=\"doc_classes$g_fileextension\">Object class index</a></td>\n";
	print DOCINDEX "</tr>\n";
	print DOCINDEX "<tr>\n";
	print DOCINDEX "  <td><a href=\"doc_language$g_fileextension\">Other language documents</a></td>\n";
	print DOCINDEX "</tr>\n";
	print DOCINDEX "<tr>\n";
	print DOCINDEX "  <td bgcolor=\"$g_subtitletablebgcolor\"><b>Other documentation</b></td>\n";
	print DOCINDEX "</tr>\n";
	print DOCINDEX "<tr>\n";
	print DOCINDEX "  <td><a href=\"doc_moduleindex$g_fileextension\">Modules documentation index</a></td>\n";
	print DOCINDEX "</tr>\n";
	print DOCINDEX "<tr>\n";
	print DOCINDEX "  <td><a href=\"doc_widgets$g_fileextension\">Interface help index</a></td>\n";
	print DOCINDEX "</tr>\n";
	print DOCINDEX "<tr>\n";
	print DOCINDEX "  <td><a href=\"doc_documents$g_fileextension\">Miscelaneous documentation index</a></td>\n";
	print DOCINDEX "</tr>\n";
	print DOCINDEX "<tr>\n";
	print DOCINDEX "  <td><a href=\"doc_keyterms$g_fileextension\">Index of terms and concepts</a></td>\n";
	print DOCINDEX "</tr>\n";
	print DOCINDEX "</table>\n";
	print DOCINDEX "$g_documentfooter\n";
	print DOCINDEX "</body>\n";
	print DOCINDEX "</html>\n";

	close(DOCINDEX);
} else {
	print "Can't open $g_directory/index$g_fileextension for writing\n";
}

