
#ifndef _KSOPTS_H_
#define _KSOPTS_H_

#include <qstringlist.h>
#include <qcolor.h>
#include <qfont.h>
#include <qrect.h>

#include "boundscheckingarray.h"

// Central place to hold KSirc's options
// and manage default values. The base classes
// are only used directly by the prefs dialog.
// The constructors initialize all options with default values.
class KSOGeneral
{
public:
    KSOGeneral();

    enum { SDI, MDI } displayMode;
    bool autoCreateWin : 1;
    bool nickCompletion : 1;
    bool displayTopic : 1;
    bool timeStamp : 1;
    bool beepNotify : 1;
    bool colorPicker : 1;
    bool autoRejoin : 1;
    bool beepOnMsg : 1;
    int windowLength;
    QString backgroundFile;
    bool logging;
};

class KSOStartup
{
public:
    KSOStartup();

    bool docked;
    QRect geometry;
    QString nick;
    QString altNick;
    QString realName;
    QStringList notifyList;
};

class KSOColors
{
public:
    static const unsigned int numColors = 16;

    KSOColors();

    QColor textColor;
    QColor infoColor;
    QColor channelColor;
    QColor errorColor;
    QColor ownNickColor;
    QColor nickForeground;
    QColor nickBackground;
    QColor backgroundColor;
    //QColor ircColors[numColors];
    BoundsCheckingArray<QColor, numColors> ircColors;

    QFont defaultFont;
    bool ksircColors : 1;
    bool mircColors : 1;
};

class KSORMBMenu
{
public:
    KSORMBMenu();
};

class KSOServChan
{
public:
    KSOServChan();
};

class KSOptions
    : public KSOGeneral,
      public KSOStartup,
      public KSOColors,
      public KSORMBMenu,
      public KSOServChan
{
public:
    KSOptions() { s_options = this; }

    void load( int sections = -1 );
    void save( int sections = -1 );

    static KSOptions *options() { return s_options; }

    enum { All = -1, General = 1, Startup = 2,
        Colors = 4, RMBMenu = 8, ServChan = 16 };

private:
    static KSOptions *s_options;
};

#define ksopts (KSOptions::options())

#endif
