#include <dcopclient.h>
#include <dcopref.h>
#include <kapplication.h>
#include <kcmdlineargs.h>
#include <kdebug.h>
#include <kurl.h>
#include <klocale.h>
#include <kaboutdata.h>
#include <qdir.h>

#include <stdlib.h>

#include "kviewshell.h"


static KCmdLineOptions options[] =
{
  { "+part",    I18N_NOOP("The part to use"), 0},
  { "unique", I18N_NOOP("Check if the file is loaded in another kviewshell. If it is, bring up the other kviewshell. Otherwise, load the file."), 0 },
  { "paper ", I18N_NOOP("Sets paper size (not implemented at the moment, only for compatibility with lyx)"), 0 },
  { "+file(s)", I18N_NOOP("Files to load"), 0 },
  { 0,0,0 }
};


static const char *description = I18N_NOOP("Generic framework for viewer applications.");


int main(int argc, char **argv)
{
  KAboutData about ("kviewshell", I18N_NOOP("KViewShell"), "0.2",
		    description, KAboutData::License_GPL,
		    "(C) 2000, Matthias Hoelzer-Kluepfel",
		    I18N_NOOP("Displays various document formats. "
		    "Based on original code from KGhostView."));
  about.addAuthor ("Matthias Hoelzer-Kluepfel", I18N_NOOP("Framework"),
		   "mhk@caldera.de");
  about.addAuthor ("David Sweet", 
		   I18N_NOOP("KGhostView Maintainer"),
		   "dsweet@kde.org",
		   "http://www.chaos.umd.edu/~dsweet");
  about.addAuthor ("Mark Donohoe",
		   I18N_NOOP("KGhostView Author"));
  about.addAuthor ("Markku Hihnala",
		   I18N_NOOP("Navigation widgets"));
  about.addAuthor ("David Faure",
		   I18N_NOOP("Basis for shell"));
  about.addAuthor ("Daniel Duley",
		   I18N_NOOP("Port to KParts"));
  about.addAuthor ("Espen Sand",
		   I18N_NOOP("Dialogs boxes"));
  about.addAuthor ("Stefan Kebekus", 
		   I18N_NOOP("DCOP-Interface, major improvements"),
		   "kebekus@kde.org");

  KCmdLineArgs::init(argc, argv, &about);
  KCmdLineArgs::addCmdLineOptions( options ); // Add my own options.
  KApplication app;
  KCmdLineArgs *args = KCmdLineArgs::parsedArgs();


  if (args->count() < 1) {
    args->usage();
    exit(-1);
  }

  if (args->isSet("unique")){
    // Find the fully qualified file name of the file we are
    // loading. Complain, if we are given a URL which does not point
    // to a local file.
    KURL url(args->url(1));
    
    if (args->url(1).isMalformed()) {
      kdError(4300) << QString(I18N_NOOP("The URL %1 is not well-formed.")).arg(args->arg(1)) << endl;
      return -1;
    }
    
    if (!args->url(1).isLocalFile()) {
      kdError(4300) << QString(I18N_NOOP("The URL %1 does not point to a local file. You can only specify local "
			     "files if you are using the '--unique' option.")).arg(args->arg(1)) << endl;
      return -1;
    }


    QString qualPath = QFileInfo(args->url(1).path()).absFilePath();

    app.dcopClient()->attach();
    app.dcopClient()->registerAs("unique-kviewshell");
    QCStringList apps = app.dcopClient()->registeredApplications();
    for ( QCStringList::Iterator it = apps.begin(); it != apps.end(); ++it ) {
      if ((*it).find("kviewshell") == 0) {
	QByteArray data, replyData;
	QCString replyType;
	QDataStream arg(data, IO_WriteOnly);
	bool result;
	arg << qualPath.stripWhiteSpace();
	if (!app.dcopClient()->call(*it, "kmultipage", "is_file_loaded(QString)", data, replyType, replyData))
	  kdError(4300) << "There was an error using DCOP." << endl;
	else {
	  QDataStream reply(replyData, IO_ReadOnly);
	  if (replyType == "bool") {
	    reply >> result;
	    if (result == true) {
	      if (app.dcopClient()->send(*it, "kmultipage", "jumpToReference(QString)", args->url(1).ref()) == true) {
		app.dcopClient()->detach();
		return 0;
	      }
	    }
	  } else
	    kdError(4300) << "The DCOP function 'doIt' returned an unexpected type of reply!";
	}
      }
    } 
  }
  app.dcopClient()->registerAs("kviewshell");
  KViewShell *shell = new KViewShell(args->arg(0), &about);
  

  if ( args->count() > 1 )
    shell->openURL( args->url(1) );

  shell->show();
  return app.exec();
}
