#ifndef BASE_BOARD_H
#define BASE_BOARD_H

#include <qtimer.h>
#include <qcanvas.h>

#include "gtetris.h"


class SequenceArray;
class BlockInfo;

class BaseBoard : public QCanvasView, public GenericTetris
{
 Q_OBJECT
 public:
    BaseBoard(bool graphic, QWidget *parent);
	virtual ~BaseBoard();
    void copy(const GenericTetris &);

	virtual void start();
	void pause();
	virtual void unpause();
	virtual void stop();
    bool isGameOver() const { return state==GameOver; }
    bool isPaused() const { return state==Paused; }

    virtual void settingsChanged();
	uint blockSize() const;
    BlockInfo *next() const { return _next; }

	int firstColumnBlock(uint column) const;

 protected slots:
    virtual bool timeout(); // return true if treated

 signals:
	void updatePieceConfigSignal();
    void removedUpdated(int removed);
    void scoreUpdated(int score);
	void blockSizeChanged();
    void gameOverSignal();

 protected:
	virtual bool beforeRemove(bool first);
    void _beforeRemove(bool first);
	enum AfterRemoveResult { Done, NeedAfterRemove, NeedRemoving };
	virtual AfterRemoveResult afterRemove(bool doAll, bool first);
    virtual void afterAfterRemove() { startTimer(); }
	virtual bool startTimer(); // return true if treated
    virtual bool toBeRemoved(const Coord &) const = 0;
    virtual void remove();
    virtual bool toFall(const Coord &) const = 0; // height>0 when called
    virtual bool doFall(bool doAll, bool first, bool lineByLine);
    void gameOver();

    uint drawCode(const Coord &) const;
    void computeNeighbours();
    void partialBlockFall(const Coord &src, const Coord &dest);

    // return the sizes of the groups (>=minSize)
    QMemArray<uint> findGroups(Matrix<int> &field, uint minSize,
							   bool exitAtFirstFound = false) const;
    // find group size and put -1 in the corresponding blocks (these blocks
    // should be 0 at start)
    uint findGroup(Matrix<int> &field, const Coord &) const;
    // set the size of the group in the blocks (these blocks should be -1
    // at start ie you should have called findGroup() before)
    void setGroup(Matrix<int> &field, const Coord &c, uint nb) const;

    void updateRemoved(uint newRemoved);
    void updateScore(uint newScore);

    virtual void showBoard(bool show);
    void showCanvas(QCanvas *c, bool show);

    enum BoardState { GameOver, Normal, Paused,
                      DropDown, BeforeGlue, AfterGlue, BeforeRemove,
					  AfterRemove, AfterGift };
    BoardState     state, _oldState;
	bool           _animations;
    QTimer         timer;
    SequenceArray *sequences;
	BlockInfo     *main, *_next;
    uint           loop;

 private:
	void _afterRemove(bool first);
	void updatePieceConfig() { emit updatePieceConfigSignal(); }

    void _findGroup(Matrix<int> &field, const Coord &c, uint &nb,
                    bool set) const;
    void blockInGroup(Matrix<int> &field, const Coord &c, uint value,
                      uint &nb, bool ser) const;
};

#endif
