/***************************************************************************
                          dcobject.h  -  description
                             -------------------
    begin                : Fri Feb 22 2002
    copyright            : (C) 2002 by Mathias Kster
    email                : mathen@ketelhot.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <time.h>
#include <dclib/cstring.h>
#include <dclib/cobject.h>
#include <dclib/clist.h>

#ifndef _DCOBJECT_H_
#define _DCOBJECT_H_

#define DC_USER_FILELIST "MyList.DcLst"

typedef enum eDCMessage {
	DC_MESSAGE_PARSE_ERROR=0,

	DC_MESSAGE_CONNECTION_STATE,	// internal con. state
	DC_MESSAGE_TRANSFER,		// transfer state

	DC_MESSAGE_UNKNOWN,

	// direct connect proto
	DC_MESSAGE_LOCK,
	DC_MESSAGE_HELLO,
	DC_MESSAGE_HUBNAME,
	DC_MESSAGE_CHAT,
	DC_MESSAGE_MYINFO,
	DC_MESSAGE_QUIT,
	DC_MESSAGE_NICKLIST,		// 10
	DC_MESSAGE_OPLIST,
	DC_MESSAGE_CONNECTTOME,
	DC_MESSAGE_KEY,
	DC_MESSAGE_PRIVATECHAT,
	DC_MESSAGE_SEARCH,
	DC_MESSAGE_REVCONNECTTOME,
	DC_MESSAGE_SEARCHRESULT,
	DC_MESSAGE_FORCEMOVE,
	DC_MESSAGE_MYNICK,		// connect to me
	DC_MESSAGE_DIRECTION,		// 20 connect to me
	DC_MESSAGE_MAXEDOUT,
	DC_MESSAGE_FILELENGTH,
	DC_MESSAGE_ERROR,		// file not found ...
	DC_MESSAGE_GET,
	DC_MESSAGE_GETLISTLEN,
	DC_MESSAGE_VALIDATEDENIDE,
	DC_MESSAGE_GETINFO,
	DC_MESSAGE_AGE,
	DC_MESSAGE_HUBISFULL,
	DC_MESSAGE_LISTLEN,		// 30
	DC_MESSAGE_SEND,
	DC_MESSAGE_PING,
	DC_MESSAGE_GETPASS,		// user need a password
	DC_MESSAGE_BADPASS,		// wrong password
	DC_MESSAGE_LOGEDIN,		// admin
	DC_MESSAGE_CANCEL,		// cancel a transfer
	DC_MESSAGE_CANCELED,		// the transfer is canceled

	// download manager types
	DC_MESSAGE_FILE_OBJECT,
	DC_MESSAGE_TRANSFER_OBJECT,
	DC_MESSAGE_FILELIST_OBJECT,
	DC_MESSAGE_SLOT_OBJECT,
	DC_MESSAGE_LOG,
	DC_MESSAGE_DM_INFO
};

/** transfer medium */
typedef enum eltMedium {
	eltNONE=0,
	eltBUFFER,
	eltFILE
};

/** direction */
typedef enum eDirection {
	edNONE=0,
	edUPLOAD,
	edDOWNLOAD
} eDirection;

/** socket state */
typedef enum eConnectionState {
	estNONE=0,
	estCONNECT,
	estCONNECTING,
	estCONNECTED,
	estDISCONNECTING,
	estDISCONNECTED,
	estSOCKETERROR,
	estCONNECTIONTIMEOUT,
	estTRANSFERHANDSHAKE,
	estTRANSFERDOWNLOAD,
	estTRANSFERUPLOAD
};

typedef enum eTransferFileState {
	etfsNONE=0,
	etfsTRANSFER,
	etfsERROR
};

typedef enum eTransferWaitState {
	etwsWAIT=0,
	etwsIDLE,
	etwsRUN,
	etwsPAUSE,
	etwsHUBOFFLINE,
	etwsUSEROFFLINE,
	etwsUSERBUSY,
	etwsSENDERROR
};

typedef enum eClientMode {
	ecmNone=0,
	ecmActive,
	ecmPassive
};

typedef enum eUserAwayMode {
	euamNORMAL,
	euamAWAY
};

class DLL_EXPORT CDCMessage : public CObject {
public:
	CDCMessage() {};
	virtual ~CDCMessage() {};
	eDCMessage eType;
};

class DLL_EXPORT CMessagePing : public CDCMessage {
public:
	CMessagePing() {};
	virtual ~CMessagePing() {};
};

class DLL_EXPORT CMessageGetInfo : public CDCMessage {
public:
	CMessageGetInfo() {};
	virtual ~CMessageGetInfo() {};
	CString sNick;
	CString sFrom;
};

class DLL_EXPORT CMessageConnectionState : public CDCMessage {
public:
	CMessageConnectionState() {};
	virtual ~CMessageConnectionState() {};
	eConnectionState eState;
	CString sMessage;
};

class DLL_EXPORT CMessageTransfer : public CDCMessage {
public:
	CMessageTransfer() {};
	virtual ~CMessageTransfer() {};
	int iMode;		/* 0: send 1:recv */
	ulonglong lTransfered;
	ulonglong lLength;
};

class DLL_EXPORT CMessageError : public CDCMessage {
public:
	CMessageError() {};
	virtual ~CMessageError() {};
	CString sError;
};

class DLL_EXPORT CMessageGet : public CDCMessage {
public:
	CMessageGet() {};
	virtual ~CMessageGet() {};
	CString sFilename;
	ulonglong lPos;
};

class DLL_EXPORT CMessageGetPass : public CDCMessage {
public:
	CMessageGetPass() {};
	virtual ~CMessageGetPass() {};
};

class DLL_EXPORT CMessageCancel : public CDCMessage {
public:
	CMessageCancel() {};
	virtual ~CMessageCancel() {};
};

class DLL_EXPORT CMessageCanceled : public CDCMessage {
public:
	CMessageCanceled() {};
	virtual ~CMessageCanceled() {};
};

class DLL_EXPORT CMessageBadPass : public CDCMessage {
public:
	CMessageBadPass() {};
	virtual ~CMessageBadPass() {};
};

class DLL_EXPORT CMessageLogedIn : public CDCMessage {
public:
	CMessageLogedIn() {};
	virtual ~CMessageLogedIn() {};
	CString sNick;
};

class DLL_EXPORT CMessageSend : public CDCMessage {
public:
	CMessageSend() {};
	virtual ~CMessageSend() {};
};

class DLL_EXPORT CMessageValidateDenide : public CDCMessage {
public:
	CMessageValidateDenide() {};
	virtual ~CMessageValidateDenide() {};
};

class DLL_EXPORT CMessageHubIsFull : public CDCMessage {
public:
	CMessageHubIsFull() {};
	virtual ~CMessageHubIsFull() {};
};

class DLL_EXPORT CMessageMaxedOut : public CDCMessage {
public:
	CMessageMaxedOut() {};
	virtual ~CMessageMaxedOut() {};
};

class DLL_EXPORT CMessageGetListLen : public CDCMessage {
public:
	CMessageGetListLen() {};
	virtual ~CMessageGetListLen() {};
};

class DLL_EXPORT CMessageLock : public CDCMessage {
public:
	CMessageLock() {};
	virtual ~CMessageLock() {};
	CString sPK;
	CString sData;
};

class DLL_EXPORT CMessageFileLength : public CDCMessage {
public:
	CMessageFileLength() {};
	virtual ~CMessageFileLength() {};
	ulonglong lFileLength;
};

class DLL_EXPORT CMessageDirection : public CDCMessage {
public:
	CMessageDirection() {};
	virtual ~CMessageDirection() {};
	eDirection Direction;
	int iLevel;
};

#ifdef WIN32
template class DLL_EXPORT CList<CString>;
#endif

class DLL_EXPORT CMessageNickList : public CDCMessage {
public:
	CMessageNickList() {};
	virtual ~CMessageNickList() {};
	CList<CString> NickList;
};

class DLL_EXPORT CMessageNick : public CDCMessage {
public:
	CMessageNick() {};
	virtual ~CMessageNick() {};
	CString sNick;
};

class DLL_EXPORT CMessageMyNick : public CDCMessage {
public:
	CMessageMyNick() {};
	virtual ~CMessageMyNick() {};
	CString sMyNick;
};

class DLL_EXPORT CMessageHello : public CDCMessage {
public:
	CMessageHello() {};
	virtual ~CMessageHello() {};
	CString sNick;
};

class DLL_EXPORT CMessageQuit : public CDCMessage {
public:
	CMessageQuit() {};
	virtual ~CMessageQuit() {};
	CString sNick;
};

class DLL_EXPORT CMessageChat : public CDCMessage {
public:
	CMessageChat() {};
	virtual ~CMessageChat() {};
	CString sNick;
	CString sMessage;
};

class DLL_EXPORT CMessageMyInfo : public CDCMessage {
public:
	CMessageMyInfo() {};
	virtual ~CMessageMyInfo() {};
	CString sNick;
	CString sComment;
	CString sUnknown;
	CString sSpeed;
	CString sEMail;
	ulonglong lShared;
	eUserAwayMode eAwayMode;
	bool bOperator;

	/** */
	CMessageMyInfo& operator = (const CMessageMyInfo& s)
	{
		sNick=s.sNick;
		sComment=s.sComment;
		sUnknown=s.sUnknown;
		sSpeed=s.sSpeed;
		sEMail=s.sEMail;
		lShared=s.lShared;
		eAwayMode=s.eAwayMode;
		bOperator=s.bOperator;
		return *this;
	};
};

class DLL_EXPORT CMessageConnectToMe : public CDCMessage {
public:
	CString sNick;
	CString sHost;
	int 	iPort;
};

class DLL_EXPORT CMessageRevConnectToMe : public CDCMessage {
public:
	CMessageRevConnectToMe() {};
	virtual ~CMessageRevConnectToMe() {};
	CString sNick;
	CString sRemoteNick;
};

class DLL_EXPORT CMessageSearch : public CDCMessage {
public:
	CMessageSearch() {};
	virtual ~CMessageSearch() {};
	CString sNick;
	CString sFlag;
	CString sString;
};

class DLL_EXPORT CMessageForceMove : public CDCMessage {
public:
	CMessageForceMove() {};
	virtual ~CMessageForceMove() {};
	CString sHost;
	int	iPort;
};

class DLL_EXPORT CMessageSearchResult : public CDCMessage {
public:
	CMessageSearchResult() {};
	virtual ~CMessageSearchResult() {};
	CString sNick;
	CString sFile;
	ulonglong lSize;
	unsigned int iFreeSlot;
	unsigned int iMaxSlot;
	CString sHubName;
	CString sHubHost;
};

class DLL_EXPORT CMessagePrivateChat : public CDCMessage {
public:
	CMessagePrivateChat() {};
	virtual ~CMessagePrivateChat() {};
	CString sNick;
	CString sFrom;
	CString sString;
};

class DLL_EXPORT CMessageHubName : public CDCMessage {
public:
	CMessageHubName() {};
	virtual ~CMessageHubName() {};
	CString sHubName;
};

// download manager object classes

class DLL_EXPORT CMessageDMFileObject : public CDCMessage {
public:
	CMessageDMFileObject() {};
	virtual ~CMessageDMFileObject() {};

	/** */
	CString sNick;
	/** */
	CString sHubName;
	/** */
	CString sHubHost;
	/** */
	time_t tTimeout;
	/** */
	eTransferWaitState eWaitState;
	/** */
	int iConnections;

	/** remote file */
	CString sRemoteFile;
	/** remote filename */
	CString sRemoteFileName;
	/** the local path for download dir */
	CString sLocalPath;
	/** the local filename */
	CString sLocalName;
	/** */
	eTransferFileState eFileState;
	/** file size */
	ulonglong lSize;
	/** current file position */
	ulonglong lStartPosition;
	/** current file position */
	ulonglong lCurrentPosition;
	/** file end position */
	ulonglong lEndPosition;

	/** */
	bool bRemoveFile;
};

class DLL_EXPORT CMessageDMTransferObject : public CDCMessage {
public:
	CMessageDMTransferObject() {};
	virtual ~CMessageDMTransferObject() {};

	/** */
	CString sNick;
	/** */
	CString sHost;
	/** */
	eConnectionState eState;

	/** remote file */
	CString sRemoteFile;
	/** remote filename */
	CString sRemoteFileName;
	/** file size */
	ulonglong lSize;
	/** current file position */
	ulonglong lStartPosition;
	/** current file position */
	ulonglong lCurrentPosition;
	/** file end position */
	ulonglong lEndPosition;
	/** file size */
	ulonglong lRate;
	/** */
	bool bRemoveTransfer;
};

class DLL_EXPORT CMessageDMFileListObject : public CDCMessage {
public:
	CMessageDMFileListObject() {};
	virtual ~CMessageDMFileListObject() {};

	/** */
	CString sNick;
	/** */
	CString sHubName;
	/** */
	CString sHubHost;
	/** */
	CString sUserFileList;
};

class DLL_EXPORT CMessageDMSlotObject : public CDCMessage {
public:
	CMessageDMSlotObject() {};
	virtual ~CMessageDMSlotObject() {};

	/** */
	CString sNick;
	/** */
	CString sHubName;
	/** */
	int iSlots;
	/** */
	bool bPermanent;
};

class DLL_EXPORT CMessageLog : public CDCMessage {
public:
	CMessageLog() {};
	virtual ~CMessageLog() {};

	/** */
	CString sMessage;
};

#endif
