/***************************************************************************
                           cxml.h  -  description
                             -------------------
    begin                : Sun Jun 9 2002
    copyright            : (C) 2002 by Mathias Kster
    email                : mathen@ketelhot.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef CXML_H
#define CXML_H

/**
  *@author Mathias Kster
  */

#include <dclib/dcos.h>
#include <dclib/cobject.h>
#include <dclib/cstring.h>

#include <libxml/xmlversion.h>
#if LIBXML_VERSION > 20406
#include <libxml/globals.h>
#endif
#include <libxml/xmlmemory.h>
#include <libxml/parser.h>
#include <libxml/tree.h>

class DLL_EXPORT CXml : public CObject {

public:
	/** */
	CXml();
	/** */
	virtual ~CXml();

	/** */
	xmlDocPtr doc();
	/** */
	CString name( xmlNodePtr node );
	/** */
	CString content( xmlNodePtr node );

	/** */
	bool NewDoc();
	/** */
	bool ParseFile( CString name );

	/** */
	CString ToUTF8( CString s );
	/** */
	CString FromUtf8( CString s );

private:
	/** */
	void FreeDoc();
	/** */
	CString xml_UTF8Toisolat1( CString s );
	/** */
	CString xml_isolat1ToUTF8( CString s );

	/** */
	xmlDocPtr pDoc;
};

inline xmlDocPtr CXml::doc()
{ return pDoc; };
inline CString CXml::name( xmlNodePtr node )
{ return ((char*)node->name); };

#endif
