/***************************************************************************
                           cxml.cpp  -  description
                             -------------------
    begin                : Wed May 15 2002
    copyright            : (C) 2002 by Mathias Kster
    email                : mathen@ketelhot.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <stdlib.h>

#include "cxml.h"

/** */
CXml::CXml()
{
	pDoc = 0;
}

/** */
CXml::~CXml()
{
	FreeDoc();
}

/** */
void CXml::FreeDoc()
{
	if (pDoc)
	{
		xmlFreeDoc(pDoc);
		pDoc = 0;
	}
}

/** */
bool CXml::NewDoc()
{
	FreeDoc();

	if ( (pDoc = xmlNewDoc((const xmlChar*)"1.0")) == 0 )
	{
		return FALSE;
	}

	return TRUE;
}

/** */
bool CXml::ParseFile( CString name )
{
	FreeDoc();

	if ( (pDoc = xmlParseFile(name.Data())) == 0 )
	{
		return FALSE;
	}

	return TRUE;
}

/** */
CString CXml::content( xmlNodePtr node )
{
	xmlChar *c;
	CString s = "";

	if ( (c = xmlNodeGetContent(node)) != 0 )
	{
		s = FromUtf8((char*)c);
		xmlFree(c);
	}

	return s;
}

/** */
CString CXml::xml_UTF8Toisolat1( CString s )
{
	CString r = "";
	unsigned char *b;
	int inlen,outlen,res;

	if ( s == "" )
	{
		return "";
	}

	inlen  = s.Length();
	outlen = inlen*4;

	b = (unsigned char*) calloc(1,outlen);

	res = UTF8Toisolat1( b, &outlen, (unsigned char*)s.Data(), &inlen );

	if ( res == -2 )
		printf("UTF8Toisolat1 transcoding fail: '%s'\n",s.Data());
	else if ( res == -1 )
		printf("UTF8Toisolat1 fail: '%s'\n",s.Data());
	else if ( res == 0 )
		r = (char*)b;

	free(b);

	return r;
}

/** */
CString CXml::xml_isolat1ToUTF8( CString s )
{
	CString r = "";
	unsigned char *b;
	int inlen,outlen,res;

	if ( s == "" )
	{
		return "";
	}

	inlen  = s.Length();
	outlen = inlen*4;

	b = (unsigned char*) calloc(1,outlen);

	res = isolat1ToUTF8( b, &outlen, (unsigned char*)s.Data(), &inlen );

	if ( res == -1 )
		printf("isolat1ToUTF8 fail: '%s'\n",s.Data());
	else if ( res == 0 )
		r = (char*)b;

	free(b);

	return r;
}

/** */
CString CXml::ToUTF8( CString s )
{
	CString c = "";
	xmlChar * xc;

	if ( s != "" )
	{
		c = xml_isolat1ToUTF8(s);
		xc = xmlEncodeEntitiesReentrant(NULL, (xmlChar*) c.Data() );
		c = (char*)xc;
		if(xc)
		{
			xmlFree(xc);
		}
	}

	return c;
}

/** */
CString CXml::FromUtf8( CString s )
{
	CString c = "";

	if ( s != "" )
	{
		c = xml_UTF8Toisolat1(s);
	}

	return c;
}
