/***************************************************************************
                          ctransfer.h  -  description
                             -------------------
    begin                : Fri Feb 22 2002
    copyright            : (C) 2002 by Mathias Kster
    email                : mathen@ketelhot.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef CTRANSFER_H
#define CTRANSFER_H

#include <dclib/dcos.h>
#include <dclib/cstring.h>
#include <dclib/cconnection.h>
#include <dclib/cbytearray.h>

/**
  *@author Mathias Kster
  */

class CTransfer;

typedef int (*TransferCallBack) ( CTransfer * Transfer, CObject * Object );

class DLL_EXPORT CTransfer : public CConnection {
public:
	CTransfer();
	~CTransfer();

	/** callback function */
	virtual int DC_CallBack( CObject * ) { return -1; };
	/** */
	virtual void DataAvailable( const char * buffer, int len );
	/** */
	virtual void DataSend();
	/** */
	virtual void DataTimeout();
	/** */
	virtual void ConnectionState( eConnectionState state );

	/** */
	void SetCallBackFunction( TransferCallBack callbackfunction );

	/** */
	int StartDownload( CString dstfile, ulonglong startposition, ulonglong currentposition, ulonglong endposition, ulonglong size, CString srcfile );
	/** */
	int StartUpload( CString dstfile, ulonglong length, ulonglong pos, CString srcfile );

	/** */
	int CallBack_SendObject( CObject * Object );
	/** */
	int CallBack_SendError( CString msg );

	/** */
	ulonglong GetTransferrate();
	/** */
	ulonglong GetBytesForTransferrate( ulonglong rate );

	/** */
	int HandleMessage( char * c, int len );

	/** */
	CString GetDstFilename() const;
	/** */
	void SetDstFilename( CString filename );
	/** */
	void SetSrcFilename( CString filename );
	/** */
	CString GetDstNick() const;
	/** */
	CString GetHubHost() const;
	/** */
	void SetHubHost( CString hubhost );
	/** */
	CString GetHubName() const;
	/** */
	void SetHubName( CString hubname );
	/** */
	eltMedium GetMedium() const;
	/** */
	void SetMedium( eltMedium medium );
	/** */
	long GetBuffer( CByteArray *ba );
	/** */
	void SetBuffer( CByteArray *ba );

	/** */
	eDirection GetSrcDirection() const;
	/** */
	void SetSrcDirection( eDirection direction );
	/** */
	eDirection GetDstDirection() const;
	/** */
	void SetDstDirection( eDirection direction );

	/** */
	int GetLevel() const;
	/** */
	eConnectionState GetMode() const;
	/** */
	void SetMode( eConnectionState mode );
	/** */
	ulonglong GetStartPosition() const;
	/** */
	void SetStartPosition( ulonglong pos );
	/** */
	ulonglong GetCurrentPosition() const;
	/** */
	void SetCurrentPosition( ulonglong pos );
	/** */
	ulonglong GetEndPosition() const;
	/** */
	void SetEndPosition( ulonglong pos );
	/** */
	ulonglong GetLength() const;
	/** */
	void SetLength( ulonglong length );
	/** */
	ulonglong GetTransfered() const;
	/** */
	void InitStartTime();
	/** */
	void SetNick( CString nick );
	/** */
	void SetRate( ulonglong rate );
	/** */
	ulonglong GetRate() const;
	/** */
	bool IsIdle() const;

	/** */
	void SetDone( int i );
	/** */
	int GetDone() const;
	/** */
	time_t GetStartTime() const;
	/** */
	void SetStartTime( time_t t );

private:
	/** */
	CString sNick;
	/** */
	CString sBuffer;
	/** */
	ulonglong lLength;
	/** */
	ulonglong lTransfered;
	/** */
	ulonglong lStartPosition;
	/** */
	ulonglong lCurrentPosition;
	/** */
	ulonglong lEndPosition;
	/** */
	long lBufferPos;
	/** */
	ulonglong lRate;
	/** */
	eConnectionState eMode;
	/** */
	eltMedium eMedium;
	/** */
	bool bIdle;
	/** */
	int fd;
	/** */
	CByteArray * pByteArray;
	/** local filename */
	CString sSrcFilename;
	/** remote filename */
	CString sDstFilename;
	/** local direction */
	eDirection eSrcDirection;
	/** remote direction */
	eDirection eDstDirection;
	/** remote nick */
	CString sDstNick;
	/** local level */
	int iLevel;
	/** identifier hubname */
	CString sHubName;
	/** identifier hubhost:hubport */
	CString sHubHost;
	/** */
	time_t starttime;
	/** */
	time_t currtime;
	/** */
	CThread TransferThread;
	/** callback function */
	TransferCallBack CallBack;
	/** */
	int iDone;
};

/** */
inline CString CTransfer::GetDstFilename() const
{ return sDstFilename; }
/** */
inline void CTransfer::SetDstFilename( CString filename )
{ TransferThread.Lock(); sDstFilename=filename; TransferThread.UnLock(); }
/** */
inline void CTransfer::SetSrcFilename( CString filename )
{ TransferThread.Lock(); sSrcFilename=filename; TransferThread.UnLock(); }
/** */
inline CString CTransfer::GetDstNick() const
{ return sDstNick; }
/** */
inline CString CTransfer::GetHubHost() const
{ return sHubHost; }
/** */
inline void CTransfer::SetHubHost( CString hubhost )
{ TransferThread.Lock(); sHubHost=hubhost; TransferThread.UnLock(); }
/** */
inline CString CTransfer::GetHubName() const
{ return sHubName; }
/** */
inline void CTransfer::SetHubName( CString hubname )
{ TransferThread.Lock(); sHubName=hubname; TransferThread.UnLock(); }
/** */
inline void CTransfer::SetMedium( eltMedium medium )
{ TransferThread.Lock(); eMedium=medium; TransferThread.UnLock(); }
/** */
inline eltMedium CTransfer::GetMedium() const
{ return eMedium; }
/** */
inline void CTransfer::SetBuffer( CByteArray *ba )
{ TransferThread.Lock(); pByteArray->Append(ba->Data(),ba->Size()); TransferThread.UnLock(); }
/** */
inline long CTransfer::GetBuffer( CByteArray *ba )
{ TransferThread.Lock(); long i; ba->Append(pByteArray->Data(),pByteArray->Size()); i = pByteArray->Size(); TransferThread.UnLock(); return i; }
/** */
inline eDirection CTransfer::GetSrcDirection() const
{ return eSrcDirection; }
/** */
inline void CTransfer::SetSrcDirection( eDirection direction )
{ TransferThread.Lock(); eSrcDirection = direction; TransferThread.UnLock(); }
/** */
inline eDirection CTransfer::GetDstDirection() const
{ return eDstDirection; }
/** */
inline void CTransfer::SetDstDirection( eDirection direction )
{ TransferThread.Lock(); eDstDirection = direction; TransferThread.UnLock(); }
/** */
inline int CTransfer::GetLevel() const
{ return iLevel; }
/** */
inline eConnectionState CTransfer::GetMode() const
{ return eMode; }
/** */
inline void CTransfer::SetMode( eConnectionState mode )
{ TransferThread.Lock(); eMode = mode; TransferThread.UnLock(); }
/** */
inline ulonglong CTransfer::GetStartPosition() const
{ return lStartPosition; }
/** */
inline void CTransfer::SetStartPosition( ulonglong pos )
{ TransferThread.Lock(); lStartPosition=pos; TransferThread.UnLock(); }
/** */
inline ulonglong CTransfer::GetCurrentPosition() const
{ return lCurrentPosition; }
/** */
inline void CTransfer::SetCurrentPosition( ulonglong pos )
{ TransferThread.Lock(); lCurrentPosition=pos; TransferThread.UnLock(); }
/** */
inline ulonglong CTransfer::GetEndPosition() const
{ return lEndPosition; }
/** */
inline void CTransfer::SetEndPosition( ulonglong pos )
{ TransferThread.Lock(); lEndPosition=pos; TransferThread.UnLock(); }
/** */
inline ulonglong CTransfer::GetLength() const
{ return lLength; }
/** */
inline void CTransfer::SetLength( ulonglong length )
{ TransferThread.Lock(); lLength = length; TransferThread.UnLock(); }
/** */
inline ulonglong CTransfer::GetTransfered() const
{ return lTransfered; }
/** */
inline void CTransfer::InitStartTime()
{  TransferThread.Lock(); starttime = time(0);  TransferThread.UnLock(); }
/** */
inline void CTransfer::SetNick(CString nick)
{ TransferThread.Lock(); sNick=nick; TransferThread.UnLock(); }
/** */
inline void CTransfer::SetRate( ulonglong rate )
{ TransferThread.Lock(); lRate=rate; TransferThread.UnLock(); }
/** */
inline ulonglong CTransfer::GetRate() const
{ return lRate; }
/** */
inline bool CTransfer::IsIdle() const
{ return bIdle; }
/** */
inline void CTransfer::SetCallBackFunction( TransferCallBack callbackfunction )
{ TransferThread.Lock(); CallBack = callbackfunction; TransferThread.UnLock(); }
/** */
inline void CTransfer::SetDone( int i )
{ TransferThread.Lock(); iDone = i; TransferThread.UnLock(); }
/** */
inline int CTransfer::GetDone() const
{ return iDone; }
/** */
inline time_t CTransfer::GetStartTime() const
{ return starttime; }
/** */
inline void CTransfer::SetStartTime( time_t t )
{ TransferThread.Lock(); starttime = t; TransferThread.UnLock(); }

#endif
