/***************************************************************************
                          ctransfer.cpp  -  description
                             -------------------
    begin                : Fri Feb 22 2002
    copyright            : (C) 2002 by Mathias Kster
    email                : mathen@ketelhot.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <stdio.h>
#include <fcntl.h>
#include <stdlib.h>
#include <errno.h>

#ifndef WIN32
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <unistd.h>
#else
#include <io.h>
#endif

#include <dclib/dcobject.h>
#include <dclib/cmessagehandler.h>
#include <dclib/cencrypt.h>
#include <dclib/che3.h>
#include <dclib/cdir.h>

#include "ctransfer.h"

#define SEND_FILE_BUFFER_SIZE	0xffff

CTransfer::CTransfer()
{
	CallBack = 0;

	fd = -1;

	pByteArray = new CByteArray();

	sNick         = "";
	sSrcFilename  = "";
	sDstFilename  = "";
	eMedium       = eltNONE;
	eSrcDirection = edNONE;
	eDstDirection = edNONE;
	eMode         = estNONE;
	lStartPosition = 0;
	lCurrentPosition = 0;
	lEndPosition = 0;
	iLevel        = 0;
	sBuffer = "";
	starttime     = 0;
	currtime      = 0;

	lLength = 0;
	lTransfered = 0;
	lRate = 0;

	sDstNick = "";

	sHubName = "";
	sHubHost = "";

	bIdle = 1;
	iDone = 0;
}

CTransfer::~CTransfer()
{
	TransferThread.Lock();

	if (pByteArray)
	{
		delete pByteArray;
	}

	if ( fd != -1 )
	{
#ifdef WIN32
		_close(fd);
#else
		close(fd);
#endif
	}

	TransferThread.UnLock();
}

/** */
int CTransfer::CallBack_SendObject( CObject * Object )
{
	int err;

	if ( CallBack != 0 )
	{
		err = CallBack( this, Object );
	}
	else
	{
		err = DC_CallBack( Object );
	}

	if ( err == -1 )
	{
		printf("CallBack failed (state)...\n");
		delete Object;
	}

	return err;
}

/** */
int CTransfer::CallBack_SendError( CString msg )
{
	CMessageError * Object = new CMessageError();
	Object->eType  = DC_MESSAGE_ERROR;
	Object->sError = msg;

	return CallBack_SendObject(Object);
}

/** */
ulonglong CTransfer::GetTransferrate()
{
	TransferThread.Lock();

	ulonglong r;

	if ( (starttime == 0) || (lTransfered == 0))
	{
		TransferThread.UnLock();
		return 0;
	}

	if ( (eMode == estTRANSFERDOWNLOAD) ||
	     (eMode == estTRANSFERUPLOAD)  )
	{
		currtime = time(0);
	}

	r = lTransfered;

	if ( (currtime-starttime) > 0 )
	{
		r /= (currtime-starttime);
	}

	TransferThread.UnLock();

	return r;
}

/** */
ulonglong CTransfer::GetBytesForTransferrate( ulonglong rate )
{
	TransferThread.Lock();

	ulonglong r = 0;

	if ( starttime == 0 )
	{
		TransferThread.UnLock();
		return 0;
	}

	if ( (eMode == estTRANSFERDOWNLOAD) ||
	     (eMode == estTRANSFERUPLOAD) )
	{
		currtime = time(0);
	}

	if ( (currtime-starttime) > 0 )
	{
		r = lTransfered/(currtime-starttime);

		if ( r < rate )
		{
			r = (rate-r)*(currtime-starttime);
		}
		else
		{
			r = 0;
		}
	}

	TransferThread.UnLock();

	return r;
}

/** */
void CTransfer::ConnectionState( eConnectionState state )
{
	CMessageConnectionState *Object;

	Object = new CMessageConnectionState();

	Object->eType = DC_MESSAGE_CONNECTION_STATE;

	Object->eState   = state;
	Object->sMessage = GetSocketError();

	if ( state == estCONNECTED )
	{
		eMode = estTRANSFERHANDSHAKE;

		SendMyNick( sNick );
	}
	else if ( state == estDISCONNECTED )
	{
		eMode = estNONE;
	}

	CallBack_SendObject(Object);
}

/** */
int CTransfer::StartDownload( CString dstfile, ulonglong startposition, ulonglong currentposition, ulonglong endposition, ulonglong size, CString srcfile )
{
	if ( (srcfile == "" ) && (eMedium != eltBUFFER) )
	{
		printf("ctransfer: wrong mode %d\n",eMedium);//fflush(stdout);
		return -1;
	}

	if ( bIdle == 0 )
	{
		printf("ctransfer: other transfer is running\n");//fflush(stdout);
		return -1;
	}

	if ( eMode == estTRANSFERUPLOAD )
	{
		printf("ctransfer: wrong transfer mode\n");//fflush(stdout);
		return -1;
	}

	SetMode(estTRANSFERDOWNLOAD);
	SetStartPosition(startposition);
	SetCurrentPosition(currentposition);
	SetEndPosition(endposition);
	SetLength(size);
	SetDstFilename(dstfile);
	SetSrcFilename(srcfile);
	lTransfered = 0;

	/** set starttime */
	InitStartTime();

	SendGet( GetDstFilename(), GetCurrentPosition()+1 );

	return 0;
}

/** */
int CTransfer::StartUpload( CString dstfile, ulonglong length, ulonglong pos, CString srcfile )
{
	if ( (srcfile == "" ) && (eMedium != eltBUFFER) )
	{
		printf("ctransfer: wrong mode %d\n",eMedium);//fflush(stdout);
		return -1;
	}

	if ( bIdle == 0 )
	{
		printf("ctransfer: other transfer is running\n");//fflush(stdout);
		return -1;
	}

	if ( eMode == estTRANSFERDOWNLOAD )
	{
		printf("ctransfer: wrong transfer mode\n");//fflush(stdout);
		return -1;
	}

	SetMode(estTRANSFERUPLOAD);

	SetStartPosition(pos);
	SetCurrentPosition(pos);
	SetEndPosition(length);
	SetLength(length);
	SetDstFilename(dstfile);
	SetSrcFilename(srcfile);

	/** set starttime */
	InitStartTime();

	SendFileLength(length);

	return 0;
}

/** */
int CTransfer::HandleMessage( char * c, int )
{
	int p=0;
	eDCMessage type;
	CObject * Object;
	CDir dir;

	CMessageHandler MessageHandler;

	CString s;

	s = c;

	while( (type=MessageHandler.Parse(s,p,Object=0)) != DC_MESSAGE_PARSE_ERROR )
	{
		//printf("transfer: handle message: %d\n",type);
		//fflush(stdout);

		switch (type)
		{
			case DC_MESSAGE_FILELENGTH:
			case DC_MESSAGE_LISTLEN:
			{
				bool b = FALSE;
				CMessageFileLength * msg = (CMessageFileLength*)Object;

				if ( eMode != estTRANSFERDOWNLOAD || (bIdle == 0) )
				{
					printf("Warning: not in downloadmode/idle FILELENGTH/LISTLEN\n");//fflush(stdout);

					delete Object;
					Object = 0;
				}
				else
				{
					lTransfered = 0;

					// update endposition
					if ( (lEndPosition == lLength) || (lEndPosition == 0) )
						lEndPosition = msg->lFileLength;

					lLength = msg->lFileLength;

					if ( eMedium == eltFILE )
					{
						if ( fd != -1 )
						{
#ifdef WIN32
							_close(fd);
#else
							close(fd);
#endif
						}
#ifdef WIN32
						fd = _open(sSrcFilename.Data(),_O_BINARY|_O_CREAT|_O_WRONLY);
#else
						dir.SetPath("");

						if ( dir.IsFile(sSrcFilename) == FALSE )
						{
							fd = open(sSrcFilename.Data(),O_CREAT|O_WRONLY|S_IRWXU|S_IRGRP|S_IROTH);

							if ( fd == -1 )
							{
								CallBack_SendError(strerror(errno));
								perror("file open");
							}
							else if ( chmod(sSrcFilename.Data(),S_IRWXU|S_IRGRP|S_IROTH) != 0 )
							{
								CallBack_SendError(strerror(errno));
								perror("file chmod");
								close(fd);
								fd = -1;
							}
						}
						else
						{
							fd = open(sSrcFilename.Data(),O_WRONLY);

							if ( fd == -1 )
							{
								CallBack_SendError(strerror(errno));
								perror("file open");
							}
						}
#endif
						if ( fd != -1 )
						{
							// jump to the startposition
							if ( lseek(fd,(long)lCurrentPosition,SEEK_SET) != lCurrentPosition )
							{
								CallBack_SendError(strerror(errno));
								perror("file seek");
#ifdef WIN32
								_close(fd);
#else
								close(fd);
#endif
								fd = -1;
							}
							else
							{
								b = TRUE;
							}
						}
					}
					else
					{
						pByteArray->SetSize(0);
						b = TRUE;
					}

					// start transfer
					if ( b == TRUE )
					{
						bIdle = 0;

						SendSend();
					}
				}

				break;
			}

			case DC_MESSAGE_SEND:
			{
				if ( (eMode != estTRANSFERUPLOAD) || (bIdle == 0) )
				{
					printf("Warning: not in uploadmode/idle SEND [%d/%d]\n",eMode,bIdle);//fflush(stdout);

					delete Object;
					Object = 0;
				}
				else
				{
					lTransfered = 0;

					// init filehandle
					if ( eMedium == eltFILE )
					{
						lBufferPos = SEND_FILE_BUFFER_SIZE;

						pByteArray->SetSize(SEND_FILE_BUFFER_SIZE);

						if ( fd != -1 )
						{
#ifdef WIN32
							_close(fd);
#else
							close(fd);
#endif
						}
#ifdef WIN32
						fd = _open(sSrcFilename.Data(),_O_RDONLY);
#else
						fd = open(sSrcFilename.Data(),O_RDONLY);
#endif
						if ( fd == -1 )
						{
							CallBack_SendError(strerror(errno));
							perror("file open");
						}
						else
						{
							if ( lseek(fd,(long)lCurrentPosition,SEEK_SET) != lCurrentPosition )
							{
								CallBack_SendError(strerror(errno));
								perror("file seek");
#ifdef WIN32
								_close(fd);
#else
								close(fd);
#endif
								fd = -1;
							}
						}
					}

					// start transfer
					bIdle = 0;

					printf("start upload ...\n");//fflush(stdout);
				}

				break;
			}

			case DC_MESSAGE_ERROR:
			{
				break;
			}

			case DC_MESSAGE_DIRECTION:
			{
				CMessageDirection * msg = (CMessageDirection*)Object;

				if ( eDstDirection != edNONE )
				{
					// remote will change the direction ... hoho ;-)
					if ( eDstDirection != msg->Direction )
					{
						Disconnect(TRUE);
						printf("Warning: remote will change his direction (hack) ...\n");//fflush(stdout);
						delete Object;
						Object = 0;
					}
				}
				else
				{
					eDstDirection = msg->Direction;
				}

				break;
			}

			case DC_MESSAGE_MYNICK:
			{
				CMessageMyNick * msg = (CMessageMyNick*)Object;

				sDstNick = msg->sMyNick;

				iLevel = rand()%9999;

				break;
			}

			case DC_MESSAGE_LOCK:
			{
				CString sAnswer;
				CEncrypt Encrypt;
				CMessageLock * msg = (CMessageLock*)Object;

				if(!msg)
					break;

				Encrypt.Encrypt(msg->sData,sAnswer);

				SendKey( sAnswer );

				break;
			}

			case DC_MESSAGE_KEY:
			{
				break;
			}

			case DC_MESSAGE_MAXEDOUT:
			{
				break;
			}

			case DC_MESSAGE_CANCEL:
			{
				if ( (eMode == estTRANSFERUPLOAD) && (bIdle == 0) )
				{
					if ( eMedium == eltFILE )
					{
#ifdef WIN32
						_close(fd);
#else
						close(fd);
#endif
						fd = -1;
					}

					// free buffer
					pByteArray->SetSize(0);

					// stop transfer
					bIdle = 1;
				}
				else
				{
					printf("Warning: Cancel msg not in uploadmode/idle SEND [%d/%d]\n",eMode,bIdle);

					delete Object;
					Object = 0;
				}

				break;
			}

			default:
			{
				//printf("ctransfer: unknown message %d\n",type);
				//fflush(stdout);
			}
		}

		if (Object)
		{
			((CDCMessage*)Object)->eType = type;

			CallBack_SendObject(Object);
		}
	}

	return 0;
}

/** */
void CTransfer::DataSend()
{
	int l;
	ulonglong len;
	ulonglong sendbyte;
	ulonglong freebuf;
	CMessageTransfer *Object;

	if ( (eMode == estTRANSFERUPLOAD) && (bIdle == 0) )
	{
		sendbyte = 0;

		// check send rate
		if ( lRate != 0 )
		{
			sendbyte = GetBytesForTransferrate(lRate);

			if ( sendbyte == 0 )
			{
				return;
			}
		}

		freebuf = GetFreeSendBufferSize();

		if ( freebuf == 0 )
		{
			return;
		}

		if ( eMedium == eltFILE )
		{
			len = lLength - lCurrentPosition;

			// load data from filehandle and send ...
			if ( lBufferPos == SEND_FILE_BUFFER_SIZE )
			{
				if ( len > SEND_FILE_BUFFER_SIZE )
					len = SEND_FILE_BUFFER_SIZE;

				lBufferPos = read( fd, pByteArray->Data(), (long)len );

				if ( lBufferPos == -1 )
				{
					CallBack_SendError(strerror(errno));
					perror("CTransfer::DataSend() read error !\n");
					return;
				}
				else if ( lBufferPos == 0 )
				{
					perror("CTransfer::DataSend() no data read !\n");
					return;
				}
				else if ( len > (ulonglong)lBufferPos )
				{
					perror("CTransfer::DataSend() wrong length calculation !\n");
					len = lBufferPos;
				}

				lBufferPos = 0;
			}

			// limit to transferrate
			if ( sendbyte != 0 )
			{
				if ( len > sendbyte )
				{
					len = sendbyte;
				}
			}

			// limit to free socket sendbuffer
			if ( len > freebuf )
			{
				len = freebuf;
			}

			// limit to sendbuffer
			if ( len > (ulonglong)(SEND_FILE_BUFFER_SIZE-lBufferPos) )
			{
				len = SEND_FILE_BUFFER_SIZE-lBufferPos;
			}

			l = CSocket::Write((const char*)pByteArray->Data()+lBufferPos,(long)len,0,100);

			if ( l > 0 )
			{
				lTransfered += l;
				lCurrentPosition += l;
				lBufferPos += l;
			}
			else if ( l == -1 )
			{
				perror("CTransfer::DataSend() write error !\n");
			}

		}
		else if ( eMedium == eltBUFFER )
		{
			// send data from byte array ...
			// todo calc speed etc.
			len = lLength - lCurrentPosition;

			// limit transferrate
			if ( sendbyte != 0 )
			{
				if ( len > sendbyte )
				{
					len = sendbyte;
				}
			}

			// limit to free socket sendbuffer
			if ( len > freebuf )
			{
				len = freebuf;
			}

			l = CSocket::Write((const char*)pByteArray->Data()+lTransfered,(long)len,0,100);

			if ( l > 0 )
			{
				lTransfered += l;
				lCurrentPosition += l;
			}
			else if ( l == -1 )
			{
				perror("CTransfer::DataSend() write error !\n");
			}
		}
		else
		{
			// error ... wrong medium
		}

		if ( lLength == lCurrentPosition )
		{
			if ( eMedium == eltFILE )
			{
#ifdef WIN32
					_close(fd);
#else
					close(fd);
#endif
				fd = -1;
			}

			// free buffer
			pByteArray->SetSize(0);

			// stop transfer
			bIdle = 1;
		}

		Object = new CMessageTransfer();
		Object->eType = DC_MESSAGE_TRANSFER;
		Object->iMode = 1;
		Object->lTransfered = lCurrentPosition;
		Object->lLength = lLength;

		CallBack_SendObject(Object);
	}
}

/** */
void CTransfer::DataTimeout()
{
	printf("CTransfer: data timeout ...\n");fflush(stdout);

	timeConnection = time(0);

	if ( (eMode == estTRANSFERDOWNLOAD) && (bIdle == 0) )
	{
		// send send ...
		SendSend();
	}
	else if ( bIdle == 1 )
	{
		// send string ...
		SendString("|");
	}
}

/** */
void CTransfer::DataAvailable( const char * buffer, int len )
{
	CMessageTransfer *Object;
	CString s;
	CString serr="";
	bool berr=FALSE;
	int i,i1;
	ulonglong l;

	if ( (eMode == estTRANSFERDOWNLOAD) && (bIdle == 0) )
	{
		// check endposition
		if ( (len+lCurrentPosition) > lEndPosition )
		{
			l = (int)lEndPosition-lCurrentPosition;
		}
		else
		{
			l = len;
		}

		i1=0;

		if ( eMedium == eltFILE )
		{
			if ( (fd != -1) && (l>0) )
			{
				while(i1!=l)
				{
#ifdef WIN32
					i = _write(fd,buffer,(long)l);
#else
					i = write(fd,buffer,l);
#endif
					if (i!=-1)
					{
						i1+=i;
					}
					else
					{
						berr = TRUE;
						serr = strerror(errno);
						break;
					}
				}
			}
			else
			{
				// TODO: error message
			}
		}
		else if ( eMedium == eltBUFFER )
		{
			pByteArray->Append((const unsigned char*)buffer,(long)l);
			i1+=l;
		}
		else
		{
			// error ...
		}

		if ( i1 > 0 )
		{
			lTransfered+=i1;
			lCurrentPosition+=i1;
		}

//		printf("%ld %ld %ld %ld\n",lLength,lPos,lTransfered,lBufferPos);fflush(stdout);

		if ( lEndPosition == lCurrentPosition )
		{
			bIdle = 1;

			if ( eMedium == eltFILE )
			{
#ifdef WIN32
					_close(fd);
#else
					close(fd);
#endif

				fd = -1;
			}
			else if ( sDstFilename == "MyList.DcLst" )
			{
				// decompress filelist
				CHE3 *he3=0;
				CString * s=0;

				he3 = new CHE3();
				s = he3->decode_he3_data(pByteArray);
				delete he3;
				pByteArray->SetSize(0);

				if ( s != 0 )
				{
					pByteArray->Append( (unsigned char*)s->Data(), s->Length() );
					delete s;
				}
			}
		}

		Object = new CMessageTransfer();
		Object->eType = DC_MESSAGE_TRANSFER;
		Object->iMode = 1;
		Object->lTransfered = lCurrentPosition;
		Object->lLength = lLength;

		CallBack_SendObject(Object);

		// send the error message to the appl
		if ( berr == TRUE )
		{
			CallBack_SendError(serr);

			// disconnect on error
			Disconnect(TRUE);
		}

		/** update currtime */
		currtime = time(0);

		return;
	}

	i = i1 = 0;

	s = buffer;

/*
	// simple workaround for the wrong cancel message from nmdc
	if ( s == "$Canceled" )
		s += "|";
	else if ( s == "$Cancel" )
		s += "|";
*/
	s = sBuffer + s;

	// search '|'
	while((i=s.Find('|',i))>=0)
	{
		i++;
		i1 = i;
	}

	if ( i1 > 0 )
	{
		sBuffer = s.Mid(0,i1);
		if ( HandleMessage( (char*)sBuffer.Data(), sBuffer.Length() ) == -1 )
		{
		}
	}

	if (i1==s.Length())
	{
		sBuffer = "";
	}
	else
	{
		sBuffer = s.Mid( i1, s.Length()-i1 );
	}
}
