/***************************************************************************
                          cthread.cpp  -  description
                             -------------------
    begin                : Sun Sep 30 2001
    copyright            : (C) 2001 by Mathias Kster
    email                : mathen@ketelhot.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <stdio.h>
#include "cthread.h"

CThread::CThread()
{
	pthread_mutex_init(&mutex,NULL);

	iStop = 1;
	iRun  = 0;
}

CThread::~CThread()
{
	void * status;

	iStop = 1;

	if ( iRun == 1 )
	{
		pthread_join(thread,&status);
	}
	pthread_mutex_destroy(&mutex);
}

/** */
int CThread::Start()
{
	if (iRun==1)
		return -1;

	if (iStop==0)
		return -1;

	iStop = 0;

	return pthread_create(&thread, 0, MainThread, this);
}

/** */
int CThread::Stop( bool bHard )
{
	void * status;

	if (iRun==0)
		return -1;

	if (iStop==1)
		return -1;

	iStop=1;

	if ( bHard )
		pthread_join(thread,&status);

	return 0;
}

void * CThread::MainThread( void * object )
{
	int oldState = 0;
	CThread * pThread;

	pThread = (CThread*)object;

	pThread->iRun = 1;

	pthread_setcancelstate(PTHREAD_CANCEL_DISABLE,&oldState);

	for(;;)
	{
		if ( pThread->iStop == 1 )
		{
			break;
		}
		else
		{
			pThread->Thread(0);
		}
	}

	pThread->iRun = 0;

	pthread_exit(0);
	return (void*)1;
}
