/***************************************************************************
                          cstringlist.cpp  -  description
                             -------------------
    begin                : Sat Jun 1 2002
    copyright            : (C) 2002 by Mathias Kster
    email                : mathen@ketelhot.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#define HASH_TABLE_SIZE 0x100

#include "cstringlist.h"

CStringList::CStringList( int depth )
{
	iDepth    = depth;
	size      = 0;
	pos_cache = 0;
	obj_cache = 0;

	pList = 0;
	pStringList = 0;

	if ( iDepth == 0 )
	{
		pList = new CList<CStringListObject>*[HASH_TABLE_SIZE];
		memset(pList, 0, HASH_TABLE_SIZE*sizeof(CList<CStringListObject>*));
	}
	else
	{
		pStringList = new CStringList*[HASH_TABLE_SIZE];
		memset(pStringList, 0, HASH_TABLE_SIZE*sizeof(CStringList*));
	}
}

CStringList::~CStringList()
{
	int i;
	for(i=0;i<HASH_TABLE_SIZE;i++)
	{
		if ( iDepth == 0 )
		{
			if(pList[i])
				delete pList[i];
		}
		else
		{
			if(pStringList[i])
				delete pStringList[i];
		}
	}

	if ( iDepth == 0 )
		delete [] pList;
	else
		delete [] pStringList;
}

/** */
int CStringList::Add( CString s, CObject * object )
{
	int i = s.GetHash();

	if ( iDepth == 0 )
	{
		CStringListObject * o = new CStringListObject();

		o->s = s;
		o->pObject = object;

		if ( pList[i] == 0 )
			pList[i] = new CList<CStringListObject>();

		pList[i]->Add(o);
	}
	else
	{
		if ( pStringList[i] == 0 )
			pStringList[i] = new CStringList(iDepth-1);
		pStringList[i]->Add(s,object);
	}

	size++;

	pos_cache = 0;
	obj_cache = 0;

	return 0;
}

/** */
int CStringList::Del( CString s )
{
	CStringListObject * o = 0;
	int i = s.GetHash();

	if ( iDepth == 0 )
	{
		if ( pList[i] == 0 )
			return -1;

		while( (o=pList[i]->Next(o)) != 0 )
		{
			if ( s == o->s )
				break;
		}

		if (!o)
			return -1;

		pList[i]->Remove(o);

		if ( o->pObject )
			delete o->pObject;

		delete o;

		if (pList[i]->Count() == 0 )
		{
			delete pList[i];
			pList[i]=0;
		}
	}
	else
	{
		if ( pStringList[i] == 0 )
			return -1;
		pStringList[i]->Del(s);
	}

	size--;

	pos_cache = 0;
	obj_cache = 0;

	return 0;
}

/** */
int CStringList::Get( CString s, CObject *& object )
{
	CStringListObject * o = 0;
	int i = s.GetHash();

	if ( iDepth == 0 )
	{
		if ( !pList[i] )
			return -1;

		while( (o=pList[i]->Next(o)) != 0 )
		{
			if ( s == o->s )
				break;
		}

		if (!o)
			return -1;

		object = o->pObject;
	}
	else
	{
		if ( !pStringList[i] )
			return -1;

		return pStringList[i]->Get(s,object);
	}

	return 0;
}

/** */
void CStringList::Clear()
{
	int i;

	for(i=0;i<HASH_TABLE_SIZE;i++)
	{
		if ( iDepth == 0 )
		{
			if(pList[i])
				delete pList[i];
			pList[i]=0;
		}
		else
		{
			if(pStringList[i])
				delete pStringList[i];
			pStringList[i]=0;
		}
	}
}

/** */
int CStringList::Next( CObject *& object )
{
	int i;
	long l;
	CStringListObject * obj=0;

	if ( object == 0 )
	{
		pos_cache = 0;
		obj_cache = 0;
	}

	for(i=0,l=0;i<HASH_TABLE_SIZE;i++)
	{
		if ( iDepth == 0 )
		{
			if(!pList[i])
				continue;

			if ( (l<=pos_cache) && ((l+pList[i]->Count())>pos_cache) )
			{
				if(l==pos_cache)
					obj_cache=0;
				obj = pList[i]->Next(obj_cache);
				object = obj->pObject;
				pos_cache++;
				obj_cache = obj;
				break;
			}

			l+=pList[i]->Count();
		}
		else
		{
			if(!pStringList[i])
				continue;

			if ( (l<=pos_cache) && ((l+pStringList[i]->Count())>pos_cache) )
			{
				if(l==pos_cache)
					object=0;
				pos_cache++;
				return pStringList[i]->Next(object);
			}

			l+=pStringList[i]->Count();
		}
	}
	
	return (obj!=0);
}
