/***************************************************************************
                          cstring.h  -  description
                             -------------------
    begin                : Fri Sep 21 2001
    copyright            : (C) 2001 by Mathias Kster
    email                : mathen@ketelhot.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef CSTRING_H
#define CSTRING_H


/**
  *@author Mathias Kster
  */

#include <string.h>
#include <dclib/dcos.h>
#include <dclib/cobject.h>

class DLL_EXPORT CString : public CObject {
private:
	char * pBuffer;
	/** */
	void set( const char * s, long length=-1 );
	/** */
	void add( const char * s );
public: 
	CString();
	CString(const char *s);
	CString(const char s);
	CString(const CString&s);
	virtual ~CString();

	/** */
	char * Data() const { return pBuffer; };
	/** */
	void Clear();
	/** */
	long Length() const { if(!pBuffer) return 0; return size; };
	/** */
	long Find( const char c, long index = -1 ) const;
	/** */
	long Find( const char * c, long index = -1 ) const;
	/** */
	long FindCase( char * c, long index = -1 ) const;
	/** */
	long FindRev( char c, long index = -1 ) const;
	/** */
	void Append( const char c );
	/** */
	void Append( const CString& s );
	/** */
	CString Mid( long i, long length ) const;
	/** */
	CString Left( long length ) const { return Mid(0,length); };
	/** */
	bool IsEmpty() const;
	/** */
	CString& Set( char * s, long l ){ set(s,l); return *this; };
	/** */
	CString RightJustify( long width, char fill = ' ', bool truncate = FALSE );
	
	/** */
	CString Replace( const char c, CString s );

	/** */
	CString setNum( const int i );
	/** */
	CString setNum( const unsigned int i );
	/** */
	CString setNum( const long i );
	/** */
	CString setNum( const ulonglong i );
	/** */
	ulonglong asULL();
	/** */
	unsigned int asUINT();
	/** */
	int asINT();
	/** */
	long asLONG();

	/** */
	unsigned char GetHash( long value = 0 );

	/** */
	CString& operator = (const char* s) { set(s); return *this; };
	/** */
	CString& operator = (const CString& s) { CString tmp(s);set(tmp.pBuffer); return *this; };

	/** */
	CString& operator +=(const char s) { Append(s); return *this; };
	/** */
	CString& operator +=(const char* s) { Append(s); return *this; };
	/** */
	CString& operator +=(const CString& s) { Append(s); return *this; };

private:
	/** */
	long size;
	/** */
	long bsize;

};

/** */
DLL_EXPORT bool operator == ( const CString& s1, const CString& s2 );
/** */
DLL_EXPORT bool operator == ( const char * s1, const CString& s2 );
/** */
DLL_EXPORT bool operator == ( CString& s1, const char * s2 );
/** */
DLL_EXPORT bool operator != ( const CString& s1, const CString& s2 );
/** */
DLL_EXPORT bool operator != ( const char * s1, const CString& s2 );
/** */
DLL_EXPORT bool operator != ( const CString& s1, const char * s2 );
/** */
DLL_EXPORT inline CString operator + (const CString& s1, const CString& s2) { CString tmp(s1); tmp.Append(s2); return tmp; }
/** */
DLL_EXPORT inline CString operator + (const char* s1, const CString& s2) { CString tmp(s1); return (tmp+s2); }

#endif
