/***************************************************************************
                          cstring.cpp  -  description
                             -------------------
    begin                : Fri Sep 21 2001
    copyright            : (C) 2001 by Mathias Kster
    email                : mathen@ketelhot.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <stdio.h>
#include <string.h>
#include <errno.h>
#include <stdlib.h>

#include "cstring.h"

CString::CString()
{
	pBuffer = 0;
	size    = 0;
	bsize   = 0;
}

CString::CString(const char *s)
{
	pBuffer = 0;
	size    = 0;
	bsize   = 0;
	set(s);
}

CString::CString(const char s)
{
	pBuffer = 0;
	size    = 0;
	bsize   = 0;
	set(&s,1);
}

CString::CString(const CString&s)
{
	pBuffer = 0;
	size    = 0;
	bsize   = 0;
	set(s.pBuffer);
}

CString::~CString()
{
	if (pBuffer)
	{
		free(pBuffer);
		pBuffer = 0;
	}
}

/** */
void CString::Clear()
{
	if (pBuffer)
	{
		free(pBuffer);
		pBuffer = 0;
	}

	size  = 0;
	bsize = 0;
}

/** */
unsigned char CString::GetHash( long value )
{
	if ( (!IsEmpty()) && (value < Length()) )
		return ((unsigned char)(pBuffer[value]&0xFF));
	else
		return 0;
}

/** */
long CString::Find( const char c, long index ) const
{
	long i=0;

	if ( IsEmpty() )
		return -1;

	if (index>-1)
		i=index;

	if (i>size)
		return -1;


	for(;i<size;i++)
	{
		if (pBuffer[i]==c)
			return i;
	}

	return -1;
}

/** */
long CString::Find( const char * c, long index ) const
{
	long i;
	long len;
	long ret;

	if ( IsEmpty() )
		return -1;

	if ( !c )
		return -1;

	if ( index == -1 )
		index = 0;

	len = strlen(c);

	if ( (index+len) > size )
		return -1;

	for(i=index,ret=-1;i<=(size-len);i++)
	{
		if ( strncmp(c,pBuffer+i,len) == 0 )
		{
			ret = i-index;
			break;
		}
	}

	return ret;
}

/** */
long CString::FindCase( char * c, long index ) const
{
	long i;
	long len;
	long ret;

	if ( IsEmpty() )
		return -1;

	if ( !c )
		return -1;

	if ( index == -1 )
		index = 0;

	len = strlen(c);

	if ( (index+len) > size )
		return -1;

	for(i=index,ret=-1;i<=(size-len);i++)
	{
#ifdef WIN32
		if ( strnicmp(c,pBuffer+i,len) == 0 )
#else
		if ( strncasecmp(c,pBuffer+i,len) == 0 )
#endif
		{
			ret = i-index;
			break;
		}
	}

	return ret;
}

/** */
long CString::FindRev( char c, long index ) const
{
	long i;

	if ( IsEmpty() )
		return -1;

	if (index>-1)
		i=index;
	else
		i=size;

	if (i>size)
		return -1;


	for(;i>=0;i--)
	{
		if (pBuffer[i]==c)
			return i;
	}

	return -1;
}

/** */
CString CString::Mid( long i, long length ) const
{
	CString tmp;

	tmp="";

	if ( IsEmpty() )
		return tmp;

	if(i>size)
		return tmp;

	if((i+length)>size)
		return tmp;

	tmp.set(pBuffer+i,length);

	return tmp;
}

/** */
void CString::Append( const CString& s )
{
	CString tmp(s);

	add(tmp.Data());
}

/** */
void CString::Append( const char c )
{
	char d[2];

	d[0]=c;
	d[1]=0;
	add(d);
}

/** */
bool CString::IsEmpty() const
{
	return ( (size==0) || (pBuffer==0) );
}

/** */
CString CString::setNum( const int i )
{
	char c[50];

#ifdef WIN32
	_snprintf(c,50,"%d",i);
#else
	snprintf(c,50,"%d",i);
#endif

	return CString(c);
}

/** */
CString CString::setNum( const unsigned int i )
{
	char c[50];

#ifdef WIN32
	_snprintf(c,50,"%u",i);
#else
	snprintf(c,50,"%u",i);
#endif

	return CString(c);
}

/** */
CString CString::setNum( const long i )
{
	char c[50];

#ifdef WIN32
	_snprintf(c,50,"%ld",i);
#else
	snprintf(c,50,"%ld",i);
#endif

	return CString(c);
}

/** */
CString CString::setNum( const ulonglong i )
{
	char c[50];

#ifdef WIN32	
	_snprintf(c,50,"%Lu",i);
#else
	snprintf(c,50,"%Lu",i);
#endif

	return CString(c);
}

/** */
ulonglong CString::asULL()
{
	ulonglong res;
	char *tail;

	if ( IsEmpty() )
	{
		return 0;
	}

#ifdef WIN32
	res=strtoul(Data(),&tail,10);
#else
	res=strtoull(Data(),&tail,10);
#endif

	if((res==0)&&(errno!=0)) {}

	return res;
}

/** */
unsigned int CString::asUINT()
{
	return (unsigned int)asLONG();
}

/** */
int CString::asINT()
{
	return (int)asLONG();
}

/** */
long CString::asLONG()
{
	unsigned int res;
	char *tail;

	if ( IsEmpty() )
	{
		return 0;
	}

	res=strtol(Data(),&tail,10);

	if((res==0)&&(errno!=0)) {}

	return res;
}

/** */
CString CString::Replace( const char c, CString s )
{
	long i,t;
	CString tmp = "";

	t = i = 0;
	while ( (i=Find(c,i)) != -1 )
	{
		tmp += Mid(t,i-t);
		tmp += s;
		i++;
		t = i;
	}

	tmp += Mid(t,Length()-t);

	return tmp;
}

/** */
void CString::set( const char * s, long length )
{
	long l;

	Clear();

	if (!s)
		return;

	if(length==-1)
		l = strlen(s);
	else
		l = length;

	if (l<=0)
		return;

	pBuffer = (char*) calloc(1,l+1); //new char[l+1];

	memcpy(pBuffer,s,l);

	size=l;
	bsize=l+1;
}

/** */
void CString::add( const char * s )
{
//	size_t si;
	long l,len;

	if (!s)
		return;

	l = strlen(s);

	if (l<=0)
		return;

	if(!pBuffer)
	{
		set(s);
	}
	else
	{
		len = size;

		if((l+len+1)>bsize)
		{
			bsize+=10000+1+l;
			pBuffer = (char*) realloc(pBuffer,bsize);
		}

		memset(pBuffer+len+l,0,1);
		memcpy(pBuffer+len,s,l);
		size+=l;
	}
}

/** */
bool operator == ( const CString& s1, const CString& s2 )
{
	CString t1(s1);
	CString t2(s2);

	if ( (t1.Data() == 0) && (t2.Data() == 0) )
		return 1;



	if ( t1.Length() != t2.Length()  )
		return 0;

	if ( memcmp( t1.Data(), t2.Data(), t1.Length() ) != 0 )
		return 0;

	return 1;
}

/** */
CString CString::RightJustify( long width, char fill , bool /*truncate*/ )
{
	CString s="";

	while( (s.Length()+Length()) < width )
		s+=fill;

	return(s+*this);
}

/** */
bool operator == ( const char * s1, const CString& s2 )
{
	return ( CString(s1) == s2 );
}

/** */
bool operator == ( CString& s1, const char * s2 )
{
	return ( CString(s2) == s1 );
}

/** */
bool operator != ( const CString& s1, const CString& s2 )
{
	return (!(s1 == s2));
}

/** */
bool operator != ( const char * s1, const CString& s2 )
{
	return (!(CString(s1) == s2));
}

/** */
bool operator != ( const CString& s1, const char * s2 )
{
	return (!(CString(s2) == s1));
}
