/***************************************************************************
                          cservermanager.h  -  description
                             -------------------
    begin                : Don Mai 16 2002
    copyright            : (C) 2002 by Mathias Kster
    email                : mathen@ketelhot.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef CSERVERMANAGER_H
#define CSERVERMANAGER_H

#include <dclib/dcos.h>
#include <dclib/cobject.h>
#include <dclib/clist.h>
#include <dclib/cstring.h>
#include <dclib/cthread.h>
#include <dclib/cclient.h>

/**
  *@author Mathias Kster
  */

class DLL_EXPORT CServerManager : public CObject {
public:
	/** */
	CServerManager();
	/** */
	virtual ~CServerManager();

	/** send message to all connected servers */
	int SendStringToConnectedServers( CString s );
	/** send myinfo to all connected servers */
	int SendMyInfoToConnectedServers();
	/** 0: send -1: user offline -2: hub not ready (connection state/handshake) -3: hub offline -4: send error */
	int SendConnectionRequest( CString nick, CString hubname );
	/** */
	bool IsUserOnline( CString nick, CString hubname );
	/** */
	bool IsHubOnline( CString hubname );

protected:
	/** */
	CThread Thread;
	/** client list */
	CList<CClient> *pClientList;
};

#endif
