/***************************************************************************
                          cservermanager.cpp  -  description
                             -------------------
    begin                : Don Mai 16 2002
    copyright            : (C) 2002 by Mathias Kster
    email                : mathen@ketelhot.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <dclib/cclient.h>
#include <dclib/cconfig.h>
#include <dclib/cdownloadmanager.h>

#include "cservermanager.h"

extern CConfig * pDCLibConfig;
extern CDownloadManager * pDownloadManager;

CServerManager * pDCLibServerManager = 0;

/** */
CServerManager::CServerManager()
{
	pDCLibServerManager = this;

	pClientList = new CList<CClient>();
}

/** */
CServerManager::~CServerManager()
{
	Thread.Lock();

	delete pClientList;
	pClientList = 0;

	Thread.UnLock();
}

/** send message to all connected servers */
int CServerManager::SendStringToConnectedServers( CString s )
{
	Thread.Lock();

	CClient* client;
	int i = 0;

	if ( s != "" )
	{
		client = 0;
		while( (client=pClientList->Next(client)) != 0 )
		{
			if ( client->IsHandshake() == TRUE )
			{
				continue;
			}

			client->SendString(s);
			i++;
		}
	}

	Thread.UnLock();

	return i;
}

/** send myinfo to all connected servers */
int CServerManager::SendMyInfoToConnectedServers()
{
	Thread.Lock();

	CClient* client;
	int i = 0;

	client = 0;
	while( (client=pClientList->Next(client)) != 0 )
	{
		if ( client->IsHandshake() == TRUE )
		{
			continue;
		}

		// update internal values
		client->SetNick(pDCLibConfig->GetNick());
		client->SetComment(pDCLibConfig->GetDescription());
		client->SetConnectionType(pDCLibConfig->GetSpeed());
		client->SetEMail(pDCLibConfig->GetEMail());
		client->SetShareSize(CString().setNum(pDCLibConfig->GetShareSize()));
		client->SetAwayMode(pDCLibConfig->GetAwayMode());

		client->SendMyInfo( pDCLibConfig->GetNick(),
				pDCLibConfig->GetDescription(),
				pDCLibConfig->GetSpeed(),
				pDCLibConfig->GetAwayMode(),
				pDCLibConfig->GetEMail(),
				CString().setNum(pDCLibConfig->GetShareSize()));

		i++;
	}

	Thread.UnLock();

	return i;
}

/** */
int CServerManager::SendConnectionRequest( CString nick, CString hubname )
{
	Thread.Lock();

	CClient* client;
	int res = -3;

	client = 0;
	while( (client=pClientList->Next(client)) != 0 )
	{
		if ( client->GetHubName() == hubname )
		{
			if ( client->IsHandshake() == TRUE )
			{
				res = -2;
				break;
			}

			if ( client->IsUserOnline( nick ) == FALSE )
			{
				res = -1;
				break;
			}

			if ( client->GetMode() == ecmPassive )
			{
				// send connection request
				if ( client->SendRevConnectToMe( client->GetNick(), nick ) == 0 )
				{
					res = 0;
				}
				else
				{
					res = -4;
				}
			}
			else if ( client->GetMode() == ecmActive )
			{
				CString s = pDCLibConfig->GetTCPHostString();

				if ( s != "" )
				{
					// send connection request
					pDownloadManager->AddTransfer( nick, "", hubname, client->GetHost() );

					if ( client->SendConnectToMe( nick, s ) == 0 )
					{
						res = 0;
					}
					else
					{
						res = -4;
					}
				}
			}

			break;
		}
	}

	Thread.UnLock();

	return res;
}

/** */
bool CServerManager::IsUserOnline( CString nick, CString hubname )
{
	Thread.Lock();

	CClient* client;
	bool res = FALSE;

	client = 0;
	while( (client=pClientList->Next(client)) != 0 )
	{
		if ( client->GetHubName() == hubname )
		{
			if ( client->IsHandshake() == TRUE )
			{
				break;
			}
			else if ( client->IsUserOnline( nick ) == FALSE )
			{
				break;
			}
			else
			{
				res = TRUE;
				break;
			}
		}
	}

	Thread.UnLock();

	return res;
}

/** */
bool CServerManager::IsHubOnline( CString hubname )
{
	Thread.Lock();

	CClient* client;
	bool res = FALSE;

	client = 0;
	while( (client=pClientList->Next(client)) != 0 )
	{
		if ( client->GetHubName() == hubname )
		{
			if ( client->IsHandshake() == FALSE )
			{
				res = TRUE;
			}

			break;
		}
	}

	Thread.UnLock();

	return res;
}

