/***************************************************************************
                          cmessagehandler.cpp  -  description
                             -------------------
    begin                : Sun Sep 30 2001
    copyright            : (C) 2001 by Mathias Kster
    email                : mathen@ketelhot.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <stdio.h>
#include <stdlib.h>

#include <dclib/cencrypt.h>
#include <dclib/dcobject.h>

#include "cmessagehandler.h"

// parsed messages
#define DC_S_MESSAGE_CHAT 		"<"
#define DC_S_MESSAGE_SEARCH 		"$Search "
#define DC_S_MESSAGE_MYINFO 		"$MyINFO "
#define DC_S_MESSAGE_HELLO 		"$Hello "
#define DC_S_MESSAGE_QUIT 		"$Quit "
#define DC_S_MESSAGE_NICKLIST 		"$NickList "
#define DC_S_MESSAGE_OPLIST 		"$OpList "
#define DC_S_MESSAGE_CONNECTTOME 	"$ConnectToMe "
#define DC_S_MESSAGE_KEY 		"$Key "
#define DC_S_MESSAGE_HUBNAME 		"$HubName "
#define DC_S_MESSAGE_LOCK 		"$Lock "
#define DC_S_MESSAGE_TO 		"$To: "
#define DC_S_MESSAGE_FORCEMOVE 		"$ForceMove "
#define DC_S_MESSAGE_REVCONNECTTOME 	"$RevConnectToMe "
#define DC_S_MESSAGE_SR 		"$SR "
#define DC_S_MESSAGE_MYNICK 		"$MyNick "
#define DC_S_MESSAGE_DIRECTION 		"$Direction "
#define DC_S_MESSAGE_MAXEDOUT 		"$MaxedOut"	// no free slots
#define DC_S_MESSAGE_FILELENGTH 	"$FileLength "	// recv. file
#define DC_S_MESSAGE_GET 		"$Get "
#define DC_S_MESSAGE_ERROR		"$Error "
#define DC_S_MESSAGE_GETLISTLEN		"$GetListLen"
#define DC_S_MESSAGE_VALIDATEDENIDE 	"$ValidateDenide"  //hub login failed ...
#define DC_S_MESSAGE_HUBISFULL 		"$HubIsFull"
#define DC_S_MESSAGE_LISTLEN		"$ListLen "
#define DC_S_MESSAGE_SEND		"$Send"
#define DC_S_MESSAGE_GETINFO 		"$GetINFO "
#define DC_S_MESSAGE_PING 		"$Ping"
#define DC_S_MESSAGE_GETPASS 		"$GetPass"
#define DC_S_MESSAGE_BADPASS 		"$BadPass"
#define DC_S_MESSAGE_LOGEDIN		"$LogedIn "
#define DC_S_MESSAGE_CANCEL		"$Cancel"
#define DC_S_MESSAGE_CANCELED		"$Canceled"

// todo: parse
#define DC_S_MESSAGE_AGE 		"age="		// age=NEWS ... ???
#define DC_S_EXTRA_DCPLUS		"$DCPlus "

CMessageHandler::CMessageHandler()
{
}

CMessageHandler::~CMessageHandler()
{
}

int CMessageHandler::GetContent( const CString sMessage, const CString sData, CString & sContent )
{
	if ( sMessage == sData.Left(sMessage.Length()))
	{
		sContent = sData.Mid(sMessage.Length(),sData.Length()-sMessage.Length());
		return 0;
	}

	return -1;		
}

/** */
eDCMessage CMessageHandler::Parse( const CString sMessage, int & pointer, CObject *& Object  )
{
	CString t;
	CString sContent;
	int old_index,index;

	old_index = index = pointer;

	Object = 0;

	index = sMessage.Find('|',index);

	if ( index >= 0 )
	{
		pointer = index+1;

		t = sMessage.Mid(old_index,index-old_index);

		if ( "" == t )
		{
			if ( old_index != index )
			{
				printf("!!!!!!! PARSER ERROR index: %d %d\n",old_index,index);
				printf("%s\n",sMessage.Data());
			}
			return DC_MESSAGE_UNKNOWN;
		}

		// check chat
		if ( GetContent(DC_S_MESSAGE_CHAT,t,sContent) != -1 )
		{
			sContent = t;

			Object  = ParseChat(sContent);

			return DC_MESSAGE_CHAT;
		}
		// check another chat
		else if ( t.Data()[0] != '$' )
		{
			sContent = t;

			Object  = ParseChat(sContent);

			return DC_MESSAGE_CHAT;
		}
		else if ( GetContent(DC_S_MESSAGE_SEARCH,t,sContent) != -1 )
		{
			Object = ParseSearch(sContent);

			return DC_MESSAGE_SEARCH;
		}
		else if ( GetContent(DC_S_MESSAGE_MYINFO,t,sContent) != -1 )
		{
			Object  = ParseMyInfo(sContent);

			return DC_MESSAGE_MYINFO;
		}
		else if ( GetContent(DC_S_MESSAGE_HELLO,t,sContent) != -1 )
		{
			Object  = ParseHello(sContent);

			return DC_MESSAGE_HELLO;
		}
		else if ( GetContent(DC_S_MESSAGE_QUIT,t,sContent) != -1 )
		{
			Object  = ParseQuit(sContent);

			return DC_MESSAGE_QUIT;
		}
		else if ( GetContent(DC_S_MESSAGE_NICKLIST,t,sContent) != -1 )
		{
			Object = ParseNickList(sContent);

			return DC_MESSAGE_NICKLIST;
		}
		else if ( GetContent(DC_S_MESSAGE_OPLIST,t,sContent) != -1 )
		{
			Object = ParseOpList(sContent);

			return DC_MESSAGE_OPLIST;
		}
		else if ( GetContent(DC_S_MESSAGE_CONNECTTOME,t,sContent) != -1 )
		{
			Object  = ParseConnectToMe(sContent);

			return DC_MESSAGE_CONNECTTOME;
		}
		else if ( GetContent(DC_S_MESSAGE_KEY,t,sContent) != -1 )
		{
			return DC_MESSAGE_KEY;
		}
		else if ( GetContent(DC_S_MESSAGE_HUBNAME,t,sContent) != -1 )
		{
			Object  = ParseHubName(sContent);

			return DC_MESSAGE_HUBNAME;
		}
		else if ( GetContent(DC_S_MESSAGE_LOCK,t,sContent) != -1 )
		{
			Object  = ParseLock(sContent);

			return DC_MESSAGE_LOCK;
		}
		else if ( GetContent(DC_S_MESSAGE_TO,t,sContent) != -1 )
		{
			Object  = ParsePrivateChat(sContent);

			return DC_MESSAGE_PRIVATECHAT;
		}
		else if ( GetContent(DC_S_MESSAGE_FORCEMOVE,t,sContent) != -1 )
		{
			Object  = ParseForceMove(sContent);

			return DC_MESSAGE_FORCEMOVE;
		}
		else if ( GetContent(DC_S_MESSAGE_REVCONNECTTOME,t,sContent) != -1 )
		{
			Object  = ParseRevConnectToMe(sContent);

			return DC_MESSAGE_REVCONNECTTOME;
		}
		else if ( GetContent(DC_S_MESSAGE_SR,t,sContent) != -1 )
		{
			Object = ParseSearchResult(sContent);

			return DC_MESSAGE_SEARCHRESULT;
		}
		else if ( GetContent(DC_S_MESSAGE_MYNICK,t,sContent) != -1 )
		{
			Object  = ParseMyNick(sContent);

			return DC_MESSAGE_MYNICK;
		}
		else if ( GetContent(DC_S_MESSAGE_DIRECTION,t,sContent) != -1 )
		{
			Object = ParseDirection(sContent);

			return DC_MESSAGE_DIRECTION;
		}
		else if ( GetContent(DC_S_MESSAGE_FILELENGTH,t,sContent) != -1 )
		{
			Object = ParseFileLength(sContent);

			return DC_MESSAGE_FILELENGTH;
		}
		else if ( GetContent(DC_S_MESSAGE_LISTLEN,t,sContent) != -1 )
		{
			Object = ParseFileLength(sContent);

			return DC_MESSAGE_LISTLEN;
		}
		else if ( GetContent(DC_S_MESSAGE_GET,t,sContent) != -1 )
		{
			Object = ParseGet(sContent);

			return DC_MESSAGE_GET;
		}
		else if ( GetContent(DC_S_MESSAGE_ERROR,t,sContent) != -1 )
		{
			Object = ParseError(sContent);

			return DC_MESSAGE_ERROR;
		}
		else if ( GetContent(DC_S_MESSAGE_GETINFO,t,sContent) != -1 )
		{
			Object = ParseGetInfo(sContent);

			return DC_MESSAGE_GETINFO;
		}
		else if ( GetContent(DC_S_MESSAGE_MAXEDOUT,t,sContent) != -1 )
		{
			Object = new CMessageMaxedOut();

			return DC_MESSAGE_MAXEDOUT;
		}
		else if ( GetContent(DC_S_MESSAGE_CANCEL,t,sContent) != -1 )
		{
			Object = new CMessageCancel();

			return DC_MESSAGE_CANCEL;
		}
		else if ( GetContent(DC_S_MESSAGE_CANCELED,t,sContent) != -1 )
		{
			Object = new CMessageCanceled();

			return DC_MESSAGE_CANCELED;
		}
		else if ( GetContent(DC_S_MESSAGE_SEND,t,sContent) != -1 )
		{
			Object = new CMessageSend();

			return DC_MESSAGE_SEND;
		}
		else if ( GetContent(DC_S_MESSAGE_GETLISTLEN,t,sContent) != -1 )
		{
			Object = new CMessageGetListLen();

			return DC_MESSAGE_GETLISTLEN;
		}
		else if ( GetContent(DC_S_MESSAGE_VALIDATEDENIDE,t,sContent) != -1 )
		{
			Object = new CMessageValidateDenide();

			return DC_MESSAGE_VALIDATEDENIDE;
		}
		else if ( GetContent(DC_S_MESSAGE_HUBISFULL,t,sContent) != -1 )
		{
			Object = new CMessageHubIsFull();

			return DC_MESSAGE_HUBISFULL;
		}
		else if ( GetContent(DC_S_MESSAGE_PING,t,sContent) != -1 )
		{
			Object = new CMessagePing();

			return DC_MESSAGE_PING;
		}
		else if ( GetContent(DC_S_MESSAGE_GETPASS,t,sContent) != -1 )
		{
			Object = new CMessageGetPass();

			return DC_MESSAGE_GETPASS;
		}
		else if ( GetContent(DC_S_MESSAGE_BADPASS,t,sContent) != -1 )
		{
			Object = new CMessageBadPass();

			return DC_MESSAGE_BADPASS;
		}
		else if ( GetContent(DC_S_MESSAGE_LOGEDIN,t,sContent) != -1 )
		{
			Object = ParseLogedIn(sContent);

			return DC_MESSAGE_LOGEDIN;
		}
		else
		{
			printf("!!!!!!!!!!!!!! unknown start ");
			printf("index: %d %d!!!!!!!!!!!!!!\n",old_index,index);
			printf("%s\n",t.Data());
			printf("!!!!!!!!!!!!!! unknown end !!!!!!!!!!!!!!\n");
			return DC_MESSAGE_UNKNOWN;
		}
	}
	else
	{
//		printf("%s\n",sMessage.Data());
	}

	return DC_MESSAGE_PARSE_ERROR;
}

/** */
CObject * CMessageHandler::ParseLock( CString sContent )
{
	CMessageLock * msg=0;

	int i;

	i = sContent.Find(' ');

	if ( (msg = new CMessageLock) != 0 )
	{
		// lock without pk
		if ( i < 0 )
		{
			msg->sData = sContent;
			msg->sPK   = "";
		}
		else
		{
			msg->sData = sContent.Left(i);
			msg->sPK   = sContent.Mid(i+4,sContent.Length()-i-4);
		}
	}

	return msg;
}

/** */
CObject * CMessageHandler::ParseHello( CString sContent )
{
	CMessageHello * msg=0;

	if ( (msg = new CMessageHello) != 0 )
	{
		msg->sNick = sContent;
	}

	return msg;
}

/** */
CObject * CMessageHandler::ParseMyNick( CString sContent )
{
	CMessageMyNick * msg=0;

	if ( (msg = new CMessageMyNick) != 0 )
	{
		msg->sMyNick = sContent;
	}

	return msg;
}

/** */
CObject * CMessageHandler::ParseChat( CString sContent )
{
	CMessageChat * msg=0;

	int i,i1;

	i = sContent.Find('<');

	if ( (i1=sContent.Find('>',i+1)) < 0 )
	{
		return 0;
	}

	if ( (msg = new CMessageChat) != 0 )
	{
		msg->sNick    = sContent.Mid(i+1,i1-1);
		msg->sMessage = sContent.Mid(i1+2,sContent.Length()-i1-2);
	}

	return msg;
}

/** */
CObject * CMessageHandler::ParseMyInfo( CString sContent )
{
	CMessageMyInfo * msg=0;
	CString s;
	int i,i1,i2,i3,i4,i5,i6;
	char c;

	// dest e.g. $ALL
	if ( (i=sContent.Find(' ')) < 0 )
		return 0;

	if ( (i1=sContent.Find(' ',i+1)) < 0 )
		return 0;

	if ( (i2=sContent.Find('$',i1+1)) < 0 )
		return 0;

	if ( (i3=sContent.Find('$',i2+1)) < 0 )
		return 0;

	if ( (i4=sContent.Find('$',i3+1)) < 0 )
		return 0;

	if ( (i5=sContent.Find('$',i4+1)) < 0 )
		return 0;

	if ( (i6=sContent.Find('$',i5+1)) < 0 )
		return 0;

	if ( (msg = new CMessageMyInfo) != 0 )
	{
		msg->sNick    = sContent.Mid(i +1,i1-i -1);
		msg->sComment = sContent.Mid(i1+1,i2-i1-1);
		msg->sUnknown = sContent.Mid(i2+1,i3-i2-1);

		c = 1;

		// check user mode
		if ( (i4-i3-1) > 0 )
		{
			c = sContent.Data()[i4-1];

			switch(c)
			{
				case 1:
					c = 2;
					msg->eAwayMode = euamNORMAL;
					break;
				case 2:
				case 3:
					c = 2;
					msg->eAwayMode = euamAWAY;
					break;
				case 4:
				case 5:
					c = 2;
					msg->eAwayMode = euamNORMAL;
					break;
				case 6:
				case 7:
					c = 2;
					msg->eAwayMode = euamAWAY;
					break;
				case 8:
				case 9:
					c = 2;
					msg->eAwayMode = euamNORMAL;
					break;
				case 10:
				case 12:
					c = 2;
					msg->eAwayMode = euamAWAY;
					break;
				default:
					c = 1;
					msg->eAwayMode = euamNORMAL;
					break;
			}
		}

		msg->sSpeed   = sContent.Mid(i3+1,i4-i3-c);
		msg->sEMail   = sContent.Mid(i4+1,i5-i4-1);

		s = sContent.Mid(i5+1,i6-i5-1);
		msg->lShared  = s.asULL();
	}

	return msg;
}

/** */
CObject * CMessageHandler::ParseConnectToMe( CString sContent )
{
	CMessageConnectToMe * msg=0;
	CString s;

	int i,i1;

	if ( (i=sContent.Find(' ')) < 0 )
	{
		return 0;
	}

	if ( (i1=sContent.Find(':',i+1)) < 0 )
	{
		return 0;
	}

	if ( (msg = new CMessageConnectToMe) != 0 )
	{
		msg->sNick = sContent.Mid(0,i);
		msg->sHost = sContent.Mid(i+1,i1-i-1);

		s = sContent.Mid(i1+1,sContent.Length()-i1-1);

		if ( s == "" )
		{
			msg->iPort = 411;
		}
		else
		{
			msg->iPort = atoi(s.Data());
		}
	}

	return msg;
}

/** */
CObject * CMessageHandler::ParseRevConnectToMe( CString sContent )
{
	CMessageRevConnectToMe * msg=0;

	int i;

	if ( (i=sContent.Find(' ')) < 0 )
	{
		return 0;
	}

	if ( (msg = new CMessageRevConnectToMe) != 0 )
	{
		msg->sRemoteNick = sContent.Mid(0,i);
		msg->sNick       = sContent.Mid(i+1,sContent.Length()-i-1);
	}

	return msg;
}

/** */
CObject * CMessageHandler::ParseNickList( CString sContent )
{
	CMessageNickList * msg=0;
	int i,i1;

	i = i1 = 0;

	msg = new CMessageNickList();

	while ( (i=sContent.Find('$',i)) >= 0 )
	{
		CString s;

		s = sContent.Mid(i1,i-i1);

		msg->NickList.Add(new CString(s));

		i+=2;
		i1=i;
	}

	return msg;
}

/** */
CObject * CMessageHandler::ParseOpList( CString sContent )
{
	CMessageNickList * msg=0;
	int i,i1;

	i = i1 = 0;

	msg = new CMessageNickList();

	while ( (i=sContent.Find('$',i)) >= 0 )
	{
		CString s;

		s = sContent.Mid(i1,i-i1);

		msg->NickList.Add(new CString(s));

		i+=2;
		i1=i;
	}

	return msg;
}

/** */
CObject * CMessageHandler::ParseQuit( CString sContent )
{
	CMessageQuit * msg= new CMessageQuit();

	msg->sNick = sContent;

	return msg;
}

/** */
CObject * CMessageHandler::ParseSearch( CString sContent )
{
	CMessageSearch * msg=0;

	int i,i1;

	if ( (i=sContent.Find(' ')) < 0 )
		return 0;

	if ( (i1=sContent.Find('?',i+1)) < 0 )
		return 0;

	if ( (i1=sContent.Find('?',i1+1)) < 0 )
		return 0;

	if ( (i1=sContent.Find('?',i1+1)) < 0 )
		return 0;

	if ( (i1=sContent.Find('?',i1+1)) < 0 )
		return 0;

	if ( (msg = new CMessageSearch) != 0 )
	{
		msg->sNick   = sContent.Mid(0,i);
		msg->sFlag   = "";
		msg->sString = sContent.Mid(i1+1,sContent.Length()-i1-1);

//		printf("Search: %s\n%s %s\n",sContent.Data(),msg->sNick.Data(),msg->sString.Data());
	}

	return msg;
}

/** */
CObject * CMessageHandler::ParseSearchResult( CString sContent )
{
	CMessageSearchResult * msg=0;
	CString s;
	int i,i1,i2,i3;

/*	for(i=0;i<sContent.Length();i++)
		printf("%02X ",sContent.Data()[i]);
	printf("\n");*/

	if ( (i=sContent.Find(' ')) < 0 )
		return 0;

	if ( (i1=sContent.Find(0x05,i+1)) < 0 )
		return 0;

	if ( (i2=sContent.Find(' ',i1+1)) < 0 )
		return 0;

	if ( (i3=sContent.Find(0x05,i2+1)) < 0 )
		return 0;

	if ( (msg = new CMessageSearchResult) != 0 )
	{
		msg->sNick    = sContent.Mid(0,i);
		msg->sFile    = sContent.Mid(i+1,i1-i-1);
		s = sContent.Mid(i1+1,i2-i1-1);
		msg->lSize = s.asULL();

		// parse the user slots
		s = sContent.Mid(i2+1,i3-i2-1);
		msg->iFreeSlot = 0;
		msg->iMaxSlot  = 0;

		if ( (i1 = s.Find('/')) != -1 )
		{
			msg->iFreeSlot = s.Mid(0,i1).asUINT();
			msg->iMaxSlot  = s.Mid(i1+1,s.Length()-i1-1).asUINT();
		}

		msg->sHubName = "";
		msg->sHubHost = "";

		s = sContent.Mid(i3+1,sContent.Length()-i3-1);

		if ( s != "" )
		{
			if ( (i1 = s.FindRev(')')) != -1 )
			{
				if ( (i2 = s.FindRev('('),i1-1) != -1 )
				{
					if ( i2 > 0 ) i2--; // remove space " ("
					msg->sHubName = s.Mid(0,i2);
					msg->sHubHost = s.Mid(i2+2,i1-i2-2);
				}
			}
		}

/*		printf("%s\n%s | %s | %s | %s | %s | %s\n",\
			sContent.Data(),
			msg->sNick.Data(),
			msg->sFile.Data(),
			msg->sSize.Data(),
			msg->sSlot.Data(),
			msg->sHubName.Data(),
			msg->sHubHost.Data() );*/
	}

	return msg;
}

/** */
CObject * CMessageHandler::ParsePrivateChat( CString sContent )
{
	CMessagePrivateChat * msg=0;

	int i,i1,/*i2,*/i3;

	if ( (i=sContent.Find(' ')) < 0 )
		return 0;

	if ( (i1=sContent.Find(' ',i+1)) < 0 )
		return 0;

//	if ( (i2=sContent.Find(' ',i1+1)) < 0 )
//		return 0;

	if ( (i3=sContent.Find('$',i1+1)) < 0 )
		return 0;

	if ( (msg = new CMessagePrivateChat) != 0 )
	{
		msg->sNick   = sContent.Mid(0,i);
		msg->sFrom   = sContent.Mid(i1+1,i3-1-i1-1);
		msg->sString = sContent.Mid(i3+1,sContent.Length()-i3-1);
/*
		printf("%s\n%s\n%s\n%s\n",\
			sContent.Data(),
			msg->sNick.Data(),
			msg->sFrom.Data(),
			msg->sString.Data() );
*/
	}

	return msg;
}

/** */
CObject * CMessageHandler::ParseForceMove( CString sContent )
{
	int i;
	CString s;
	CMessageForceMove * msg=0;

	if ( "" == sContent )
	{
		return msg;
	}

	i = sContent.Find(':');

	if ( (msg = new CMessageForceMove) != 0 )
	{
		if ( i > 0 )
		{
			s = sContent.Mid(i+1,sContent.Length()-i-1);			
		}
		else
		{
			s = "";
		}

		if ( (i < 0) || (s == "") )
		{
			msg->sHost = sContent;
			msg->iPort   = 411;
		}
		else
		{
			msg->sHost = sContent.Mid(0,i);
			msg->iPort = atoi(s.Data());
		}
	}

	return msg;
}

/** */
CObject * CMessageHandler::ParseDirection( CString sContent )
{
	int i;
	CString s;
	CMessageDirection * msg=0;

	if ( (i=sContent.Find(' ')) < 0 )
		return 0;

	if ( (msg = new CMessageDirection) != 0 )
	{
		s = sContent.Mid(0,i);

		if ( "Upload" == s )
			msg->Direction = edUPLOAD;
		else if ( "Download" == s )
			msg->Direction = edDOWNLOAD;
		else
			msg->Direction = edNONE;

		s = sContent.Mid(i+1,sContent.Length()-i-1);
		if(s!="")
			msg->iLevel = atoi(s.Data());
		else
			msg->iLevel = 0;
	}

	return msg;
}

/** */
CObject * CMessageHandler::ParseFileLength( CString sContent )
{
	CMessageFileLength * msg=0;

	if ( (msg = new CMessageFileLength) != 0 )
	{
		if ( "" != sContent )
			msg->lFileLength = atol(sContent.Data());
		else
			msg->lFileLength = 0;
	}

	return msg;
}

/** */
CObject * CMessageHandler::ParseGet( CString sContent )
{
	int i;
	CString s;
	CMessageGet * msg=0;

	if ( (i=sContent.Find('$')) < 0 )
		return 0;

	if ( (msg = new CMessageGet) != 0 )
	{
		msg->sFilename = sContent.Mid(0,i);
		s = sContent.Mid(i+1,sContent.Length()-i-1);
		msg->lPos = s.asULL();
	}

	return msg;
}

/** */
CObject * CMessageHandler::ParseError( CString sContent )
{
	CMessageError * msg=0;

	if ( (msg = new CMessageError) != 0 )
	{
		msg->sError = sContent;
	}

	return msg;
}

/** */
CObject * CMessageHandler::ParseHubName( CString sContent )
{
	CMessageHubName * msg=0;

	if ( (msg = new CMessageHubName) != 0 )
	{
		msg->sHubName = sContent;
	}

	return msg;
}

/** */
CObject * CMessageHandler::ParseGetInfo( CString sContent )
{
	CMessageGetInfo * msg=0;

	int i;

	if ( (i=sContent.Find(' ')) < 0 )
	{
		return 0;
	}

	if ( (msg = new CMessageGetInfo) != 0 )
	{
		msg->sNick = sContent.Mid(0,i);
		msg->sFrom = sContent.Mid(i+1,sContent.Length()-i-1);
	}

	return msg;
}

/** */
CObject * CMessageHandler::ParseLogedIn( CString sContent )
{
	CMessageLogedIn * msg=0;

	if ( (msg = new CMessageLogedIn) != 0 )
	{
		msg->sNick = sContent;
	}

	return msg;
}
