/***************************************************************************
                          clisten.cpp  -  description
                             -------------------
    begin                : Fri Mar 22 2002
    copyright            : (C) 2002 by Mathias Kster
    email                : mathen@ketelhot.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#ifndef WIN32
#include <unistd.h>
#endif

#include <dclib/clisten.h>

/** */
CListen::CListen()
{
	CallBack = 0;
}

/** */
CListen::~CListen()
{
	CallBack = 0;
	Disconnect();
}

/** */
int CListen::StartListen( int port )
{
	if ( Listen(port) != 0 )
	{
		return -1;
	}
    
	Start();
    
	return 0;
}

/** */
void CListen::StopListen()
{
	Stop();
    
	Disconnect();
}

/** */
void CListen::Thread( CObject * )
{
	int fd;
    
	fd = Accept();
    
	if ( fd != -1 )
	{
		if ( CallBack != 0 )
		{
			CallBack(fd);
		}
		else
		{
			DC_ListenCallBack(fd);
		}
	}

#ifdef WIN32
	Sleep(100);
#else
	usleep(100);
#endif
}

