/***************************************************************************
                          chubsearch.cpp  -  description
                             -------------------
    begin                : Fri Mar 15 2002
    copyright            : (C) 2002 by Mathias Kster
    email                : mathen@ketelhot.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <stdio.h>
#include <fcntl.h>
#include <stdlib.h>

#ifndef WIN32
#include <unistd.h>
#else
#include <io.h>
#endif

#include <dclib/dcobject.h>
#include <dclib/cmessagehandler.h>

#include "chubsearch.h"

CHubSearch::CHubSearch()
{
	sBuffer = "";
}

CHubSearch::~CHubSearch()
{
}

/** */
void CHubSearch::ConnectionState( eConnectionState state )
{
	CMessageConnectionState *Object;

	Object = new CMessageConnectionState();

	Object->eType = DC_MESSAGE_CONNECTION_STATE;

	Object->eState   = state;
	Object->sMessage = GetSocketError();

	if ( DC_CallBack( Object ) == -1 )
	{
		printf("CallBack failed (state)...\n");
		delete Object;
	}
}

/** */
int CHubSearch::HandleMessage( char * c, int )
{
	int p=0;
	eDCMessage type;
	CObject * Object;

	CMessageHandler MessageHandler;

	CString s;

	s = c;

	while( (type=MessageHandler.Parse(s,p,Object=0)) != DC_MESSAGE_PARSE_ERROR )
	{
		switch (type)
		{
			case DC_MESSAGE_SEARCHRESULT:
			{
				break;
			}

			default:
			{
				// remove message
				delete Object;
				Object = 0;
			}
		}

		if (Object)
		{
			((CDCMessage*)Object)->eType = type;

			if ( DC_CallBack( Object ) == -1 )
			{
				printf("CallBack failed ...\n");
				delete Object;
			}
		}
	}

	return 0;
}

/** */
void CHubSearch::DataAvailable( const char * buffer, int )
{
	sBuffer = buffer;

	// add '|' for parser
	sBuffer += '|';

	HandleMessage( (char*)sBuffer.Data(), sBuffer.Length() );
}
