/***************************************************************************
                          cdownloadqueue.h  -  description
                             -------------------
    begin                : Don Mai 16 2002
    copyright            : (C) 2002 by Mathias Kster
    email                : mathen@ketelhot.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef CDOWNLOADQUEUE_H
#define CDOWNLOADQUEUE_H

#include <time.h>

#include <dclib/dcos.h>
#include <dclib/dcobject.h>
#include <dclib/cthread.h>
#include <dclib/cobject.h>
#include <dclib/clist.h>
#include <dclib/cstring.h>
#include <dclib/cstringlist.h>
#include <dclib/ctransfer.h>
#include <dclib/cbytearray.h>

/**
  *@author Mathias Kster
  */

class DCTransferObject;
class DCTransferFileObject;

class DLL_EXPORT CDownloadQueue : public CObject {
public:
	/** */
	CDownloadQueue();
	/** */
	virtual ~CDownloadQueue();

	/** */
	CStringList * GetUserHubList( CString nick );
	/** */
	DCTransferObject * GetUserTransferObject( CString nick, CString hubname );
	/** */
	DCTransferFileObject * GetUserFileObject( CString nick, CString hubname, CString remotename );
	/** */
	bool DelUserFileObject( CString nick, CString hubname, CString remotefile );

	/** file queue
	 -> [CStringList] nick
	  -> [CStringList] hubname
	   -> [CTransferObject] (nick,hubname,hubhost,[CStringList(CFileObject)]
	    -> [CStringList] remotefile (for double transfers check this name and filelength)
	     -> [CFileObject] (all the file stuff)
	*/
	CStringList * pQueue;
};


class DLL_EXPORT DCTransferFileObject : public CObject {
public:
	/** */
	DCTransferFileObject();
	/** */
	virtual ~DCTransferFileObject();

	/** */
	DCTransferFileObject & operator = ( DCTransferFileObject * TransferFileObject ) { copy(TransferFileObject); return *this; };

	/** file or buffer */
	eltMedium eMedium;
	/** remote file with path */
	CString sRemoteFile;
	/** remote filename */
	CString sRemoteFileName;
	/** the download root path or user specific root path */
	CString sLocalRootPath;
	/** the local path for download dir */
	CString sLocalPath;
	/** the local filename */
	CString sLocalName;
	/** */
	eTransferFileState eState;
	/** file size */
	ulonglong lSize;
	/** current file position */
	ulonglong lStartPosition;
	/** current file position */
	ulonglong lCurrentPosition;
	/** file end position */
	ulonglong lEndPosition;
	/** multi download */
	bool bMultiDownload;
	/** */
	ulonglong ID;

private:
	/** */
	void copy( DCTransferFileObject * TransferFileObject );
};

class DLL_EXPORT DCTransferObject : public CObject {
public:
	/** */
	DCTransferObject() {};
	/** */
	virtual ~DCTransferObject() {};

	/** */
	CString sNick;
	/** */
	CString sHubName;
	/** */
	CString sHubHost;
	/** */
	time_t tTimeout;
	/** */
	eTransferWaitState eState;
	/** */
	CString sUserFileList;
	/** */
	CStringList pTransferFileList;
	/** */
	int iConnections;
};

class DLL_EXPORT DCTransferWait : public CObject {
public:
	/** */
	DCTransferWait() {};
	/** */
	virtual ~DCTransferWait() {};

	/** */
	CString sNick;
	/** */
	CString sHubName;
	/** */
	CString sHubHost;
	/** */
	CString sUserHost;
	/** */
	time_t tTimeout;
};

#endif
