/***************************************************************************
                          cdownloadqueue.cpp  -  description
                             -------------------
    begin                : Don Mai 16 2002
    copyright            : (C) 2002 by Mathias Kster
    email                : mathen@ketelhot.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <stdio.h>

#include "cdownloadqueue.h"


/** */
CDownloadQueue::CDownloadQueue()
{
	pQueue = new CStringList();
}

/** */
CDownloadQueue::~CDownloadQueue()
{
	if ( pQueue )
	{
		delete pQueue;
		pQueue = 0;
	}
}

/** */
CStringList * CDownloadQueue::GetUserHubList( CString nick )
{
	CStringList * StringList = 0;

	if ( pQueue->Get( nick, (CObject *&) StringList ) == 0 )
	{
		return StringList;
	}

	return 0;
}

/** */
DCTransferObject * CDownloadQueue::GetUserTransferObject( CString nick, CString hubname )
{
	CStringList * StringList = 0;
	DCTransferObject * TransferObject = 0;

	if ( (StringList = GetUserHubList( nick )) != 0 )
	{
		if ( StringList->Get( hubname, (CObject *&) TransferObject ) == 0 )
		{
			return TransferObject;
		}
	}

	return 0;
}

/** */
DCTransferFileObject * CDownloadQueue::GetUserFileObject( CString nick, CString hubname, CString remotename )
{
	DCTransferFileObject * TransferFileObject = 0;
	DCTransferObject * TransferObject;

	if ( (TransferObject = GetUserTransferObject( nick, hubname )) != 0 )
	{
		if ( TransferObject->pTransferFileList.Get( remotename, (CObject *&) TransferFileObject ) == 0 )
		{
			return TransferFileObject;
		}
	}

	return 0;
}

/** */
bool CDownloadQueue::DelUserFileObject( CString nick, CString hubname, CString remotefile )
{
	bool res = FALSE,err;
	CStringList * StringList;
	DCTransferObject * TransferObject;
	DCTransferFileObject * TransferFileObject;

	if ( (TransferObject = GetUserTransferObject( nick, hubname ) ) != 0 )
	{
		if ( remotefile != "" )
		{
			// remove a single file
			if ( TransferObject->pTransferFileList.Get( remotefile, (CObject *&) TransferFileObject ) == 0 )
			{
				if ( TransferFileObject->eState == etfsTRANSFER )
				{
					printf("warning ! file transfer is running ...\n");fflush(stdout);
				}
				else
				{
					TransferObject->pTransferFileList.Del(remotefile);
					res = TRUE;
				}
			}
		}
		else
		{
			// remove a file tree
			TransferFileObject = 0;
			err = FALSE;
			while ( TransferObject->pTransferFileList.Next( (CObject *&) TransferFileObject ) )
			{
				if ( TransferFileObject->eState == etfsTRANSFER )
				{
					printf("warning ! file transfer is running ...\n");fflush(stdout);
					err = TRUE;
					break;
				}
			}

			if ( err == FALSE )
			{
				if ( (StringList = GetUserHubList(nick)) != 0 )
				{
					StringList->Del(hubname);

					if ( StringList->Count() == 0 )
					{
						pQueue->Del(nick);
					}

					res = TRUE;
				}
			}
		}
	}
	else
	{
		printf("warning ! queue not found ...\n");fflush(stdout);
	}

	return res;
}

/** */
DCTransferFileObject::DCTransferFileObject()
{
	eMedium          = eltNONE;
	sRemoteFile      = "";
	sRemoteFileName  = "";
	sLocalRootPath   = "";
	sLocalPath       = "";
	sLocalName       = "";
	eState           = etfsNONE;
	lSize            = 0;
	lStartPosition   = 0;
	lCurrentPosition = 0;
	lEndPosition     = 0;
	bMultiDownload   = FALSE;
	ID               = 0;
}

/** */
DCTransferFileObject::~DCTransferFileObject()
{
}

/** */
void DCTransferFileObject::copy( DCTransferFileObject * TransferFileObject )
{
	if(!TransferFileObject)
		return;

	eMedium         = TransferFileObject->eMedium;
	sRemoteFile     = TransferFileObject->sRemoteFile;
	sRemoteFileName = TransferFileObject->sRemoteFileName;
	sLocalRootPath  = TransferFileObject->sLocalRootPath;
	sLocalPath      = TransferFileObject->sLocalPath;
	sLocalName      = TransferFileObject->sLocalName;
	eState          = TransferFileObject->eState;
	lSize           = TransferFileObject->lSize;
	lStartPosition  = TransferFileObject->lStartPosition;
	lEndPosition    = TransferFileObject->lEndPosition;
	bMultiDownload  = TransferFileObject->bMultiDownload;
	ID              = TransferFileObject->ID;
}
