/***************************************************************************
                           cdir.h  -  description
                             -------------------
    begin                : Tue May 14 2002
    copyright            : (C) 2002 by Mathias Kster
    email                : mathen@ketelhot.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef CDIR_H
#define CDIR_H

/**
  *@author Mathias Kster
  */

#include <dclib/dcos.h>
#include <dclib/clist.h>
#include <dclib/cobject.h>
#include <dclib/cstring.h>

class DLL_EXPORT CFileInfo : public CObject {
public:
	CFileInfo() {};
	virtual ~CFileInfo() {};

	CString name;
	ulonglong size;
};

class DLL_EXPORT CDir : public CObject {

public:
	/** */
	CDir();
	/** */
	CDir( CString path );
	/** */
	virtual ~CDir();

	typedef enum FilterSpec {
		Dirs  = 0x0001,
		Files = 0x0002
	};

	/** */
	static CString HomeDirPath();
	/** */
	bool cd( CString path );
	/** */
	CString Path();
	/** */
	CString DirName();
	/** */
	CString CleanDirPath( CString path );
	/** */
	CString ConvertSeparators( CString path );
	/** */
	CString SimplePath( CString path );
	/** */
	ulonglong getFileSize( CString filename, bool rel = TRUE );

	/** */
	bool CreatePath( CString path );
	/** */
	bool ReadEntrys( FilterSpec filterspec, CList<CFileInfo> * list );
	/** */
	bool IsDir( CString s );
	/** */
	bool IsFile( CString s );
	/** */
//	ulonglong GetFileSize( CString s );
	/** */
	CString GetCorrectFilePath( CString file, CList<CString> * sharedfolders );
	/** */
	void SetPath( CString path );

private:
	/** */
	CString sPath;
	/** */
	CString sDrive;
};

#ifdef WIN32
#include <io.h>
#include <stdio.h>
#include <stdlib.h>
#include <sys/types.h>

/* struct dirent - same as Unix */
struct dirent {
	long d_ino; /* inode (always 1 in WIN32) */
	off_t d_off; /* offset to this dirent */
	unsigned short d_reclen; /* length of d_name */
	char d_name[_MAX_FNAME+1]; /* filename (null terminated) */
};

/* typedef DIR - not the same as Unix */
typedef struct {
	long handle; /* _findfirst/_findnext handle */
	short offset; /* offset into directory */
	short finished; /* 1 if there are not more files */
	struct _finddata_t fileinfo; /* from _findfirst/_findnext */
	char *dir; /* the dir we are reading */
	struct dirent dent; /* the dirent to return */
} DIR;

/* Function prototypes */
DIR * opendir(const char *);
struct dirent * readdir(DIR *);
int closedir(DIR *);
#endif

#endif
