/***************************************************************************
                          cconfig.cpp  -  description
                             -------------------
    begin                : Tue May 14 2002
    copyright            : (C) 2002 by Mathias Kster
    email                : mathen@ketelhot.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#define DCLIB_CONFIG		"dclib.cfg"
#define DCTRA_CONFIG		"dctra.cfg"
#define DCHUB_CONFIG		"dchub.cfg"

#define XML_DCLIB_CONFIG	"dclib"
#define XML_DCHUB_CONFIG	"dchub"
#define XML_DCTRA_CONFIG	"dctra"

#define XML_IDENTIFY		"identify"
#define XML_NICK		"nick"
#define XML_EMAIL		"email"
#define XML_ANTISPAM		"antispam"
#define XML_DESCRIPTION		"description"
#define XML_SPEED		"speed"

#define XML_TRANSFER		"transfer"
#define XML_DOWNLOADFOLDER	"downloadfolder"
#define XML_SHAREDFOLDER	"sharedfolder"
#define XML_MAXUPLOAD		"maxupload"
#define XML_MAXTRANSFERRATE	"maxtransferrate"

#define XML_CONNECTION		"connection"
#define XML_MODE		"mode"
#define XML_TCPLISTENPORT	"tcplistenport"
#define XML_UDPLISTENPORT	"udplistenport"
#define XML_IP			"ip"
#define XML_CHANGEIP		"changeip"
#define XML_INTERFACE		"interface"

#define XML_SERVER		"server"
#define XML_HOST		"host"
#define XML_BOOKMARK		"bookmark"
#define XML_PUBLIC		"public"
#define XML_NAME		"name"
#define XML_USERCOUNT		"usercount"

#define XML_FILE		"file"
#define XML_LOCALNAME		"localname"
#define XML_LOCALPATH		"localpath"
#define XML_LOCALROOTPATH	"localrootpath"
#define XML_SIZE		"size"
#define XML_STARTPOSITION	"startposition"
#define XML_CURRENTPOSITION	"currentposition"
#define XML_ENDPOSITION		"endposition"
#define XML_REMOTEFILE		"remotefile"
#define XML_REMOTEFILENAME	"remotefilename"
#define XML_MEDIUM		"medium"
#define XML_MEDIUM_FILE		"file"
#define XML_MEDIUM_BUFFER	"buffer"

#define XML_HUBNAME		"hubname"
#define XML_HUBHOST		"hubhost"
#define XML_REMOTEHOST		"remotehost"

#define XML_HUBLISTURL		"hublisturl"
#define XML_URL			"url"
#define XML_ENABLED		"enabled"

#define XML_OTHER		"other"
#define XML_HUBLISTSTORELOCAL	"hubliststorelocal"
#define XML_RECONNECTCOUNT	"reconnectcount"
#define XML_RECONNECTTIMEOUT	"reconnecttimeout"
#define XML_TRANSFERRESPONSETIMEOUT "transferresponsetimeout"
#define XML_TRANSFERRESENDTIMEOUT "transferresendtimeout"
#define XML_FORCEMOVEENABLED	"forcemoveenabled"

#define XML_DC			"dc"
#define XML_VERSION		"version"
#define XML_RELEASE		"release"

#define XML_MODE_ACTIVE		"active"
#define XML_MODE_PASSIVE	"passive"

#define XML_FALSE		"false"
#define XML_TRUE		"true"

#define DCGUI_CONFIG_PATH	"/.dc"

#include <stdlib.h>

#include <dclib/che3.h>
#include <dclib/cxml.h>
#include <dclib/cdir.h>
#include <dclib/csocket.h>
#include "cconfig.h"

CConfig * pDCLibConfig = 0;

/** */
CConfig::CConfig( CString configpath )
{
	CDir d;

	if ( configpath == "" )
	{
		sConfigPath = CDir::HomeDirPath();
		d.SetPath(sConfigPath);
		d.CreatePath(DCGUI_CONFIG_PATH);		
		sConfigPath += DCGUI_CONFIG_PATH;
	}
	else
		sConfigPath = configpath;

	sConfigPath += DIRSEPARATOR;

	pShareBuffer = 0;

	// default settings
	sEMail = "email";
	sNick = "nick";
	eMode = ecmPassive;
	sDescription = "dc-gui user (http://dc.ketelhot.de)";
	sSpeed = "";
	iTCPListenPort = 9176;
	iUDPListenPort = 9176;
	sHost = "";
	sInterface = "ppp0";
	bAntiSpam = TRUE;
	iFakeHost = 0;
	iMaxUpload = 3;
	lMaxTransferrate = 0;
	bHubListStoreLocal = TRUE;
	iShareSize = 0;
	sShareBuffer = "";
	eAwayMode = euamNORMAL;

	iReconnectCount   = 3;
	iReconnectTimeout = 60;
	bForceMoveEnabled = TRUE;

	iTransferResendTimeout   = 100;
	iTransferResponseTimeout = 60;

	pPublicHubList = new CStringList();

	pDCLibConfig = this;
}

/** */
CConfig::~CConfig()
{
	if ( pPublicHubList )
	{
		delete pPublicHubList;
	}
}

/** */
int CConfig::LoadDCLib()
{
	CString s;
	CXml xml;
	xmlNodePtr node;

	LoadDCHub();

	s = sConfigPath + DCLIB_CONFIG;

	if ( xml.ParseFile(s) == TRUE )
	{
		for(node=xml.doc()->children;node!=0;node=node->next)
		{
			if ( xml.name(node) == XML_DCLIB_CONFIG )
			{
				ParseDCLibConfig(node->xmlChildrenNode);
			}
		}
	}

	// default hublist url
	if ( pHubListUrlList.Count() == 0 )
	{
		DCConfigHubListUrl * hublisturl = new DCConfigHubListUrl();
		hublisturl->sUrl = "http://www.neo-modus.com/PublicHubList.config";
		hublisturl->bEnabled = TRUE;
		pHubListUrlList.Add(hublisturl);
	}

	return 0;
}

/** */
int CConfig::SaveDCLib()
{
	int err=0;
	CString s;
	xmlDocPtr doc;
	xmlNodePtr node,node1;
	CXml xml;

	doc = xmlNewDoc((const xmlChar*)"1.0");

	doc->children = xmlNewDocNode(doc,0,(const xmlChar*)XML_DCLIB_CONFIG,0);

	// identify
	node = xmlNewChild( doc->children, 0, (const xmlChar*)XML_IDENTIFY, 0 );

	xmlNewChild( node, 0, (const xmlChar*)XML_NICK,  (const xmlChar*) xml.ToUTF8(sNick).Data() );
	xmlNewChild( node, 0, (const xmlChar*)XML_EMAIL, (const xmlChar*) xml.ToUTF8(sEMail).Data() );

	if (bAntiSpam==TRUE)
		s = XML_TRUE;
	else
		s = XML_FALSE;

	xmlNewChild( node, 0, (const xmlChar*)XML_ANTISPAM,    (const xmlChar*) s.Data() );
	xmlNewChild( node, 0, (const xmlChar*)XML_DESCRIPTION, (const xmlChar*) xml.ToUTF8(sDescription).Data() );
	xmlNewChild( node, 0, (const xmlChar*)XML_SPEED,       (const xmlChar*) xml.ToUTF8(sSpeed).Data() );

	// transfer
	node = xmlNewChild( doc->children, 0, (const xmlChar*)XML_TRANSFER, 0 );

	xmlNewChild( node, 0, (const xmlChar*)XML_DOWNLOADFOLDER, (const xmlChar*) xml.ToUTF8(sDownloadFolder).Data() );

	CString *ps=0;
	while( (ps=SharedFolders.Next(ps)) != 0 )
	{
		xmlNewChild( node, 0, (const xmlChar*)XML_SHAREDFOLDER, (const xmlChar*) xml.ToUTF8((*ps)).Data() );
	}

	xmlNewChild( node, 0, (const xmlChar*)XML_MAXUPLOAD, (const xmlChar*) CString().setNum(iMaxUpload).Data() );
	xmlNewChild( node, 0, (const xmlChar*)XML_MAXTRANSFERRATE, (const xmlChar*) CString().setNum(lMaxTransferrate).Data() );

	// connection
	node = xmlNewChild( doc->children, 0, (const xmlChar*)XML_CONNECTION, 0 );

	if ( eMode == ecmPassive )
		s = XML_MODE_PASSIVE;
	else
		s = XML_MODE_ACTIVE;
	xmlNewChild( node, 0, (const xmlChar*)XML_MODE, (const xmlChar*) s.Data() );
	xmlNewChild( node, 0, (const xmlChar*)XML_TCPLISTENPORT, (const xmlChar*) CString().setNum(iTCPListenPort).Data() );
	xmlNewChild( node, 0, (const xmlChar*)XML_UDPLISTENPORT, (const xmlChar*) CString().setNum(iUDPListenPort).Data() );
	xmlNewChild( node, 0, (const xmlChar*)XML_CHANGEIP, (const xmlChar*) CString().setNum(iFakeHost).Data() );
	xmlNewChild( node, 0, (const xmlChar*)XML_IP, (const xmlChar*) sHost.Data() );
	xmlNewChild( node, 0, (const xmlChar*)XML_INTERFACE, (const xmlChar*) sInterface.Data() );

	// hublisturl
	node = xmlNewChild( doc->children, 0, (const xmlChar*)XML_HUBLISTURL, 0 );

	DCConfigHubListUrl *hublisturl = 0;

	while( (hublisturl=pHubListUrlList.Next(hublisturl)) != 0 )
	{
		node1 = xmlNewChild( node, 0, (const xmlChar*)XML_URL, 0 );
		xmlNewChild( node1, 0, (const xmlChar*)XML_NAME, (const xmlChar*) xml.ToUTF8(hublisturl->sUrl).Data());

		if (hublisturl->bEnabled==TRUE)
			s = XML_TRUE;
		else
			s = XML_FALSE;

		xmlNewChild( node1, 0, (const xmlChar*)XML_ENABLED, (const xmlChar*)(const char*)s.Data() );
	}

	// other
	node = xmlNewChild( doc->children, 0, (const xmlChar*)XML_OTHER, 0 );

	if (bHubListStoreLocal==TRUE)
		s = XML_TRUE;
	else
		s = XML_FALSE;

	xmlNewChild( node, 0, (const xmlChar*)XML_HUBLISTSTORELOCAL, (const xmlChar*)(const char*)s.Data() );

	xmlNewChild( node, 0, (const xmlChar*)XML_RECONNECTCOUNT, (const xmlChar*) CString().setNum(iReconnectCount).Data() );
	xmlNewChild( node, 0, (const xmlChar*)XML_RECONNECTTIMEOUT, (const xmlChar*) CString().setNum(iReconnectTimeout).Data() );
	xmlNewChild( node, 0, (const xmlChar*)XML_TRANSFERRESPONSETIMEOUT, (const xmlChar*) CString().setNum(iTransferResponseTimeout).Data() );
	xmlNewChild( node, 0, (const xmlChar*)XML_TRANSFERRESENDTIMEOUT, (const xmlChar*) CString().setNum(iTransferResendTimeout).Data() );

	if (bForceMoveEnabled==TRUE)
		s = XML_TRUE;
	else
		s = XML_FALSE;

	xmlNewChild( node, 0, (const xmlChar*)XML_FORCEMOVEENABLED, (const xmlChar*)(const char*)s.Data() );

	// save file
	s = sConfigPath + DCLIB_CONFIG;

	if ( xmlSaveFile(s.Data(),doc) == -1 )
	{
		err = -1;
	}

	xmlFreeDoc(doc);

	return err;
}

/** */
int CConfig::LoadDCHub()
{
	CString s;
	CXml xml;
	xmlNodePtr node;

	s = sConfigPath + DCHUB_CONFIG;

	if ( xml.ParseFile(s) == FALSE )
	{
		return -1;
	}

	for(node=xml.doc()->children;node!=0;node=node->next)
	{
		if ( !xmlStrcmp( node->name, (const xmlChar*)XML_DCHUB_CONFIG ) )
		{
			ParseDCHubConfig(node->xmlChildrenNode);
		}
	}

	return 0;
}

/** */
int CConfig::SaveDCHub()
{
	int err=0;
	CString s;
	xmlDocPtr doc;
	xmlNodePtr node,node1;
	CXml xml;

	doc = xmlNewDoc((const xmlChar*)"1.0");

	doc->children = xmlNewDocNode(doc,0,(const xmlChar*)XML_DCHUB_CONFIG,0);

	// bookmarks
	node = xmlNewChild( doc->children, 0, (const xmlChar*)XML_SERVER, 0 );

	DCConfigHubItem *hubitem = 0;

	while( (hubitem=pBookmarkHubList.Next(hubitem)) != 0 )
	{
		node1 = xmlNewChild( node, 0, (const xmlChar*)XML_BOOKMARK, 0 );
		xmlNewChild( node1, 0, (const xmlChar*)XML_NAME,        (const xmlChar*) xml.ToUTF8(hubitem->sName).Data());
		xmlNewChild( node1, 0, (const xmlChar*)XML_HOST,        (const xmlChar*) xml.ToUTF8(hubitem->sHost).Data());
		xmlNewChild( node1, 0, (const xmlChar*)XML_DESCRIPTION, (const xmlChar*) xml.ToUTF8(hubitem->sDescription).Data());
	}

	// store public hub list
	if ( bHubListStoreLocal == TRUE )
	{
		hubitem = 0;

		while( pPublicHubList->Next((CObject*&)hubitem) != 0 )
		{
			node1 = xmlNewChild( node, 0, (const xmlChar*)XML_PUBLIC, 0 );
			xmlNewChild( node1, 0, (const xmlChar*)XML_NAME,        (const xmlChar*) xml.ToUTF8(hubitem->sName).Data() );
			xmlNewChild( node1, 0, (const xmlChar*)XML_HOST,        (const xmlChar*) xml.ToUTF8(hubitem->sHost).Data());
			xmlNewChild( node1, 0, (const xmlChar*)XML_DESCRIPTION, (const xmlChar*) xml.ToUTF8(hubitem->sDescription).Data());
			xmlNewChild( node1, 0, (const xmlChar*)XML_USERCOUNT,   (const xmlChar*) xml.ToUTF8(hubitem->sUserCount).Data());
		}
	}

	// save file
	s = sConfigPath + DCHUB_CONFIG;

	if ( xmlSaveFile(s.Data(),doc) == -1 )
	{
		err = -1;
	}

	xmlFreeDoc(doc);

	return err;
}

/** */
int CConfig::LoadDCTra( CStringList * queue )
{
	CXml xml;
	xmlNodePtr node,c1,c2,c3;
	CString s;
	CStringList * sl1,*sl2;

	s = sConfigPath + DCTRA_CONFIG;

	if ( xml.ParseFile(s) == FALSE )
	{
		return -1;
	}

	for(node=xml.doc()->children;node!=0;node=node->next)
	{
		if ( xml.name(node) == XML_DCTRA_CONFIG )
		{
			for(c1=node->xmlChildrenNode;c1!=0;c1=c1->next)
			{
				if ( xml.name(c1) == XML_TRANSFER )
				{
					DCTransferObject * TransferObject = new DCTransferObject();
					TransferObject->eState = etwsIDLE;
					TransferObject->iConnections = 0;

					for(c2=c1->xmlChildrenNode;c2!=0;c2=c2->next)
					{
						if ( xml.name(c2) == XML_NICK )
							TransferObject->sNick = xml.content(c2);
						else if ( xml.name(c2) == XML_HUBNAME )
							TransferObject->sHubName = xml.content(c2);
						else if ( xml.name(c2) == XML_HUBHOST )
							TransferObject->sHubHost = xml.content(c2);
						else if ( xml.name(c2) == XML_FILE )
						{
							DCTransferFileObject * TransferFileObject = new DCTransferFileObject();
							TransferFileObject->eMedium = eltFILE;
							TransferFileObject->eState  = etfsNONE;

							for(c3=c2->xmlChildrenNode;c3!=0;c3=c3->next)
							{
								if ( xml.name(c3) == XML_REMOTEFILE )
									TransferFileObject->sRemoteFile = xml.content(c3);
								if ( xml.name(c3) == XML_REMOTEFILENAME )
									TransferFileObject->sRemoteFileName = xml.content(c3);
								else if ( xml.name(c3) == XML_STARTPOSITION )
									TransferFileObject->lStartPosition = xml.content(c3).asULL();
								else if ( xml.name(c3) == XML_CURRENTPOSITION )
									TransferFileObject->lCurrentPosition = xml.content(c3).asULL();
								else if ( xml.name(c3) == XML_ENDPOSITION )
									TransferFileObject->lEndPosition = xml.content(c3).asULL();
								else if ( xml.name(c3) == XML_SIZE )
									TransferFileObject->lSize = xml.content(c3).asULL();
								else if ( xml.name(c3) == XML_LOCALPATH )
									TransferFileObject->sLocalPath = xml.content(c3);
								else if ( xml.name(c3) == XML_LOCALNAME )
									TransferFileObject->sLocalName = xml.content(c3);
								else if ( xml.name(c3) == XML_LOCALROOTPATH )
									TransferFileObject->sLocalRootPath = xml.content(c3);
								else if ( xml.name(c3) == XML_MEDIUM )
								{
									if ( xml.content(c3) == XML_MEDIUM_BUFFER )
										TransferFileObject->eMedium = eltBUFFER;
									else
										TransferFileObject->eMedium = eltFILE;
								}
							}

							TransferObject->pTransferFileList.Add( TransferFileObject->sRemoteFile, TransferFileObject );
						}
					}

					if ( TransferObject->pTransferFileList.Count() == 0 )
					{
						delete TransferObject;
					}
					else
					{
						if ( queue->Get( TransferObject->sNick, (CObject*&)sl1 ) == 0 )
						{
							if ( sl1->Get( TransferObject->sHubName, (CObject*&)sl2 ) == 0 )
							{
								printf("load queue: error double entrys !!!!\n");fflush(stdout);
							}
							else
							{
								sl1->Add( TransferObject->sHubName, TransferObject );
							}
						}
						else
						{
							sl1 = new CStringList();
							sl1->Add( TransferObject->sHubName, TransferObject );
							queue->Add( TransferObject->sNick, sl1 );
						}
					}
				}
			}
		}
	}

	return 0;
}

/** */
int CConfig::SaveDCTra( CStringList * queue )
{
	int err;
	CString s;
	xmlDocPtr doc;
	xmlNodePtr node,node1;
	DCTransferObject * TransferObject;
	CStringList * sl1;

	CXml xml;

	err = 0;

	doc = xmlNewDoc((const xmlChar*)"1.0");

	doc->children = xmlNewDocNode(doc,0,(const xmlChar*)XML_DCTRA_CONFIG,0);

	// nick,stringlist
	sl1 = 0;
	while(queue->Next((CObject*&)sl1))
	{
		// hubname,transferobject
		TransferObject = 0;
		while(sl1->Next((CObject*&)TransferObject))
		{
			if ( TransferObject->pTransferFileList.Count() == 0 )
			{
				continue;
			}

			node = xmlNewChild( doc->children, 0, (const xmlChar*)XML_TRANSFER, 0 );

			// store nick,hubhost and hubname
			xmlNewChild( node, 0, (const xmlChar*)XML_NICK,      (const xmlChar*) xml.ToUTF8(TransferObject->sNick).Data());
			xmlNewChild( node, 0, (const xmlChar*)XML_HUBNAME,   (const xmlChar*) xml.ToUTF8(TransferObject->sHubName).Data());
			xmlNewChild( node, 0, (const xmlChar*)XML_HUBHOST,   (const xmlChar*) xml.ToUTF8(TransferObject->sHubHost).Data());

			// save files
			DCTransferFileObject * TransferFileObject = 0;
			while(TransferObject->pTransferFileList.Next((CObject*&)TransferFileObject))
			{
				node1 = xmlNewChild( node, 0, (const xmlChar*)XML_FILE, 0 );

				xmlNewChild( node1, 0, (const xmlChar*)XML_REMOTEFILE, (const xmlChar*) xml.ToUTF8(TransferFileObject->sRemoteFile).Data());
				xmlNewChild( node1, 0, (const xmlChar*)XML_REMOTEFILENAME, (const xmlChar*) xml.ToUTF8(TransferFileObject->sRemoteFileName).Data());
				xmlNewChild( node1, 0, (const xmlChar*)XML_STARTPOSITION,(const xmlChar*) CString().setNum(TransferFileObject->lStartPosition).Data());
				xmlNewChild( node1, 0, (const xmlChar*)XML_CURRENTPOSITION,(const xmlChar*) CString().setNum(TransferFileObject->lCurrentPosition).Data());
				xmlNewChild( node1, 0, (const xmlChar*)XML_ENDPOSITION,(const xmlChar*) CString().setNum(TransferFileObject->lEndPosition).Data());
				xmlNewChild( node1, 0, (const xmlChar*)XML_SIZE,(const xmlChar*) CString().setNum(TransferFileObject->lSize).Data());
				xmlNewChild( node1, 0, (const xmlChar*)XML_LOCALPATH, (const xmlChar*) xml.ToUTF8(TransferFileObject->sLocalPath).Data());
				xmlNewChild( node1, 0, (const xmlChar*)XML_LOCALNAME, (const xmlChar*) xml.ToUTF8(TransferFileObject->sLocalName).Data());
				xmlNewChild( node1, 0, (const xmlChar*)XML_LOCALROOTPATH, (const xmlChar*) xml.ToUTF8(TransferFileObject->sLocalRootPath).Data());

				if(TransferFileObject->eMedium==eltBUFFER)
					s = XML_MEDIUM_BUFFER;
				else
					s = XML_MEDIUM_FILE;			
				xmlNewChild( node1, 0, (const xmlChar*)XML_MEDIUM, (const xmlChar*) xml.ToUTF8(s).Data());
			}
		}
	}

	s = sConfigPath + DCTRA_CONFIG;

	if ( xmlSaveFile(s.Data(),doc) == -1 )
	{
		err = -1;
	}

	xmlFreeDoc(doc);

	return err;
}

/** */
CString CConfig::ParseVersion( CString s )
{
	CString release;
	xmlDocPtr doc;
	xmlNodePtr node,n1,n2;
	xmlChar * c;

	release = "";

	doc = xmlParseMemory(s.Data(),s.Length());

	if ( doc == 0 )
	{
		return "";
	}
	else
	{
		for(node=doc->children;node!=0;node=node->next)
		{
			if ( !xmlStrcmp( node->name, (const xmlChar*)XML_DC ) )
			{
				for(n1=node->xmlChildrenNode;n1!=0;n1=n1->next)
				{
					if ( !xmlStrcmp( n1->name, (const xmlChar*)XML_VERSION ) )
					{
						for(n2=n1->xmlChildrenNode;n2!=0;n2=n2->next)
						{
							if ( !xmlStrcmp( n2->name, (const xmlChar*)XML_RELEASE ) )
							{
								if ( (c = xmlNodeGetContent(n2)) != 0 )
								{
									release = (const char*)c;
									xmlFree(c);
								}
							}
						}
					}
				}
			}
		}

		xmlFreeDoc(doc);
	}

	return release;
}

/** */
void CConfig::ParseDCHubConfig( xmlNodePtr node )
{
	CXml xml;
	xmlNodePtr n1,n2,n3;

	for(n1=node;n1!=0;n1=n1->next)
	{
		/* parse server entrys */
		if ( xml.name(n1) == XML_SERVER )
		{
			for(n2=n1->xmlChildrenNode;n2!=0;n2=n2->next)
			{
				// bookmark hub list
				if ( xml.name(n2) == XML_BOOKMARK )
				{
					DCConfigHubItem * hubitem = new DCConfigHubItem();

					for(n3=n2->xmlChildrenNode;n3!=0;n3=n3->next)
					{
						if ( xml.name(n3) == XML_NAME )
							hubitem->sName = xml.content(n3);
						else if ( xml.name(n3) == XML_HOST )
							hubitem->sHost = xml.content(n3);
						else if ( xml.name(n3) == XML_DESCRIPTION )
							hubitem->sDescription = xml.content(n3);
					}

					pBookmarkHubList.Add(hubitem);
				}
				// public hub list
				else if ( xml.name(n2) == XML_PUBLIC )
				{
					DCConfigHubItem * hubitem = new DCConfigHubItem();

					for(n3=n2->xmlChildrenNode;n3!=0;n3=n3->next)
					{
						if ( xml.name(n3) == XML_NAME )
							hubitem->sName = xml.content(n3);
						else if ( xml.name(n3) == XML_HOST )
							hubitem->sHost = xml.content(n3);
						else if ( xml.name(n3) == XML_DESCRIPTION )
							hubitem->sDescription = xml.content(n3);
						else if ( xml.name(n3) == XML_USERCOUNT )
							hubitem->sUserCount = xml.content(n3);
					}

					pPublicHubList->Add(hubitem->sName,hubitem);
				}
			}
		}
	}
}

/** */
void CConfig::ParseDCLibConfig( xmlNodePtr node )
{
	CXml xml;
	xmlNodePtr n1,n2,n3;

	for(n1=node;n1!=0;n1=n1->next)
	{
		/* parse identify entrys */
		if ( xml.name(n1) == XML_IDENTIFY )
		{
			for(n2=n1->xmlChildrenNode;n2!=0;n2=n2->next)
			{
				if ( xml.name(n2) == XML_NICK )
					sNick = xml.content(n2);
				else if ( xml.name(n2) == XML_EMAIL )
					sEMail = xml.content(n2);
				else if ( xml.name(n2) == XML_ANTISPAM )
				{
					if ( xml.content(n2) == XML_TRUE )
						bAntiSpam = TRUE;
					else
						bAntiSpam = FALSE;
				}
				else if ( xml.name(n2) == XML_DESCRIPTION )
					sDescription = xml.content(n2);
				else if ( xml.name(n2) == XML_SPEED )
					sSpeed = xml.content(n2);
			}
		}
		/* parse transfer entrys */
		else if ( xml.name(n1) == XML_TRANSFER )
		{
			for(n2=n1->xmlChildrenNode;n2!=0;n2=n2->next)
			{
				if ( xml.name(n2) == XML_DOWNLOADFOLDER )
					sDownloadFolder = xml.content(n2);
				else if ( xml.name(n2) == XML_SHAREDFOLDER )
				{
					if ( xml.content(n2) != "" )
						SharedFolders.Add( new CString(xml.content(n2)) );
				}
				else if ( xml.name(n2) == XML_MAXUPLOAD )
					iMaxUpload = xml.content(n2).asINT();
				else if ( xml.name(n2) == XML_MAXTRANSFERRATE )
					lMaxTransferrate = xml.content(n2).asLONG();
			}
		}
		/* parse connection entrys */
		else if ( xml.name(n1) == XML_CONNECTION )
		{
			for(n2=n1->xmlChildrenNode;n2!=0;n2=n2->next)
			{
				if ( xml.name(n2) == XML_MODE )
				{
					if ( xml.content(n2) == XML_MODE_PASSIVE )
						eMode = ecmPassive;
					else
						eMode = ecmActive;
				}
				else if ( xml.name(n2) == XML_TCPLISTENPORT )
					iTCPListenPort = xml.content(n2).asINT();
				else if ( xml.name(n2) == XML_UDPLISTENPORT )
					iUDPListenPort = xml.content(n2).asINT();
				else if ( xml.name(n2) == XML_IP )
					sHost = xml.content(n2);
				else if ( xml.name(n2) == XML_INTERFACE )
					sInterface = xml.content(n2);
				else if ( xml.name(n2) == XML_CHANGEIP )
					iFakeHost = xml.content(n2).asINT();
			}
		}
		/* other entrys */
		else if ( xml.name(n1) == XML_OTHER )
		{
			for(n2=n1->xmlChildrenNode;n2!=0;n2=n2->next)
			{
				if ( xml.name(n2) == XML_HUBLISTSTORELOCAL )
				{
					if ( xml.content(n2) == XML_TRUE )
						bHubListStoreLocal = TRUE;
					else
						bHubListStoreLocal = FALSE;
				}
				else if ( xml.name(n2) == XML_RECONNECTCOUNT )
					iReconnectCount = xml.content(n2).asINT();
				else if ( xml.name(n2) == XML_RECONNECTTIMEOUT )
					iReconnectTimeout = xml.content(n2).asINT();
				else if ( xml.name(n2) == XML_TRANSFERRESPONSETIMEOUT )
					iTransferResponseTimeout = xml.content(n2).asINT();
				else if ( xml.name(n2) == XML_TRANSFERRESENDTIMEOUT )
					iTransferResendTimeout = xml.content(n2).asINT();
				else if ( xml.name(n2) == XML_FORCEMOVEENABLED )
				{
					if ( xml.content(n2) == XML_TRUE )
						bForceMoveEnabled = TRUE;
					else
						bForceMoveEnabled = FALSE;
				}

			}
		}

		/* parse server entrys */
		else if ( xml.name(n1) == XML_HUBLISTURL )
		{
			for(n2=n1->xmlChildrenNode;n2!=0;n2=n2->next)
			{
				if ( xml.name(n2) == XML_URL )
				{
					DCConfigHubListUrl * hublisturl = new DCConfigHubListUrl();

					for(n3=n2->xmlChildrenNode;n3!=0;n3=n3->next)
					{
						if ( xml.name(n3) == XML_NAME )
							hublisturl->sUrl = xml.content(n3);
						else if ( xml.name(n3) == XML_ENABLED )
						{
							if ( xml.content(n3) == XML_TRUE )
								hublisturl->bEnabled = TRUE;
							else
								hublisturl->bEnabled = FALSE;
						}
					}

					pHubListUrlList.Add(hublisturl);
				}
			}
		}
	}
}

/** */
CString CConfig::GetEMail( bool raw )
{
	Thread.Lock();

	CString s;

	s = sEMail;

	if ( (raw == FALSE) && (bAntiSpam==TRUE) )
	{
		s = s.Replace( '@', " at " );
		s = s.Replace( '.', " dot " );
	}

	Thread.UnLock();

	return s;
}

/** */
void CConfig::SetSharedFolders( CList<CString> * list )
{
	CString * s = 0;

	if (!list)
	{
		return;
	}

	SharedFolders.Clear();

	while ( (s=list->Next(s)) != 0 )
	{
		SharedFolders.Add( new CString(*s) );
	}

	return;
}

/** */
long CConfig::GetSharedFolders( CList<CString> * list )
{
	CString * s = 0;

	if (!list)
	{
		return 0;
	}

	list->Clear();

	while ( (s=SharedFolders.Next(s)) != 0 )
	{
		list->Add( new CString(*s) );
	}

	return list->Count();
}

/** */
int CConfig::GetShareBuffer( CByteArray * sharebuffer )
{
	Thread.Lock();

	int err = 0;

	if( (!sharebuffer) || (!pShareBuffer) )
	{
		err = -1;
	}
	else
	{
		sharebuffer->Append(pShareBuffer->Data(),pShareBuffer->Size());
	}

	Thread.UnLock();

	return err;
}

/** */
bool CConfig::RemoveBookmarkHub( CString name, CString host, CString description )
{
	Thread.Lock();

	bool err = FALSE;
	DCConfigHubItem * hubitem;

	hubitem = 0;

	while( (hubitem=pBookmarkHubList.Next(hubitem)) != 0 )
	{
		if ( (name == hubitem->sName) &&
		     (host == hubitem->sHost) &&
		     (description == hubitem->sDescription) )
		{
			pBookmarkHubList.Del(hubitem);
			err = TRUE;
			break;
		}
	}

	Thread.UnLock();

	return err;
}

/** */
bool CConfig::AddBookmarkHub( CString name, CString host, CString description )
{
	Thread.Lock();

	bool err = FALSE;
	DCConfigHubItem * hubitem;

	hubitem = 0;

	while( (hubitem=pBookmarkHubList.Next(hubitem)) != 0 )
	{
		if ( (name == hubitem->sName) &&
		     (host == hubitem->sHost) )
		{
			break;
		}
	}

	if ( hubitem == 0 )
	{
		hubitem = new DCConfigHubItem();

		hubitem->sName = name;
		hubitem->sHost = host;
		hubitem->sDescription = description;
		pBookmarkHubList.Add(hubitem);

		err = TRUE;
	}

	Thread.UnLock();

	return err;
}

/** */
bool CConfig::UpdateBookmarkHub( CString name, CString host, CString description )
{
	Thread.Lock();

	bool err = FALSE;
	DCConfigHubItem * hubitem;

	hubitem = 0;

	while( (hubitem=pBookmarkHubList.Next(hubitem)) != 0 )
	{
		if ( name == hubitem->sName )
		{
			break;
		}
	}

	if ( hubitem != 0 )
	{
		hubitem->sHost = host;
		hubitem->sDescription = description;

		err = TRUE;
	}

	Thread.UnLock();

	return err;
}

/** */
bool CConfig::RemovePublicHub( CString name, CString /*host*/, CString /*description*/ )
{
	Thread.Lock();

	bool err = FALSE;
	DCConfigHubItem * hubitem;

	hubitem = 0;

	if ( pPublicHubList->Get(name,(CObject*&)hubitem) == 0 )
	{
		pPublicHubList->Del(hubitem->sName);
		err = TRUE;
	}

	Thread.UnLock();

	return err;
}

/** */
bool CConfig::AddPublicHub( const CString name, const CString host, const CString description, const CString usercount )
{
	Thread.Lock();

	bool badd = TRUE;
	DCConfigHubItem * hubitem;

	hubitem = 0;

	if ( pPublicHubList->Get(name,(CObject*&)hubitem) == 0 )
	{
		// update
		hubitem->sHost        = host;
		hubitem->sDescription = description;
		hubitem->sUserCount   = usercount;
		badd = FALSE;
	}

	if ( badd == TRUE )
	{
		hubitem = new DCConfigHubItem();

		hubitem->sName = name;
		hubitem->sHost = host;
		hubitem->sDescription = description;
		hubitem->sUserCount = usercount;
		pPublicHubList->Add(name,hubitem);
	}

	Thread.UnLock();

	return badd;
}

/** */
CString CConfig::GetTCPHostString()
{
	Thread.Lock();

	CSocket Socket;
	CString s,h;

	if ( iFakeHost == 1 )
	{
		s = sHost;
	}
	else
	{
		s = Socket.GetInterfaceIP( sInterface.Data() );
	}

	if ( s != "" )
	{
		h = CSocket::GetHostByName(s);

		if ( h != "" )
		{
			s = h + ":" + CString().setNum(iTCPListenPort).Data();
		}
		else
		{
			s = "";
		}
	}

	Thread.UnLock();

	return s.Data();
}

/** */
CString CConfig::GetUDPHostString()
{
	Thread.Lock();

	CSocket Socket;
	CString s,h;

	if ( iFakeHost == 1 )
	{
		s = sHost;
	}
	else
	{
		s = Socket.GetInterfaceIP( sInterface.Data() );
	}

	if ( s != "" )
	{
		h = CSocket::GetHostByName(s);

		if ( h != "" )
		{
			s = h + ":" + CString().setNum(iUDPListenPort).Data();
		}
		else
		{
			s = "";
		}
	}

	Thread.UnLock();

	return s.Data();
}

/** */
long CConfig::GetBookmarkHubList( CList<DCConfigHubItem> * list )
{
	DCConfigHubItem * item = 0, *newitem;

	if (!list)
	{
		return 0;
	}

	list->Clear();

	while ( (item=pBookmarkHubList.Next(item)) != 0 )
	{
		newitem = new DCConfigHubItem();

		newitem->sDescription = item->sDescription;
		newitem->sHost        = item->sHost;
		newitem->sName        = item->sName,
		newitem->sUserCount   = item->sUserCount;

		list->Add(newitem);
	}

	return list->Count();
}

/** */
long CConfig::GetPublicHubList( CList<DCConfigHubItem> * list )
{
	DCConfigHubItem * item = 0, *newitem;

	if (!list)
	{
		return 0;
	}

	list->Clear();

	while ( pPublicHubList->Next((CObject*&)item) != 0 )
	{
		newitem = new DCConfigHubItem();

		newitem->sDescription = item->sDescription;
		newitem->sHost        = item->sHost;
		newitem->sName        = item->sName,
		newitem->sUserCount   = item->sUserCount;

		list->Add(newitem);
	}

	return list->Count();
}

/** */
long CConfig::GetHubListUrlList( CList<DCConfigHubListUrl> * list )
{
	DCConfigHubListUrl * item = 0, *newitem;

	if (!list)
	{
		return 0;
	}

	list->Clear();

	while ( (item=pHubListUrlList.Next(item)) != 0 )
	{
		newitem = new DCConfigHubListUrl();

		newitem->bEnabled = item->bEnabled;
		newitem->sUrl     = item->sUrl;

		list->Add(newitem);
	}

	return list->Count();
}

/** */
void CConfig::SetHubListUrlList( CList<DCConfigHubListUrl> * list )
{
	DCConfigHubListUrl * item = 0, *newitem;

	pHubListUrlList.Clear();

	if (!list)
	{
		return;
	}

	while ( (item=list->Next(item)) != 0 )
	{
		newitem = new DCConfigHubListUrl();

		newitem->bEnabled = item->bEnabled;
		newitem->sUrl     = item->sUrl;

		pHubListUrlList.Add(newitem);
	}

	return;
}

/** */
void CConfig::CreateShareList()
{
	CDir dir;
	CString s,s1;
	CByteArray * ba;
	CHE3 he3;

	iShareSize   = 0;
	sShareBuffer = "";

	if ( pShareBuffer != 0 )
	{
		delete pShareBuffer;
		pShareBuffer = 0;
	}

	if ( SharedFolders.Count() <= 0 )
	{
		return;
	}

	CString *it = 0;

	while( (it=SharedFolders.Next(it)) != 0 )
	{
		// directory
		s = (*it);

		// is valid ?
		if ( dir.cd(s.Data()) == TRUE )
		{
			s  = dir.Path();
			s1 = dir.DirName();

			if ( s1 != "" )
			{
				s = s.Left( s.Length()-s1.Length() );
			}

			CreateShareList( 0, s, s1 );
		}
	}

	if ( "" != sShareBuffer )
	{
		ba = he3.encode_he3_data(&sShareBuffer);

		if ( ba != 0 )
		{
			pShareBuffer = ba;
		}
	}
}

/** */
void CConfig::CreateShareList( int depth, CString base, CString curr )
{
	CDir dir;
	CList<CFileInfo> list;
	CString d;
	CString path;
	CFileInfo *fileinfo;
	int x,z;

	if (base=="")
		path = curr;
	else
		path = base+DIRSEPARATOR+curr;

	dir.SetPath(path);

	d = "";
	z = depth;

//	printf("%s\n",curr.Data());

	// create depth string
	if ( curr != "" )
	{
		for(x=0;x<depth;x++) d+="\x9";
		z++;
		sShareBuffer += d + curr + "\xd\xa";
		d += "\x9";
	}

	// get all files
	if ( dir.ReadEntrys( CDir::Files, &list ) )
	{
		// add files
		fileinfo = 0;
		while( (fileinfo=list.Next(fileinfo)) != 0 )
		{
			if ( fileinfo->name != "" )
			{
				iShareSize   += fileinfo->size;
				sShareBuffer += d + fileinfo->name + "|" + CString().setNum(fileinfo->size) + "\xd\xa";
			}
		}
	}

	// get all dirs
	if ( dir.ReadEntrys( CDir::Dirs, &list ) )
	{
		// add dir
		fileinfo = 0;
		while( (fileinfo=list.Next(fileinfo)) != 0 )
		{
			if ( (fileinfo->name != ".") && (fileinfo->name != "..") )
			{

				CreateShareList(z,path,fileinfo->name);
			}
		}
	}
}
