/***************************************************************************
                          cclient.h  -  description
                             -------------------
    begin                : Sun Sep 30 2001
    copyright            : (C) 2001 by Mathias Kster
    email                : mathen@ketelhot.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef CCLIENT_H
#define CCLIENT_H

/**
  *@author Mathias Kster
  */

#include <dclib/dcos.h>
#include <dclib/cstring.h>
#include <dclib/cmessagehandler.h>
#include <dclib/cconnection.h>
#include <dclib/cstringlist.h>

class CClient;
class CObject;

typedef int (*ClientCallBack) ( CClient * Client, CObject * Object );

class DLL_EXPORT CClient : public CConnection {

public:
	/** */
	CClient();
	/** */
	virtual ~CClient();

	/** */
	void SetNick( CString nick );
	/** */
	CString GetNick() const;
	/** */
	void SetEMail( CString email );
	/** */
	CString GetEMail() const;
	/** */
	void SetConnectionType( CString ctype );
	/** */
	CString GetConnectionType() const;
	/** */
	void SetComment( CString comment );
	/** */
	CString GetComment() const;
	/** */
	void SetHubName( CString hubname );
	/** */
	CString GetHubName() const;
	/** */
	void SetShareSize( CString sharesize );
	/** */
	CString GetShareSize() const;
	/** */
	void SetVersion( CString version );
	/** */
	CString GetVersion() const;
	/** */
	void SetMode( eClientMode mode );
	/** */
	eClientMode GetMode() const;
	/** */
	void SetAwayMode( eUserAwayMode mode );
	/** */
	eUserAwayMode GetAwayMode() const;
	/** */
	bool IsHandshake() const;
	/** */
	bool IsAdmin() const;
	/** */
	void SetHandleUserList( bool handleuserlist );
	/** */
	ulonglong GetHubShareSize() const;

	/** user list functions */
	void InitUserList( CMessageNickList * NickList );
	/** */
	void InitOperatorList( CMessageNickList * NickList );
	/** */
	void AppendUser( CString nick );
	/** */
	void RemoveUser( CString nick );
	/** */
	bool UpdateUser( CMessageMyInfo * pMyInfo );
	/** */
	bool IsUserOnline( CString nick );

	/** */
	void SetCallBackFunction( ClientCallBack callbackfunction );

	/** */
	int HandleMessage( const CString message );

	/** */
	virtual void DataAvailable( const char * buffer, int len );
	/** */
	virtual void DataTimeout();
	/** */
	virtual void ConnectionState( eConnectionState state );
	/** callback function */
	virtual int DC_CallBack( CObject * ) { return -1; };

private:
	/** */
	CString sNick;
	/** */
	CString sEMail;
	/** */
	CString sConnectionType;
	/** */
	CString sComment;
	/** */
	CString sHubName;
	/** */
	CString sShareSize;
	/** */
	CString sVersion;
	/** */
	eClientMode ecMode;
	/** */
	bool bHandshake;
	/** */
	bool bAdmin;
	/** */
	bool bHandleUserList;
	/** */
	eUserAwayMode eAwayMode;
	/** */
	ulonglong lHubShareSize;
	/** */
	CStringList * pUserList;
	/** */
	CString sBuffer;
	/** callback function */
	ClientCallBack CallBack;
	/** */
	CThread ClientThread;
};

/** inline functions */

/** */
inline void CClient::SetNick( CString nick )
{ ClientThread.Lock(); sNick=nick; ClientThread.UnLock(); }
/** */
inline CString CClient::GetNick() const
{ return sNick; }
/** */
inline void CClient::SetEMail( CString email )
{ ClientThread.Lock(); sEMail=email; ClientThread.UnLock(); }
/** */
inline CString CClient::GetEMail() const
{ return sEMail; }
/** */
inline void CClient::SetConnectionType( CString ctype )
{ ClientThread.Lock(); sConnectionType=ctype; ClientThread.UnLock(); }
/** */
inline CString CClient::GetConnectionType() const
{ return sConnectionType; }
/** */
inline void CClient::SetComment( CString comment )
{ ClientThread.Lock(); sComment=comment; ClientThread.UnLock(); }
/** */
inline CString CClient::GetComment() const
{ return sComment; }
/** */
inline void CClient::SetHubName( CString hubname )
{ ClientThread.Lock(); sHubName = hubname; ClientThread.UnLock(); }
/** */
inline CString CClient::GetHubName() const
{ return sHubName; }
/** */
inline void CClient::SetShareSize( CString sharesize )
{ ClientThread.Lock(); sShareSize = sharesize; ClientThread.UnLock(); }
/** */
inline CString CClient::GetShareSize() const
{ return sShareSize; }
/** */
inline void CClient::SetVersion( CString version )
{ ClientThread.Lock(); sVersion = version; ClientThread.UnLock(); }
/** */
inline CString CClient::GetVersion() const
{ return sVersion; }
/** */
inline void CClient::SetMode( eClientMode mode )
{ ClientThread.Lock(); ecMode=mode; ClientThread.UnLock(); }
/** */
inline eClientMode CClient::GetMode() const
{ return ecMode; }
/** */
inline bool CClient::IsHandshake() const
{ return bHandshake; }
/** */
inline void CClient::SetCallBackFunction( ClientCallBack callbackfunction )
{ ClientThread.Lock(); CallBack = callbackfunction; ClientThread.UnLock(); }
/** */
inline bool CClient::IsAdmin() const
{ return bAdmin; }
/** */
inline void CClient::SetHandleUserList( bool handleuserlist )
{ ClientThread.Lock(); bHandleUserList = handleuserlist; ClientThread.UnLock(); }
/** */
inline ulonglong CClient::GetHubShareSize() const
{ return lHubShareSize; }
/** */
inline void CClient::SetAwayMode( eUserAwayMode mode )
{ ClientThread.Lock(); eAwayMode = mode; ClientThread.UnLock(); }
/** */
inline eUserAwayMode CClient::GetAwayMode() const
{ return eAwayMode; }

#endif
